/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import lcmc.gui.Browser;
import lcmc.gui.resources.Info;
import lcmc.utilities.Tools;

public class ViewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JSplitPane viewSP = null;
    private static final Dimension MENU_TREE_MIN_SIZE = new Dimension(200, 200);
    private static final Dimension INFO_PANEL_MIN_SIZE = new Dimension(200, 200);
    private static final Dimension MENU_TREE_SIZE = new Dimension(400, 200);
    private static final int DIVIDER_LOCATION = 200;
    private volatile boolean disabledDuringLoad = true;
    private final Lock mSetPanelLock = new ReentrantLock();
    private Info lastSelectedInfo = null;

    ViewPanel() {
        super(new BorderLayout());
        this.setBackground(Tools.getDefaultColor("ViewPanel.Status.Background"));
    }

    final JTree getTree(final Browser browser) {
        final JTree tree = new JTree(browser.getTreeModel());
        browser.setTree(tree);
        tree.setOpaque(true);
        tree.setBackground(Tools.getDefaultColor("ViewPanel.Background"));
        tree.setToggleClickCount(2);
        tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Info nodeInfo;
                int selRow = tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getButton() > 1 && (nodeInfo = (Info)((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject()) != null) {
                    nodeInfo.showPopup(tree, e.getX(), e.getY());
                    tree.setSelectionPath(selPath);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setCellRenderer(browser.getCellRenderer());
        JScrollPane resourcesTreePane = new JScrollPane(tree);
        JPanel resourceInfo = new JPanel();
        this.viewSP = new JSplitPane(1, resourcesTreePane, resourceInfo);
        resourcesTreePane.setMinimumSize(MENU_TREE_MIN_SIZE);
        resourceInfo.setMinimumSize(INFO_PANEL_MIN_SIZE);
        this.viewSP.setDividerLocation(200);
        this.viewSP.setPreferredSize(MENU_TREE_SIZE);
        this.add(this.viewSP);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ViewPanel.this.setRightComponentInView(tree, ViewPanel.this.viewSP, browser);
            }
        });
        tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                Object[] selected;
                if (!ViewPanel.this.disabledDuringLoad && (selected = e.getChildren()) != null && selected.length > 0) {
                    Object o = ((DefaultMutableTreeNode)selected[0]).getUserObject();
                    ViewPanel.this.setRightComponentInView(browser, (Info)o);
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                Object[] path = e.getPath();
                if (!ViewPanel.this.disabledDuringLoad) {
                    final TreePath tp = new TreePath(path);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            tree.expandPath(tp);
                            tree.setSelectionPath(tp);
                        }
                    });
                }
            }
        });
        return tree;
    }

    final boolean isDisabledDuringLoad() {
        return this.disabledDuringLoad;
    }

    public final void setDisabledDuringLoad(boolean disabledDuringLoad) {
        this.disabledDuringLoad = disabledDuringLoad;
    }

    private void setRightComponentInView(JTree tree, final JSplitPane viewSP, final Browser browser) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.getParent() == null) {
            return;
        }
        final Object nodeInfo = node.getUserObject();
        if (nodeInfo instanceof Info) {
            this.lastSelectedInfo = (Info)nodeInfo;
        }
        if (nodeInfo != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ViewPanel.this.mSetPanelLock.tryLock()) {
                        return;
                    }
                    JComponent p = browser.getInfoPanel(nodeInfo, ViewPanel.this.disabledDuringLoad);
                    if (!ViewPanel.this.disabledDuringLoad) {
                        int loc = viewSP.getDividerLocation();
                        viewSP.setRightComponent(p);
                        viewSP.setDividerLocation(loc);
                    }
                    ViewPanel.this.mSetPanelLock.unlock();
                }
            });
        }
    }

    final void setRightComponentInView(final Browser browser, final Info nodeInfo) {
        if (this.viewSP != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ViewPanel.this.mSetPanelLock.tryLock()) {
                        return;
                    }
                    JComponent p = browser.getInfoPanel(nodeInfo, ViewPanel.this.disabledDuringLoad);
                    ViewPanel.this.lastSelectedInfo = nodeInfo;
                    if (!ViewPanel.this.disabledDuringLoad && p != null) {
                        int loc = ViewPanel.this.viewSP.getDividerLocation();
                        ViewPanel.this.viewSP.setRightComponent(p);
                        ViewPanel.this.viewSP.setDividerLocation(loc);
                    }
                    ViewPanel.this.mSetPanelLock.unlock();
                }
            });
        }
    }

    public final void reloadRightComponent() {
        Info lsi = this.lastSelectedInfo;
        if (lsi != null) {
            lsi.selectMyself();
        }
    }

    public final Info getLastSelectedInfo() {
        return this.lastSelectedInfo;
    }
}

