/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import lcmc.data.Cluster;
import lcmc.gui.ClusterViewPanel;
import lcmc.gui.EmptyViewPanel;
import lcmc.utilities.Tools;

public final class ClusterTab
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Cluster cluster;

    ClusterTab(Cluster cluster) {
        super(new BorderLayout());
        this.setBackground(Tools.getDefaultColor("ViewPanel.Status.Background"));
        this.cluster = cluster;
        if (cluster == null) {
            EmptyViewPanel p = new EmptyViewPanel();
            p.setDisabledDuringLoad(false);
            this.add(p);
        }
    }

    public void addClusterView() {
        if (this.cluster.hostsCount() > 0) {
            this.add(new ClusterViewPanel(this.cluster));
        }
        this.repaint();
    }

    Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public String getName() {
        if (this.cluster == null) {
            return null;
        }
        return this.cluster.getName();
    }
}

