/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.jai;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.jai.AbstractPerspectiveTransformSupport;
import edu.uci.ics.jung.visualization.jai.PerspectiveShapeTransformer;
import edu.uci.ics.jung.visualization.jai.TransformingImageVertexIconRenderer;
import edu.uci.ics.jung.visualization.picking.ViewLensShapePickSupport;
import edu.uci.ics.jung.visualization.renderers.BasicRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.transform.shape.TransformingGraphics;
import javax.media.jai.PerspectiveTransform;

public class PerspectiveImageLensSupport<V, E>
extends AbstractPerspectiveTransformSupport<V, E> {
    protected RenderContext<V, E> renderContext;
    protected GraphicsDecorator lensGraphicsDecorator;
    protected GraphicsDecorator savedGraphicsDecorator;
    protected Renderer<V, E> renderer;
    protected Renderer<V, E> transformingRenderer;
    protected GraphElementAccessor<V, E> pickSupport;
    static final String instructions = "";

    public PerspectiveImageLensSupport(VisualizationViewer<V, E> vv) {
        super(vv);
        this.renderContext = vv.getRenderContext();
        this.pickSupport = this.renderContext.getPickSupport();
        this.renderer = vv.getRenderer();
        this.transformingRenderer = new BasicRenderer();
        this.perspectiveTransformer = new PerspectiveShapeTransformer(new PerspectiveTransform(), vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW));
        this.transformingRenderer.setVertexRenderer(new TransformingImageVertexIconRenderer());
        this.lensGraphicsDecorator = new TransformingGraphics(this.perspectiveTransformer);
        this.savedGraphicsDecorator = this.renderContext.getGraphicsContext();
        this.renderer = vv.getRenderer();
    }

    @Override
    public void activate() {
        this.lens = new AbstractPerspectiveTransformSupport.Lens(this.perspectiveTransformer, this.vv.getSize());
        this.renderContext.setPickSupport(new ViewLensShapePickSupport(this.vv));
        this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(Layer.VIEW, this.perspectiveTransformer);
        this.vv.getRenderContext().setGraphicsContext(this.lensGraphicsDecorator);
        this.vv.setRenderer(this.transformingRenderer);
        this.vv.addPreRenderPaintable(this.lens);
        this.vv.setToolTipText(instructions);
        this.vv.repaint();
    }

    @Override
    public void deactivate() {
        this.renderContext.setPickSupport(this.pickSupport);
        this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(Layer.VIEW, this.perspectiveTransformer.getDelegate());
        this.vv.removePreRenderPaintable(this.lens);
        this.vv.getRenderContext().setGraphicsContext(this.savedGraphicsDecorator);
        this.vv.setRenderer(this.renderer);
        this.vv.setToolTipText(this.defaultToolTipText);
        this.vv.repaint();
    }
}

