/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.transformation;

import edu.uci.ics.jung.algorithms.blockmodel.VertexPartition;
import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.MapTransformer;

public class VertexPartitionCollapser<V, E, CV, CE> {
    protected Factory<Graph<CV, CE>> graph_factory;
    protected Factory<CV> vertex_factory;
    protected Factory<CE> edge_factory;
    protected Map<Set<V>, CV> set_collapsedv;

    public VertexPartitionCollapser(Factory<Graph<CV, CE>> graph_factory, Factory<CV> vertex_factory, Factory<CE> edge_factory) {
        this.graph_factory = graph_factory;
        this.vertex_factory = vertex_factory;
        this.edge_factory = edge_factory;
        this.set_collapsedv = new HashMap<Set<V>, CV>();
    }

    public Graph<CV, CE> collapseVertexPartitions(VertexPartition<V, E> partitioning) {
        Graph<V, Set<Object>> original = partitioning.getGraph();
        Graph<CV, CE> collapsed = this.graph_factory.create();
        for (Set<V> set : partitioning.getVertexPartitions()) {
            CV cv = this.vertex_factory.create();
            collapsed.addVertex(this.vertex_factory.create());
            this.set_collapsedv.put(set, cv);
        }
        for (Set<Object> e : original.getEdges()) {
            Collection incident = original.getIncidentVertices(e);
            HashSet<CV> collapsed_vertices = new HashSet<CV>();
            Map<V, Set<V>> vertex_partitions = partitioning.getVertexToPartitionMap();
            for (Object v : incident) {
                collapsed_vertices.add(this.set_collapsedv.get(vertex_partitions.get(v)));
            }
            if (collapsed_vertices.size() <= 1) continue;
            CE ce = this.edge_factory.create();
            collapsed.addEdge(ce, collapsed_vertices);
        }
        return collapsed;
    }

    public Transformer<Set<V>, CV> getSetToCollapsedVertexTransformer() {
        return MapTransformer.getInstance(this.set_collapsedv);
    }
}

