/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.cglib;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.AssertionFailedError;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.jmock.core.AbstractDynamicMock;
import org.jmock.core.Invocation;
import org.jmock.core.InvocationDispatcher;
import org.jmock.core.LIFOInvocationDispatcher;

public class CGLIBCoreMock
extends AbstractDynamicMock
implements MethodInterceptor {
    private static NamingPolicy NAMING_POLICY = new DefaultNamingPolicy(){

        public String getClassName(String string, String string2, Object object, Predicate predicate) {
            return "org.jmock.codegen." + super.getClassName(string, string2, object, predicate);
        }
    };
    private Object proxy = null;

    public CGLIBCoreMock(Class clazz, String string) {
        this(clazz, string, (InvocationDispatcher)new LIFOInvocationDispatcher());
    }

    public CGLIBCoreMock(Class clazz, String string, Class[] classArray, Object[] objectArray) {
        this(clazz, string, classArray, objectArray, (InvocationDispatcher)new LIFOInvocationDispatcher());
    }

    public CGLIBCoreMock(Class clazz, String string, InvocationDispatcher invocationDispatcher) {
        this(clazz, string, new Class[0], new Object[0], invocationDispatcher);
    }

    public CGLIBCoreMock(Class clazz, String string, Class[] classArray, Object[] objectArray, InvocationDispatcher invocationDispatcher) {
        super(clazz, string, invocationDispatcher);
        this.checkIsNotNonStaticInnerClass(clazz);
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(clazz.getClassLoader());
        enhancer.setSuperclass(clazz);
        enhancer.setCallback((Callback)this);
        enhancer.setNamingPolicy(NAMING_POLICY);
        this.proxy = enhancer.create(classArray, objectArray);
    }

    private void checkIsNotNonStaticInnerClass(Class clazz) {
        if (clazz.getDeclaringClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
            throw new AssertionFailedError("cannot mock non-static inner class " + clazz.getName());
        }
    }

    public Object proxy() {
        return this.proxy;
    }

    public Object intercept(Object object, Method method, Object[] objectArray, MethodProxy methodProxy) throws Throwable {
        return this.proxy == null ? methodProxy.invokeSuper(object, objectArray) : this.mockInvocation(new Invocation(this.proxy, method, objectArray));
    }
}

