/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.stub;

import junit.framework.Assert;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public class ThrowStub
extends Assert
implements Stub {
    private Throwable throwable;

    public ThrowStub(Throwable throwable) {
        this.throwable = throwable;
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        if (this.isThrowingCheckedException()) {
            this.checkTypeCompatiblity(invocation.invokedMethod.getExceptionTypes());
        }
        this.throwable.fillInStackTrace();
        throw this.throwable;
    }

    @Override
    public StringBuffer describeTo(StringBuffer stringBuffer) {
        return stringBuffer.append("throws <").append(this.throwable).append(">");
    }

    private void checkTypeCompatiblity(Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isInstance(this.throwable)) continue;
            return;
        }
        this.reportIncompatibleCheckedException(classArray);
    }

    private void reportIncompatibleCheckedException(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("tried to throw a ");
        stringBuffer.append(this.throwable.getClass().getName());
        stringBuffer.append(" from a method that throws ");
        if (classArray.length == 0) {
            stringBuffer.append("no exceptions");
        } else {
            for (int i = 0; i < classArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(classArray[i].getName());
            }
        }
        ThrowStub.fail((String)stringBuffer.toString());
    }

    private boolean isThrowingCheckedException() {
        return !(this.throwable instanceof RuntimeException) && !(this.throwable instanceof Error);
    }
}

