/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.constraint;

import java.util.Map;
import org.jmock.core.Constraint;

public class IsMapContaining
implements Constraint {
    private final Constraint keyConstraint;
    private final Constraint valueConstraint;

    public IsMapContaining(Constraint constraint, Constraint constraint2) {
        this.keyConstraint = constraint;
        this.valueConstraint = constraint2;
    }

    @Override
    public boolean eval(Object object) {
        if (object != null && object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                if (!this.keyConstraint.eval(entry.getKey()) || !this.valueConstraint.eval(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public StringBuffer describeTo(StringBuffer stringBuffer) {
        stringBuffer.append("map containing [");
        this.keyConstraint.describeTo(stringBuffer);
        stringBuffer.append("->");
        this.valueConstraint.describeTo(stringBuffer);
        stringBuffer.append("]");
        return stringBuffer;
    }
}

