/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;

public abstract class DNSTask
extends TimerTask {
    private final JmDNSImpl _jmDNSImpl;

    protected DNSTask(JmDNSImpl jmDNSImpl) {
        this._jmDNSImpl = jmDNSImpl;
    }

    public JmDNSImpl getDns() {
        return this._jmDNSImpl;
    }

    public abstract void start(Timer var1);

    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    public DNSOutgoing addQuestion(DNSOutgoing dNSOutgoing, DNSQuestion dNSQuestion) throws IOException {
        DNSOutgoing dNSOutgoing2 = dNSOutgoing;
        try {
            dNSOutgoing2.addQuestion(dNSQuestion);
        }
        catch (IOException iOException) {
            int n = dNSOutgoing2.getFlags();
            boolean bl = dNSOutgoing2.isMulticast();
            int n2 = dNSOutgoing2.getMaxUDPPayload();
            int n3 = dNSOutgoing2.getId();
            dNSOutgoing2.setFlags(n | 0x200);
            dNSOutgoing2.setId(n3);
            this._jmDNSImpl.send(dNSOutgoing2);
            dNSOutgoing2 = new DNSOutgoing(n, bl, n2);
            dNSOutgoing2.addQuestion(dNSQuestion);
        }
        return dNSOutgoing2;
    }

    public DNSOutgoing addAnswer(DNSOutgoing dNSOutgoing, DNSIncoming dNSIncoming, DNSRecord dNSRecord) throws IOException {
        DNSOutgoing dNSOutgoing2 = dNSOutgoing;
        try {
            dNSOutgoing2.addAnswer(dNSIncoming, dNSRecord);
        }
        catch (IOException iOException) {
            int n = dNSOutgoing2.getFlags();
            boolean bl = dNSOutgoing2.isMulticast();
            int n2 = dNSOutgoing2.getMaxUDPPayload();
            int n3 = dNSOutgoing2.getId();
            dNSOutgoing2.setFlags(n | 0x200);
            dNSOutgoing2.setId(n3);
            this._jmDNSImpl.send(dNSOutgoing2);
            dNSOutgoing2 = new DNSOutgoing(n, bl, n2);
            dNSOutgoing2.addAnswer(dNSIncoming, dNSRecord);
        }
        return dNSOutgoing2;
    }

    public DNSOutgoing addAnswer(DNSOutgoing dNSOutgoing, DNSRecord dNSRecord, long l) throws IOException {
        DNSOutgoing dNSOutgoing2 = dNSOutgoing;
        try {
            dNSOutgoing2.addAnswer(dNSRecord, l);
        }
        catch (IOException iOException) {
            int n = dNSOutgoing2.getFlags();
            boolean bl = dNSOutgoing2.isMulticast();
            int n2 = dNSOutgoing2.getMaxUDPPayload();
            int n3 = dNSOutgoing2.getId();
            dNSOutgoing2.setFlags(n | 0x200);
            dNSOutgoing2.setId(n3);
            this._jmDNSImpl.send(dNSOutgoing2);
            dNSOutgoing2 = new DNSOutgoing(n, bl, n2);
            dNSOutgoing2.addAnswer(dNSRecord, l);
        }
        return dNSOutgoing2;
    }

    public DNSOutgoing addAuthoritativeAnswer(DNSOutgoing dNSOutgoing, DNSRecord dNSRecord) throws IOException {
        DNSOutgoing dNSOutgoing2 = dNSOutgoing;
        try {
            dNSOutgoing2.addAuthorativeAnswer(dNSRecord);
        }
        catch (IOException iOException) {
            int n = dNSOutgoing2.getFlags();
            boolean bl = dNSOutgoing2.isMulticast();
            int n2 = dNSOutgoing2.getMaxUDPPayload();
            int n3 = dNSOutgoing2.getId();
            dNSOutgoing2.setFlags(n | 0x200);
            dNSOutgoing2.setId(n3);
            this._jmDNSImpl.send(dNSOutgoing2);
            dNSOutgoing2 = new DNSOutgoing(n, bl, n2);
            dNSOutgoing2.addAuthorativeAnswer(dNSRecord);
        }
        return dNSOutgoing2;
    }

    public DNSOutgoing addAdditionalAnswer(DNSOutgoing dNSOutgoing, DNSIncoming dNSIncoming, DNSRecord dNSRecord) throws IOException {
        DNSOutgoing dNSOutgoing2 = dNSOutgoing;
        try {
            dNSOutgoing2.addAdditionalAnswer(dNSIncoming, dNSRecord);
        }
        catch (IOException iOException) {
            int n = dNSOutgoing2.getFlags();
            boolean bl = dNSOutgoing2.isMulticast();
            int n2 = dNSOutgoing2.getMaxUDPPayload();
            int n3 = dNSOutgoing2.getId();
            dNSOutgoing2.setFlags(n | 0x200);
            dNSOutgoing2.setId(n3);
            this._jmDNSImpl.send(dNSOutgoing2);
            dNSOutgoing2 = new DNSOutgoing(n, bl, n2);
            dNSOutgoing2.addAdditionalAnswer(dNSIncoming, dNSRecord);
        }
        return dNSOutgoing2;
    }
}

