/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.constants;

import java.util.logging.Level;
import java.util.logging.Logger;

public enum DNSRecordClass {
    CLASS_UNKNOWN("?", 0),
    CLASS_IN("in", 1),
    CLASS_CS("cs", 2),
    CLASS_CH("ch", 3),
    CLASS_HS("hs", 4),
    CLASS_NONE("none", 254),
    CLASS_ANY("any", 255);

    private static Logger logger;
    public static final int CLASS_MASK = Short.MAX_VALUE;
    public static final int CLASS_UNIQUE = 32768;
    public static final boolean UNIQUE = true;
    public static final boolean NOT_UNIQUE = false;
    private final String _externalName;
    private final int _index;

    private DNSRecordClass(String string2, int n2) {
        this._externalName = string2;
        this._index = n2;
    }

    public String externalName() {
        return this._externalName;
    }

    public int indexValue() {
        return this._index;
    }

    public boolean isUnique(int n) {
        return this != CLASS_UNKNOWN && (n & 0x8000) != 0;
    }

    public static DNSRecordClass classForName(String string) {
        if (string != null) {
            String string2 = string.toLowerCase();
            for (DNSRecordClass dNSRecordClass : DNSRecordClass.values()) {
                if (!dNSRecordClass._externalName.equals(string2)) continue;
                return dNSRecordClass;
            }
        }
        logger.log(Level.WARNING, "Could not find record class for name: " + string);
        return CLASS_UNKNOWN;
    }

    public static DNSRecordClass classForIndex(int n) {
        int n2 = n & Short.MAX_VALUE;
        for (DNSRecordClass dNSRecordClass : DNSRecordClass.values()) {
            if (dNSRecordClass._index != n2) continue;
            return dNSRecordClass;
        }
        logger.log(Level.WARNING, "Could not find record class for index: " + n);
        return CLASS_UNKNOWN;
    }

    public String toString() {
        return this.name() + " index " + this.indexValue();
    }

    static {
        logger = Logger.getLogger(DNSRecordClass.class.getName());
    }
}

