/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.NetworkTopologyDiscovery;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSStatefulObject;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

public class HostInfo
implements DNSStatefulObject {
    private static Logger logger = Logger.getLogger(HostInfo.class.getName());
    protected String _name;
    protected InetAddress _address;
    protected NetworkInterface _interfaze;
    private final HostInfoState _state;
    private int hostNameCount;

    public static HostInfo newHostInfo(InetAddress inetAddress, JmDNSImpl jmDNSImpl, String string) {
        HostInfo hostInfo = null;
        String string2 = "";
        InetAddress inetAddress2 = inetAddress;
        try {
            if (inetAddress2 == null) {
                String string3 = System.getProperty("net.mdns.interface");
                if (string3 != null) {
                    inetAddress2 = InetAddress.getByName(string3);
                } else {
                    InetAddress[] inetAddressArray;
                    inetAddress2 = InetAddress.getLocalHost();
                    if (inetAddress2.isLoopbackAddress() && (inetAddressArray = NetworkTopologyDiscovery.Factory.getInstance().getInetAddresses()).length > 0) {
                        inetAddress2 = inetAddressArray[0];
                    }
                }
                string2 = inetAddress2.getHostName();
                if (inetAddress2.isLoopbackAddress()) {
                    logger.warning("Could not find any address beside the loopback.");
                }
            } else {
                string2 = inetAddress2.getHostName();
            }
            if (string2.contains("in-addr.arpa") || string2.equals(inetAddress2.getHostAddress())) {
                string2 = string != null && string.length() > 0 ? string : inetAddress2.getHostAddress();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Could not intialize the host network interface on " + inetAddress + "because of an error: " + iOException.getMessage(), iOException);
            inetAddress2 = HostInfo.loopbackAddress();
            string2 = string != null && string.length() > 0 ? string : "computer";
        }
        string2 = string2.replace('.', '-');
        string2 = string2 + ".local.";
        hostInfo = new HostInfo(inetAddress2, string2, jmDNSImpl);
        return hostInfo;
    }

    private static InetAddress loopbackAddress() {
        try {
            return InetAddress.getByName(null);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private HostInfo(InetAddress inetAddress, String string, JmDNSImpl jmDNSImpl) {
        this._state = new HostInfoState(jmDNSImpl);
        this._address = inetAddress;
        this._name = string;
        if (inetAddress != null) {
            try {
                this._interfaze = NetworkInterface.getByInetAddress(inetAddress);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "LocalHostInfo() exception ", exception);
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public InetAddress getInetAddress() {
        return this._address;
    }

    Inet4Address getInet4Address() {
        if (this.getInetAddress() instanceof Inet4Address) {
            return (Inet4Address)this._address;
        }
        return null;
    }

    Inet6Address getInet6Address() {
        if (this.getInetAddress() instanceof Inet6Address) {
            return (Inet6Address)this._address;
        }
        return null;
    }

    public NetworkInterface getInterface() {
        return this._interfaze;
    }

    public boolean conflictWithRecord(DNSRecord.Address address) {
        DNSRecord.Address address2 = this.getDNSAddressRecord(address.getRecordType(), address.isUnique(), 3600);
        if (address2 != null) {
            return address2.sameType(address) && address2.sameName(address) && !address2.sameValue(address);
        }
        return false;
    }

    synchronized String incrementHostName() {
        ++this.hostNameCount;
        int n = this._name.indexOf(".local.");
        int n2 = this._name.lastIndexOf(45);
        this._name = this._name.substring(0, n2 == -1 ? n : n2) + "-" + this.hostNameCount + ".local.";
        return this._name;
    }

    boolean shouldIgnorePacket(DatagramPacket datagramPacket) {
        InetAddress inetAddress;
        boolean bl = false;
        if (this.getInetAddress() != null && (inetAddress = datagramPacket.getAddress()) != null) {
            if (inetAddress.isLinkLocalAddress() && !this.getInetAddress().isLinkLocalAddress()) {
                bl = true;
            }
            if (inetAddress.isLoopbackAddress() && !this.getInetAddress().isLoopbackAddress()) {
                bl = true;
            }
        }
        return bl;
    }

    DNSRecord.Address getDNSAddressRecord(DNSRecordType dNSRecordType, boolean bl, int n) {
        switch (dNSRecordType) {
            case TYPE_A: {
                return this.getDNS4AddressRecord(bl, n);
            }
            case TYPE_A6: 
            case TYPE_AAAA: {
                return this.getDNS6AddressRecord(bl, n);
            }
        }
        return null;
    }

    private DNSRecord.Address getDNS4AddressRecord(boolean bl, int n) {
        if (this.getInetAddress() instanceof Inet4Address || this.getInetAddress() instanceof Inet6Address && ((Inet6Address)this.getInetAddress()).isIPv4CompatibleAddress()) {
            return new DNSRecord.IPv4Address(this.getName(), DNSRecordClass.CLASS_IN, bl, n, this.getInetAddress());
        }
        return null;
    }

    private DNSRecord.Address getDNS6AddressRecord(boolean bl, int n) {
        if (this.getInetAddress() instanceof Inet6Address) {
            return new DNSRecord.IPv6Address(this.getName(), DNSRecordClass.CLASS_IN, bl, n, this.getInetAddress());
        }
        return null;
    }

    DNSRecord.Pointer getDNSReverseAddressRecord(DNSRecordType dNSRecordType, boolean bl, int n) {
        switch (dNSRecordType) {
            case TYPE_A: {
                return this.getDNS4ReverseAddressRecord(bl, n);
            }
            case TYPE_A6: 
            case TYPE_AAAA: {
                return this.getDNS6ReverseAddressRecord(bl, n);
            }
        }
        return null;
    }

    private DNSRecord.Pointer getDNS4ReverseAddressRecord(boolean bl, int n) {
        if (this.getInetAddress() instanceof Inet4Address) {
            return new DNSRecord.Pointer(this.getInetAddress().getHostAddress() + ".in-addr.arpa.", DNSRecordClass.CLASS_IN, bl, n, this.getName());
        }
        if (this.getInetAddress() instanceof Inet6Address && ((Inet6Address)this.getInetAddress()).isIPv4CompatibleAddress()) {
            byte[] byArray = this.getInetAddress().getAddress();
            String string = (byArray[12] & 0xFF) + "." + (byArray[13] & 0xFF) + "." + (byArray[14] & 0xFF) + "." + (byArray[15] & 0xFF);
            return new DNSRecord.Pointer(string + ".in-addr.arpa.", DNSRecordClass.CLASS_IN, bl, n, this.getName());
        }
        return null;
    }

    private DNSRecord.Pointer getDNS6ReverseAddressRecord(boolean bl, int n) {
        if (this.getInetAddress() instanceof Inet6Address) {
            return new DNSRecord.Pointer(this.getInetAddress().getHostAddress() + ".ip6.arpa.", DNSRecordClass.CLASS_IN, bl, n, this.getName());
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("local host info[");
        stringBuilder.append(this.getName() != null ? this.getName() : "no name");
        stringBuilder.append(", ");
        stringBuilder.append(this.getInterface() != null ? this.getInterface().getDisplayName() : "???");
        stringBuilder.append(":");
        stringBuilder.append(this.getInetAddress() != null ? this.getInetAddress().getHostAddress() : "no address");
        stringBuilder.append(", ");
        stringBuilder.append(this._state);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public Collection<DNSRecord> answers(boolean bl, int n) {
        ArrayList<DNSRecord> arrayList = new ArrayList<DNSRecord>();
        DNSRecord.Address address = this.getDNS4AddressRecord(bl, n);
        if (address != null) {
            arrayList.add(address);
        }
        if ((address = this.getDNS6AddressRecord(bl, n)) != null) {
            arrayList.add(address);
        }
        return arrayList;
    }

    @Override
    public JmDNSImpl getDns() {
        return this._state.getDns();
    }

    @Override
    public boolean advanceState(DNSTask dNSTask) {
        return this._state.advanceState(dNSTask);
    }

    @Override
    public void removeAssociationWithTask(DNSTask dNSTask) {
        this._state.removeAssociationWithTask(dNSTask);
    }

    @Override
    public boolean revertState() {
        return this._state.revertState();
    }

    @Override
    public void associateWithTask(DNSTask dNSTask, DNSState dNSState) {
        this._state.associateWithTask(dNSTask, dNSState);
    }

    @Override
    public boolean isAssociatedWithTask(DNSTask dNSTask, DNSState dNSState) {
        return this._state.isAssociatedWithTask(dNSTask, dNSState);
    }

    @Override
    public boolean cancelState() {
        return this._state.cancelState();
    }

    @Override
    public boolean closeState() {
        return this._state.closeState();
    }

    @Override
    public boolean recoverState() {
        return this._state.recoverState();
    }

    @Override
    public boolean isProbing() {
        return this._state.isProbing();
    }

    @Override
    public boolean isAnnouncing() {
        return this._state.isAnnouncing();
    }

    @Override
    public boolean isAnnounced() {
        return this._state.isAnnounced();
    }

    @Override
    public boolean isCanceling() {
        return this._state.isCanceling();
    }

    @Override
    public boolean isCanceled() {
        return this._state.isCanceled();
    }

    @Override
    public boolean isClosing() {
        return this._state.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this._state.isClosed();
    }

    @Override
    public boolean waitForAnnounced(long l) {
        return this._state.waitForAnnounced(l);
    }

    @Override
    public boolean waitForCanceled(long l) {
        if (this._address == null) {
            return true;
        }
        return this._state.waitForCanceled(l);
    }

    private static final class HostInfoState
    extends DNSStatefulObject.DefaultImplementation {
        private static final long serialVersionUID = -8191476803620402088L;

        public HostInfoState(JmDNSImpl jmDNSImpl) {
            this.setDns(jmDNSImpl);
        }
    }
}

