/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSMessage;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.constants.DNSConstants;
import javax.jmdns.impl.constants.DNSLabel;
import javax.jmdns.impl.constants.DNSOptionCode;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSResultCode;

public final class DNSIncoming
extends DNSMessage {
    private static Logger logger = Logger.getLogger(DNSIncoming.class.getName());
    public static boolean USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET = true;
    private final DatagramPacket _packet;
    private final long _receivedTime;
    private final MessageInputStream _messageInputStream;
    private int _senderUDPPayload;
    private static final char[] _nibbleToHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public DNSIncoming(DatagramPacket datagramPacket) throws IOException {
        super(0, 0, datagramPacket.getPort() == DNSConstants.MDNS_PORT);
        this._packet = datagramPacket;
        InetAddress inetAddress = datagramPacket.getAddress();
        this._messageInputStream = new MessageInputStream(datagramPacket.getData(), datagramPacket.getLength());
        this._receivedTime = System.currentTimeMillis();
        this._senderUDPPayload = 1460;
        try {
            DNSRecord dNSRecord;
            int n;
            this.setId(this._messageInputStream.readUnsignedShort());
            this.setFlags(this._messageInputStream.readUnsignedShort());
            int n2 = this._messageInputStream.readUnsignedShort();
            int n3 = this._messageInputStream.readUnsignedShort();
            int n4 = this._messageInputStream.readUnsignedShort();
            int n5 = this._messageInputStream.readUnsignedShort();
            if (n2 > 0) {
                for (n = 0; n < n2; ++n) {
                    this._questions.add(this.readQuestion());
                }
            }
            if (n3 > 0) {
                for (n = 0; n < n3; ++n) {
                    dNSRecord = this.readAnswer(inetAddress);
                    if (dNSRecord == null) continue;
                    this._answers.add(dNSRecord);
                }
            }
            if (n4 > 0) {
                for (n = 0; n < n4; ++n) {
                    dNSRecord = this.readAnswer(inetAddress);
                    if (dNSRecord == null) continue;
                    this._authoritativeAnswers.add(dNSRecord);
                }
            }
            if (n5 > 0) {
                for (n = 0; n < n5; ++n) {
                    dNSRecord = this.readAnswer(inetAddress);
                    if (dNSRecord == null) continue;
                    this._additionals.add(dNSRecord);
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "DNSIncoming() dump " + this.print(true) + "\n exception ", exception);
            IOException iOException = new IOException("DNSIncoming corrupted message");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    private DNSIncoming(int n, int n2, boolean bl, DatagramPacket datagramPacket, long l) {
        super(n, n2, bl);
        this._packet = datagramPacket;
        this._messageInputStream = new MessageInputStream(datagramPacket.getData(), datagramPacket.getLength());
        this._receivedTime = l;
    }

    public DNSIncoming clone() {
        DNSIncoming dNSIncoming = new DNSIncoming(this.getFlags(), this.getId(), this.isMulticast(), this._packet, this._receivedTime);
        dNSIncoming._senderUDPPayload = this._senderUDPPayload;
        dNSIncoming._questions.addAll(this._questions);
        dNSIncoming._answers.addAll(this._answers);
        dNSIncoming._authoritativeAnswers.addAll(this._authoritativeAnswers);
        dNSIncoming._additionals.addAll(this._additionals);
        return dNSIncoming;
    }

    private DNSQuestion readQuestion() {
        String string = this._messageInputStream.readName();
        DNSRecordType dNSRecordType = DNSRecordType.typeForIndex(this._messageInputStream.readUnsignedShort());
        if (dNSRecordType == DNSRecordType.TYPE_IGNORE) {
            logger.log(Level.SEVERE, "Could not find record type: " + this.print(true));
        }
        int n = this._messageInputStream.readUnsignedShort();
        DNSRecordClass dNSRecordClass = DNSRecordClass.classForIndex(n);
        boolean bl = dNSRecordClass.isUnique(n);
        return DNSQuestion.newQuestion(string, dNSRecordType, dNSRecordClass, bl);
    }

    private DNSRecord readAnswer(InetAddress inetAddress) {
        DNSRecordClass dNSRecordClass;
        String string = this._messageInputStream.readName();
        DNSRecordType dNSRecordType = DNSRecordType.typeForIndex(this._messageInputStream.readUnsignedShort());
        if (dNSRecordType == DNSRecordType.TYPE_IGNORE) {
            logger.log(Level.SEVERE, "Could not find record type. domain: " + string + "\n" + this.print(true));
        }
        int n = this._messageInputStream.readUnsignedShort();
        DNSRecordClass dNSRecordClass2 = dNSRecordClass = dNSRecordType == DNSRecordType.TYPE_OPT ? DNSRecordClass.CLASS_UNKNOWN : DNSRecordClass.classForIndex(n);
        if (dNSRecordClass == DNSRecordClass.CLASS_UNKNOWN && dNSRecordType != DNSRecordType.TYPE_OPT) {
            logger.log(Level.SEVERE, "Could not find record class. domain: " + string + " type: " + (Object)((Object)dNSRecordType) + "\n" + this.print(true));
        }
        boolean bl = dNSRecordClass.isUnique(n);
        int n2 = this._messageInputStream.readInt();
        int n3 = this._messageInputStream.readUnsignedShort();
        DNSRecord dNSRecord = null;
        block1 : switch (dNSRecordType) {
            case TYPE_A: {
                dNSRecord = new DNSRecord.IPv4Address(string, dNSRecordClass, bl, n2, this._messageInputStream.readBytes(n3));
                break;
            }
            case TYPE_AAAA: {
                dNSRecord = new DNSRecord.IPv6Address(string, dNSRecordClass, bl, n2, this._messageInputStream.readBytes(n3));
                break;
            }
            case TYPE_CNAME: 
            case TYPE_PTR: {
                String string2 = "";
                string2 = this._messageInputStream.readName();
                if (string2.length() > 0) {
                    dNSRecord = new DNSRecord.Pointer(string, dNSRecordClass, bl, n2, string2);
                    break;
                }
                logger.log(Level.WARNING, "PTR record of class: " + (Object)((Object)dNSRecordClass) + ", there was a problem reading the service name of the answer for domain:" + string);
                break;
            }
            case TYPE_TXT: {
                dNSRecord = new DNSRecord.Text(string, dNSRecordClass, bl, n2, this._messageInputStream.readBytes(n3));
                break;
            }
            case TYPE_SRV: {
                int n4 = this._messageInputStream.readUnsignedShort();
                int n5 = this._messageInputStream.readUnsignedShort();
                int n6 = this._messageInputStream.readUnsignedShort();
                String string3 = "";
                string3 = USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET ? this._messageInputStream.readName() : this._messageInputStream.readNonNameString();
                dNSRecord = new DNSRecord.Service(string, dNSRecordClass, bl, n2, n4, n5, n6, string3);
                break;
            }
            case TYPE_HINFO: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this._messageInputStream.readUTF(n3));
                int n7 = stringBuilder.indexOf(" ");
                String string4 = (n7 > 0 ? stringBuilder.substring(0, n7) : stringBuilder.toString()).trim();
                String string5 = (n7 > 0 ? stringBuilder.substring(n7 + 1) : "").trim();
                dNSRecord = new DNSRecord.HostInformation(string, dNSRecordClass, bl, n2, string4, string5);
                break;
            }
            case TYPE_OPT: {
                DNSResultCode dNSResultCode = DNSResultCode.resultCodeForFlags(this.getFlags(), n2);
                int n8 = (n2 & 0xFF0000) >> 16;
                if (n8 == 0) {
                    this._senderUDPPayload = n;
                    while (this._messageInputStream.available() > 0) {
                        int n9 = 0;
                        DNSOptionCode dNSOptionCode = null;
                        if (this._messageInputStream.available() < 2) {
                            logger.log(Level.WARNING, "There was a problem reading the OPT record. Ignoring.");
                            break block1;
                        }
                        n9 = this._messageInputStream.readUnsignedShort();
                        dNSOptionCode = DNSOptionCode.resultCodeForFlags(n9);
                        int n10 = 0;
                        if (this._messageInputStream.available() < 2) {
                            logger.log(Level.WARNING, "There was a problem reading the OPT record. Ignoring.");
                            break block1;
                        }
                        n10 = this._messageInputStream.readUnsignedShort();
                        byte[] byArray = new byte[]{};
                        if (this._messageInputStream.available() >= n10) {
                            byArray = this._messageInputStream.readBytes(n10);
                        }
                        switch (dNSOptionCode) {
                            case Owner: {
                                byte by = 0;
                                byte by2 = 0;
                                byte[] byArray2 = null;
                                byte[] byArray3 = null;
                                byte[] byArray4 = null;
                                try {
                                    by = byArray[0];
                                    by2 = byArray[1];
                                    byArray3 = byArray2 = new byte[]{byArray[2], byArray[3], byArray[4], byArray[5], byArray[6], byArray[7]};
                                    if (byArray.length > 8) {
                                        byArray3 = new byte[]{byArray[8], byArray[9], byArray[10], byArray[11], byArray[12], byArray[13]};
                                    }
                                    if (byArray.length == 18) {
                                        byArray4 = new byte[]{byArray[14], byArray[15], byArray[16], byArray[17]};
                                    }
                                    if (byArray.length == 22) {
                                        byArray4 = new byte[]{byArray[14], byArray[15], byArray[16], byArray[17], byArray[18], byArray[19], byArray[20], byArray[21]};
                                    }
                                }
                                catch (Exception exception) {
                                    logger.warning("Malformed OPT answer. Option code: Owner data: " + this._hexString(byArray));
                                }
                                if (!logger.isLoggable(Level.FINE)) break;
                                logger.fine("Unhandled Owner OPT version: " + by + " sequence: " + by2 + " MAC address: " + this._hexString(byArray2) + (byArray3 != byArray2 ? " wakeup MAC address: " + this._hexString(byArray3) : "") + (byArray4 != null ? " password: " + this._hexString(byArray4) : ""));
                                break;
                            }
                            case LLQ: 
                            case NSID: 
                            case UL: {
                                if (!logger.isLoggable(Level.FINE)) break;
                                logger.log(Level.FINE, "There was an OPT answer. Option code: " + (Object)((Object)dNSOptionCode) + " data: " + this._hexString(byArray));
                                break;
                            }
                            case Unknown: {
                                logger.log(Level.WARNING, "There was an OPT answer. Not currently handled. Option code: " + n9 + " data: " + this._hexString(byArray));
                                break;
                            }
                        }
                    }
                    break;
                }
                logger.log(Level.WARNING, "There was an OPT answer. Wrong version number: " + n8 + " result code: " + (Object)((Object)dNSResultCode));
                break;
            }
            default: {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("DNSIncoming() unknown type:" + (Object)((Object)dNSRecordType));
                }
                this._messageInputStream.skip(n3);
            }
        }
        if (dNSRecord != null) {
            dNSRecord.setRecordSource(inetAddress);
        }
        return dNSRecord;
    }

    String print(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.print());
        if (bl) {
            byte[] byArray = new byte[this._packet.getLength()];
            System.arraycopy(this._packet.getData(), 0, byArray, 0, byArray.length);
            stringBuilder.append(this.print(byArray));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.isQuery() ? "dns[query," : "dns[response,");
        if (this._packet.getAddress() != null) {
            stringBuilder.append(this._packet.getAddress().getHostAddress());
        }
        stringBuilder.append(':');
        stringBuilder.append(this._packet.getPort());
        stringBuilder.append(", length=");
        stringBuilder.append(this._packet.getLength());
        stringBuilder.append(", id=0x");
        stringBuilder.append(Integer.toHexString(this.getId()));
        if (this.getFlags() != 0) {
            stringBuilder.append(", flags=0x");
            stringBuilder.append(Integer.toHexString(this.getFlags()));
            if ((this.getFlags() & 0x8000) != 0) {
                stringBuilder.append(":r");
            }
            if ((this.getFlags() & 0x400) != 0) {
                stringBuilder.append(":aa");
            }
            if ((this.getFlags() & 0x200) != 0) {
                stringBuilder.append(":tc");
            }
        }
        if (this.getNumberOfQuestions() > 0) {
            stringBuilder.append(", questions=");
            stringBuilder.append(this.getNumberOfQuestions());
        }
        if (this.getNumberOfAnswers() > 0) {
            stringBuilder.append(", answers=");
            stringBuilder.append(this.getNumberOfAnswers());
        }
        if (this.getNumberOfAuthorities() > 0) {
            stringBuilder.append(", authorities=");
            stringBuilder.append(this.getNumberOfAuthorities());
        }
        if (this.getNumberOfAdditionals() > 0) {
            stringBuilder.append(", additionals=");
            stringBuilder.append(this.getNumberOfAdditionals());
        }
        if (this.getNumberOfQuestions() > 0) {
            stringBuilder.append("\nquestions:");
            for (DNSEntry dNSEntry : this._questions) {
                stringBuilder.append("\n\t");
                stringBuilder.append(dNSEntry);
            }
        }
        if (this.getNumberOfAnswers() > 0) {
            stringBuilder.append("\nanswers:");
            for (DNSEntry dNSEntry : this._answers) {
                stringBuilder.append("\n\t");
                stringBuilder.append(dNSEntry);
            }
        }
        if (this.getNumberOfAuthorities() > 0) {
            stringBuilder.append("\nauthorities:");
            for (DNSEntry dNSEntry : this._authoritativeAnswers) {
                stringBuilder.append("\n\t");
                stringBuilder.append(dNSEntry);
            }
        }
        if (this.getNumberOfAdditionals() > 0) {
            stringBuilder.append("\nadditionals:");
            for (DNSEntry dNSEntry : this._additionals) {
                stringBuilder.append("\n\t");
                stringBuilder.append(dNSEntry);
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    void append(DNSIncoming dNSIncoming) {
        if (!(this.isQuery() && this.isTruncated() && dNSIncoming.isQuery())) {
            throw new IllegalArgumentException();
        }
        this._questions.addAll(dNSIncoming.getQuestions());
        this._answers.addAll(dNSIncoming.getAnswers());
        this._authoritativeAnswers.addAll(dNSIncoming.getAuthorities());
        this._additionals.addAll(dNSIncoming.getAdditionals());
    }

    public int elapseSinceArrival() {
        return (int)(System.currentTimeMillis() - this._receivedTime);
    }

    public int getSenderUDPPayload() {
        return this._senderUDPPayload;
    }

    private String _hexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            stringBuilder.append(_nibbleToHex[n / 16]);
            stringBuilder.append(_nibbleToHex[n % 16]);
        }
        return stringBuilder.toString();
    }

    public static class MessageInputStream
    extends ByteArrayInputStream {
        private static Logger logger1 = Logger.getLogger(MessageInputStream.class.getName());
        final Map<Integer, String> _names = new HashMap<Integer, String>();

        public MessageInputStream(byte[] byArray, int n) {
            this(byArray, 0, n);
        }

        public MessageInputStream(byte[] byArray, int n, int n2) {
            super(byArray, n, n2);
        }

        public int readByte() {
            return this.read();
        }

        public int readUnsignedShort() {
            return this.read() << 8 | this.read();
        }

        public int readInt() {
            return this.readUnsignedShort() << 16 | this.readUnsignedShort();
        }

        public byte[] readBytes(int n) {
            byte[] byArray = new byte[n];
            this.read(byArray, 0, n);
            return byArray;
        }

        public String readUTF(int n) {
            StringBuilder stringBuilder = new StringBuilder(n);
            for (int i = 0; i < n; ++i) {
                int n2 = this.read();
                switch (n2 >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        break;
                    }
                    case 12: 
                    case 13: {
                        n2 = (n2 & 0x1F) << 6 | this.read() & 0x3F;
                        ++i;
                        break;
                    }
                    case 14: {
                        n2 = (n2 & 0xF) << 12 | (this.read() & 0x3F) << 6 | this.read() & 0x3F;
                        ++i;
                        ++i;
                        break;
                    }
                    default: {
                        n2 = (n2 & 0x3F) << 4 | this.read() & 0xF;
                        ++i;
                    }
                }
                stringBuilder.append((char)n2);
            }
            return stringBuilder.toString();
        }

        protected synchronized int peek() {
            return this.pos < this.count ? this.buf[this.pos] & 0xFF : -1;
        }

        public String readName() {
            HashMap<Integer, StringBuilder> hashMap = new HashMap<Integer, StringBuilder>();
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            block5: while (!bl) {
                int n = this.read();
                if (n == 0) {
                    bl = true;
                    break;
                }
                switch (DNSLabel.labelForByte(n)) {
                    case Standard: {
                        int n2 = this.pos - 1;
                        String string = this.readUTF(n) + ".";
                        stringBuilder.append(string);
                        for (CharSequence charSequence : hashMap.values()) {
                            ((StringBuilder)charSequence).append(string);
                        }
                        hashMap.put(n2, new StringBuilder(string));
                        continue block5;
                    }
                    case Compressed: {
                        CharSequence charSequence;
                        int n3 = DNSLabel.labelValue(n) << 8 | this.read();
                        charSequence = this._names.get(n3);
                        if (charSequence == null) {
                            logger1.severe("bad domain name: possible circular name detected. Bad offset: 0x" + Integer.toHexString(n3) + " at 0x" + Integer.toHexString(this.pos - 2));
                            charSequence = "";
                        }
                        stringBuilder.append((String)charSequence);
                        for (StringBuilder stringBuilder2 : hashMap.values()) {
                            stringBuilder2.append((String)charSequence);
                        }
                        bl = true;
                        continue block5;
                    }
                    case Extended: {
                        logger1.severe("Extended label are not currently supported.");
                        continue block5;
                    }
                }
                logger1.severe("unsupported dns label type: '" + Integer.toHexString(n & 0xC0) + "'");
            }
            for (Integer n : hashMap.keySet()) {
                this._names.put(n, ((StringBuilder)hashMap.get(n)).toString());
            }
            return stringBuilder.toString();
        }

        public String readNonNameString() {
            int n = this.read();
            return this.readUTF(n);
        }
    }
}

