/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;

public class ScreenInformation {
    public static Rectangle getScreenBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle bounds = new Rectangle();
        for (GraphicsDevice gd : ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            bounds = bounds.union(gc.getBounds());
        }
        return bounds;
    }

    public static boolean isTitleOnScreen(Rectangle window) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        boolean leftInside = false;
        boolean rightInside = false;
        Point topLeft = new Point(window.x, window.y);
        Point topRight = new Point(window.x + window.width, window.y);
        for (GraphicsDevice gd : ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            if (gc.getBounds().contains(topLeft)) {
                leftInside = true;
            }
            if (gc.getBounds().contains(topRight)) {
                rightInside = true;
            }
            if (!leftInside || !rightInside) continue;
            return true;
        }
        return leftInside && rightInside;
    }
}

