/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.IrcAccountID;

public class IrcAccountIDTest
extends TestCase {
    public void testConstructNullHost() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        try {
            IrcAccountID account = new IrcAccountID("user", null, "6667", properties);
            Assert.fail((String)"Should have failed with IAE.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructNullPort() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        try {
            IrcAccountID account = new IrcAccountID("user", "host", null, properties);
            Assert.fail((String)"Should have failed with IAE.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testServiceNameMinimal() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        IrcAccountID account = new IrcAccountID("user", "host", "6667", properties);
        Assert.assertEquals((String)"IRC", (String)account.getService());
        Assert.assertEquals((String)"user@host:6667 (IRC)", (String)account.getDisplayName());
    }

    public void testServiceNameWithHost() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        properties.put("SERVER_ADDRESS", "localhost");
        IrcAccountID account = new IrcAccountID("user", "localhost", "6667", properties);
        Assert.assertEquals((String)"localhost", (String)account.getService());
        Assert.assertEquals((String)"user@localhost:6667 (IRC)", (String)account.getDisplayName());
    }

    public void testServiceNameWithHostAndPort() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        properties.put("SERVER_ADDRESS", "localhost");
        properties.put("SERVER_PORT", "6667");
        IrcAccountID account = new IrcAccountID("user", "host", "6667", properties);
        Assert.assertEquals((String)"localhost:6667", (String)account.getService());
        Assert.assertEquals((String)"user@host:6667 (IRC)", (String)account.getDisplayName());
    }

    public void testCorrectConstruction() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        IrcAccountID account = new IrcAccountID("user", "host", "6667", properties);
        Assert.assertEquals((String)"user", (String)account.getUserID());
        Assert.assertEquals((String)"host", (String)account.getHost());
        Assert.assertEquals((int)6667, (int)account.getPort());
    }

    public void testEqualsSame() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        IrcAccountID account = new IrcAccountID("user", "host", "6667", properties);
        Assert.assertTrue((boolean)account.equals((Object)account));
    }

    public void testEqualsNull() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        IrcAccountID account = new IrcAccountID("user", "host", "6667", properties);
        Assert.assertFalse((boolean)account.equals(null));
    }

    public void testEqualsOtherClassInstance() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        IrcAccountID account = new IrcAccountID("user", "host", "6667", properties);
        Assert.assertFalse((boolean)account.equals(new Object()));
    }

    public void testEqualsOtherUser() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        IrcAccountID account = new IrcAccountID("user", "host", "6667", properties);
        IrcAccountID account2 = new IrcAccountID("other-user", "host", "6667", properties);
        Assert.assertFalse((boolean)account.equals((Object)account2));
    }

    public void testEqualsOtherHost() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        IrcAccountID account = new IrcAccountID("user", "host", "6667", properties);
        IrcAccountID account2 = new IrcAccountID("user", "other-host", "6667", properties);
        Assert.assertFalse((boolean)account.equals((Object)account2));
    }

    public void testEqualsOtherPort() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        IrcAccountID account = new IrcAccountID("user", "host", "6667", properties);
        IrcAccountID account2 = new IrcAccountID("user", "host", "6697", properties);
        Assert.assertFalse((boolean)account.equals((Object)account2));
    }

    public void testHashCodeExecutes() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        IrcAccountID account = new IrcAccountID("user", "host", "6667", properties);
        account.hashCode();
    }

    public void testAccountDisplayNamePropertySet() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        properties.put("SERVER_ADDRESS", "localhost");
        properties.put("SERVER_PORT", "6667");
        properties.put("ACCOUNT_DISPLAY_NAME", "my-IRC-account-name");
        IrcAccountID account = new IrcAccountID("user", "host", "6667", properties);
        Assert.assertEquals((String)"my-IRC-account-name", (String)account.getDisplayName());
    }

    public void testAccountDisplayNamePropertySetButEmpty() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        properties.put("SERVER_ADDRESS", "localhost");
        properties.put("SERVER_PORT", "6667");
        properties.put("ACCOUNT_DISPLAY_NAME", "");
        IrcAccountID account = new IrcAccountID("user", "host", "6667", properties);
        Assert.assertEquals((String)"user@host:6667 (IRC)", (String)account.getDisplayName());
    }
}

