/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.irc.Command;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.exception.BadCommandException;
import net.java.sip.communicator.impl.protocol.irc.exception.UnsupportedCommandException;
import net.java.sip.communicator.util.Logger;

public class CommandFactory {
    private static final Logger LOGGER = Logger.getLogger(CommandFactory.class);
    private static final Map<String, Class<? extends Command>> COMMANDS = new HashMap<String, Class<? extends Command>>();
    private final ProtocolProviderServiceIrcImpl provider;
    private final IrcConnection connection;

    public static synchronized Map<String, Class<? extends Command>> getCommands() {
        return new HashMap<String, Class<? extends Command>>(COMMANDS);
    }

    public static synchronized void registerCommand(String command, Class<? extends Command> type) {
        if (command == null) {
            throw new IllegalArgumentException("command cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        COMMANDS.put(command, type);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Registered command '" + command + "' (" + type.toString() + ")"));
        }
    }

    public static synchronized void unregisterCommand(Class<? extends Command> type, String command) {
        Iterator<Map.Entry<String, Class<? extends Command>>> it = COMMANDS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Class<? extends Command>> entry = it.next();
            if (entry.getValue() != type || command != null && !command.equals(entry.getKey())) continue;
            it.remove();
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("Unregistered command '" + entry.getKey() + "' (" + type.toString() + ")"));
        }
    }

    CommandFactory(ProtocolProviderServiceIrcImpl provider, IrcConnection connection) {
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.provider = provider;
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        this.connection = connection;
    }

    public Command createCommand(String command) throws UnsupportedCommandException, BadCommandException {
        if (command == null || command.isEmpty()) {
            throw new IllegalArgumentException("command cannot be null or empty");
        }
        Class<? extends Command> type = COMMANDS.get(command);
        if (type == null) {
            throw new UnsupportedCommandException(command);
        }
        try {
            Constructor<? extends Command> cmdCtor = type.getConstructor(ProtocolProviderServiceIrcImpl.class, IrcConnection.class);
            return cmdCtor.newInstance(new Object[]{this.provider, this.connection});
        }
        catch (NoSuchMethodException e) {
            throw new BadCommandException(command, type, "There is no compatible constructor for instantiating this command.", e);
        }
        catch (InstantiationException e) {
            throw new BadCommandException(command, type, "Unable to instantiate this command class.", e);
        }
        catch (IllegalAccessException e) {
            throw new BadCommandException(command, type, "Unable to access the constructor of this command class.", e);
        }
        catch (InvocationTargetException e) {
            throw new BadCommandException(command, type, "An exception occurred while executing the constructor.", e);
        }
        catch (IllegalArgumentException e) {
            throw new BadCommandException(command, type, "Invalid arguments were passed to the constructor. This may be a bug in the CommandFactory implementation.", e);
        }
    }
}

