/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

import java.net.URI;
import org.jitsi.service.neomedia.MediaDirection;

public class RTPExtension {
    public static final String CSRC_AUDIO_LEVEL_URN = "urn:ietf:params:rtp-hdrext:csrc-audio-level";
    public static final String SSRC_AUDIO_LEVEL_URN = "urn:ietf:params:rtp-hdrext:ssrc-audio-level";
    public static final String ABS_SEND_TIME_URN = "http://www.webrtc.org/experiments/rtp-hdrext/abs-send-time";
    public static final String FRAME_MARKING_URN = "urn:ietf:params:rtp-hdrext:framemarking";
    private MediaDirection direction = MediaDirection.SENDRECV;
    private final URI extensionURI;
    private String extensionAttributes = null;

    public RTPExtension(URI extensionURI) {
        this(extensionURI, MediaDirection.SENDRECV);
    }

    public RTPExtension(URI extensionURI, MediaDirection direction) {
        this(extensionURI, direction, null);
    }

    public RTPExtension(URI extensionURI, String extensionAttributes) {
        this(extensionURI, MediaDirection.SENDRECV, extensionAttributes);
    }

    public RTPExtension(URI extensionURI, MediaDirection direction, String extensionAttributes) {
        this.extensionURI = extensionURI;
        this.direction = direction;
        this.extensionAttributes = extensionAttributes;
    }

    public MediaDirection getDirection() {
        return this.direction;
    }

    public URI getURI() {
        return this.extensionURI;
    }

    public String getExtensionAttributes() {
        return this.extensionAttributes;
    }

    public String toString() {
        return this.extensionURI.toString() + ";" + (Object)((Object)this.getDirection());
    }

    public boolean equals(Object o) {
        return o instanceof RTPExtension && ((RTPExtension)o).getURI().equals(this.getURI());
    }

    public int hashCode() {
        return this.getURI().hashCode();
    }
}

