/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.net.InetSocketAddress;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.util.Logger;

public class DebugTransformEngine
implements TransformEngine {
    private static final Logger logger = Logger.getLogger(DebugTransformEngine.class);
    private final MediaStreamImpl mediaStream;
    private final PacketLoggingService _pktLogging;
    private final SinglePacketTransformer rtcpTransformer = new MyRTCPPacketTransformer();
    private final SinglePacketTransformer rtpTransformer = new MyRTPPacketTransformer();

    DebugTransformEngine(MediaStreamImpl mediaStream, PacketLoggingService pktLogging) {
        this.mediaStream = mediaStream;
        this._pktLogging = pktLogging;
    }

    public static DebugTransformEngine createDebugTransformEngine(MediaStreamImpl mediaStream) {
        PacketLoggingService pktLogging = LibJitsi.getPacketLoggingService();
        if (pktLogging != null && pktLogging.isLoggingEnabled(PacketLoggingService.ProtocolName.ARBITRARY)) {
            return new DebugTransformEngine(mediaStream, pktLogging);
        }
        return null;
    }

    @Override
    public SinglePacketTransformer getRTCPTransformer() {
        return this.rtcpTransformer;
    }

    @Override
    public SinglePacketTransformer getRTPTransformer() {
        return this.rtpTransformer;
    }

    private RawPacket transform(RawPacket pkt, boolean data, boolean sender) {
        byte[] byArray;
        byte[] byArray2;
        InetSocketAddress dst;
        InetSocketAddress src;
        if (pkt == null) {
            return null;
        }
        if (this.mediaStream == null) {
            logger.warn("Not logging a packet because the mediaStream is null");
            return pkt;
        }
        PacketLoggingService pktLogging = this._pktLogging;
        if (pktLogging == null) {
            logger.warn("Not logging a packet because the PacketLoggingService is null.");
            return pkt;
        }
        if (data) {
            InetSocketAddress localDataAddress = this.mediaStream.getLocalDataAddress();
            if (localDataAddress == null) {
                logger.warn("Not logging a packet because the local data address is null");
                return pkt;
            }
            MediaStreamTarget target = this.mediaStream.getTarget();
            if (target == null) {
                logger.warn("Not logging a packet because the media stream target is null.");
                return pkt;
            }
            InetSocketAddress targetDataAddress = target.getDataAddress();
            if (targetDataAddress == null) {
                logger.warn("Not logging a packet because the media stream target address is null.");
                return pkt;
            }
            src = localDataAddress;
            dst = targetDataAddress;
        } else {
            InetSocketAddress localControlAddress = this.mediaStream.getLocalControlAddress();
            if (localControlAddress == null) {
                logger.warn("Not logging a packet because the local data address is null");
                return pkt;
            }
            MediaStreamTarget target = this.mediaStream.getTarget();
            if (target == null) {
                logger.warn("Not logging a packet because the media stream target is null.");
                return pkt;
            }
            InetSocketAddress targetControlAddress = target.getControlAddress();
            if (targetControlAddress == null) {
                logger.warn("Not logging a packet because the media stream target address is null.");
                return pkt;
            }
            src = localControlAddress;
            dst = targetControlAddress;
        }
        if (!sender) {
            InetSocketAddress swap = src;
            src = dst;
            dst = swap;
        }
        if (src != null) {
            byArray2 = src.getAddress().getAddress();
        } else {
            byte[] byArray3 = new byte[4];
            byArray3[0] = 0;
            byArray3[1] = 0;
            byArray3[2] = 0;
            byArray2 = byArray3;
            byArray3[3] = 0;
        }
        int n = src != null ? src.getPort() : 1;
        if (dst != null) {
            byArray = dst.getAddress().getAddress();
        } else {
            byte[] byArray4 = new byte[4];
            byArray4[0] = 0;
            byArray4[1] = 0;
            byArray4[2] = 0;
            byArray = byArray4;
            byArray4[3] = 0;
        }
        pktLogging.logPacket(PacketLoggingService.ProtocolName.ARBITRARY, byArray2, n, byArray, dst != null ? dst.getPort() : 1, PacketLoggingService.TransportName.UDP, sender, (byte[])pkt.getBuffer().clone(), pkt.getOffset(), pkt.getLength());
        return pkt;
    }

    class MyRTCPPacketTransformer
    extends SinglePacketTransformer {
        MyRTCPPacketTransformer() {
        }

        @Override
        public RawPacket reverseTransform(RawPacket pkt) {
            return DebugTransformEngine.this.transform(pkt, false, false);
        }

        @Override
        public RawPacket transform(RawPacket pkt) {
            return DebugTransformEngine.this.transform(pkt, false, true);
        }
    }

    class MyRTPPacketTransformer
    extends SinglePacketTransformer {
        MyRTPPacketTransformer() {
        }

        @Override
        public RawPacket reverseTransform(RawPacket pkt) {
            return DebugTransformEngine.this.transform(pkt, true, false);
        }

        @Override
        public RawPacket transform(RawPacket pkt) {
            return DebugTransformEngine.this.transform(pkt, true, true);
        }
    }
}

