/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import org.jitsi.impl.neomedia.RTCPFeedbackMessagePacket;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPHeaderUtils;
import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.util.RTPUtils;

public class RTCPFBPacket
extends RTCPPacket {
    public static final int RTPFB = 205;
    public static final int PSFB = 206;
    public byte[] fci;
    public int fmt;
    public long senderSSRC;
    public long sourceSSRC;

    public RTCPFBPacket(int fmt, int type, long senderSSRC, long sourceSSRC) {
        this.type = type;
        this.fmt = fmt;
        this.senderSSRC = senderSSRC;
        this.sourceSSRC = sourceSSRC;
    }

    public RTCPFBPacket(RTCPCompoundPacket base) {
        super((RTCPPacket)base);
    }

    public static boolean isRTCPFBPacket(ByteArrayBuffer baf) {
        return RTCPFBPacket.isRTPFBPacket(baf) || RTCPFBPacket.isPSFBPacket(baf);
    }

    public static boolean isRTPFBPacket(ByteArrayBuffer baf) {
        int pt = RTCPHeaderUtils.getPacketType(baf);
        return pt == 205;
    }

    public static boolean isPSFBPacket(ByteArrayBuffer baf) {
        int pt = RTCPHeaderUtils.getPacketType(baf);
        return pt == 206;
    }

    public static long getSourceSSRC(ByteArrayBuffer baf) {
        if (baf == null || baf.isInvalid()) {
            return -1L;
        }
        return RTPUtils.readUint32AsLong(baf.getBuffer(), baf.getOffset() + 8);
    }

    public static ByteArrayBuffer getFCI(ByteArrayBuffer baf) {
        if (!RTCPFBPacket.isRTCPFBPacket(baf)) {
            return null;
        }
        int length = RTCPHeaderUtils.getLength(baf);
        if (length < 0) {
            return null;
        }
        return new RawPacket(baf.getBuffer(), baf.getOffset() + 12, length - 12);
    }

    public void assemble(DataOutputStream dataoutputstream) throws IOException {
        int len = this.calcLength();
        byte[] buf = new byte[len];
        int off = 0;
        buf[off++] = (byte)(0x80 | this.fmt);
        buf[off++] = -50;
        int rtcpPacketLength = len / 4 - 1;
        off += RTPUtils.writeShort(buf, off, (short)rtcpPacketLength);
        RTCPFeedbackMessagePacket.writeSSRC(this.senderSSRC, buf, off);
        RTCPFeedbackMessagePacket.writeSSRC(this.sourceSSRC, buf, off += 4);
        off += 4;
        if (this.fci != null && this.fci.length != 0) {
            System.arraycopy(this.fci, 0, buf, off, this.fci.length);
        }
        dataoutputstream.write(buf, 0, len);
    }

    public int calcLength() {
        int len = 12;
        if (this.fci != null && this.fci.length != 0) {
            len += this.fci.length;
        }
        return len;
    }

    public String toString() {
        return "\tRTCP FB packet from sync source " + this.senderSSRC;
    }
}

