/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.swing.ImageIcon;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatContact;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.ChatSessionChangeListener;
import net.java.sip.communicator.impl.gui.main.chat.ChatSessionRenderer;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.main.chat.conference.AdHocChatRoomWrapper;
import net.java.sip.communicator.impl.gui.main.chat.conference.AdHocConferenceChatContact;
import net.java.sip.communicator.impl.gui.main.chat.conference.AdHocConferenceChatTransport;
import net.java.sip.communicator.service.metahistory.MetaHistoryService;
import net.java.sip.communicator.service.protocol.AdHocChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationForm;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomParticipantPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomParticipantPresenceListener;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusEnum;
import net.java.sip.communicator.util.ConfigurationUtils;

public class AdHocConferenceChatSession
extends ChatSession
implements AdHocChatRoomParticipantPresenceListener {
    private ChatTransport currentChatTransport;
    private final AdHocChatRoomWrapper chatRoomWrapper;
    private final ChatSessionRenderer sessionRenderer;

    public AdHocConferenceChatSession(ChatSessionRenderer sessionRenderer, AdHocChatRoomWrapper chatRoomWrapper) {
        this.sessionRenderer = sessionRenderer;
        this.chatRoomWrapper = chatRoomWrapper;
        this.currentChatTransport = new AdHocConferenceChatTransport(this, chatRoomWrapper.getAdHocChatRoom());
        this.chatTransports.add(this.currentChatTransport);
        this.initChatParticipants();
        AdHocChatRoom chatRoom = chatRoomWrapper.getAdHocChatRoom();
        chatRoom.addParticipantPresenceListener((AdHocChatRoomParticipantPresenceListener)this);
    }

    @Override
    public Object getDescriptor() {
        return this.chatRoomWrapper;
    }

    @Override
    public void dispose() {
        AdHocChatRoom chatRoom = this.chatRoomWrapper.getAdHocChatRoom();
        chatRoom.removeParticipantPresenceListener((AdHocChatRoomParticipantPresenceListener)this);
    }

    @Override
    public String getChatName() {
        return this.chatRoomWrapper.getAdHocChatRoomName();
    }

    public ChatRoomConfigurationForm getChatConfigurationForm() throws OperationFailedException {
        return null;
    }

    @Override
    public ChatTransport getCurrentChatTransport() {
        return this.currentChatTransport;
    }

    @Override
    public String getDefaultSmsNumber() {
        return null;
    }

    @Override
    public Collection<Object> getHistory(int count) {
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return null;
        }
        return metaHistory.findLast(this.chatHistoryFilter, (Object)this.chatRoomWrapper.getAdHocChatRoom(), ConfigurationUtils.getChatHistorySize());
    }

    @Override
    public Collection<Object> getHistoryBeforeDate(Date date, int count) {
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return null;
        }
        return metaHistory.findLastMessagesBefore(this.chatHistoryFilter, (Object)this.chatRoomWrapper.getAdHocChatRoom(), date, ConfigurationUtils.getChatHistorySize());
    }

    @Override
    public Collection<Object> getHistoryAfterDate(Date date, int count) {
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return null;
        }
        return metaHistory.findFirstMessagesAfter(this.chatHistoryFilter, (Object)this.chatRoomWrapper.getAdHocChatRoom(), date, ConfigurationUtils.getChatHistorySize());
    }

    @Override
    public Date getHistoryStartDate() {
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return new Date(0L);
        }
        Date startHistoryDate = new Date(0L);
        Collection firstMessage = metaHistory.findFirstMessagesAfter(this.chatHistoryFilter, (Object)this.chatRoomWrapper.getAdHocChatRoom(), new Date(0L), 1);
        if (firstMessage.size() > 0) {
            Iterator i = firstMessage.iterator();
            Object o = i.next();
            if (o instanceof MessageDeliveredEvent) {
                MessageDeliveredEvent evt = (MessageDeliveredEvent)o;
                startHistoryDate = evt.getTimestamp();
            } else if (o instanceof MessageReceivedEvent) {
                MessageReceivedEvent evt = (MessageReceivedEvent)o;
                startHistoryDate = evt.getTimestamp();
            }
        }
        return startHistoryDate;
    }

    @Override
    public Date getHistoryEndDate() {
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return new Date(0L);
        }
        Date endHistoryDate = new Date(0L);
        Collection lastMessage = metaHistory.findLastMessagesBefore(this.chatHistoryFilter, (Object)this.chatRoomWrapper.getAdHocChatRoom(), new Date(Long.MAX_VALUE), 1);
        if (lastMessage.size() > 0) {
            Iterator i1 = lastMessage.iterator();
            Object o1 = i1.next();
            if (o1 instanceof MessageDeliveredEvent) {
                MessageDeliveredEvent evt = (MessageDeliveredEvent)o1;
                endHistoryDate = evt.getTimestamp();
            } else if (o1 instanceof MessageReceivedEvent) {
                MessageReceivedEvent evt = (MessageReceivedEvent)o1;
                endHistoryDate = evt.getTimestamp();
            }
        }
        return endHistoryDate;
    }

    @Override
    public void setCurrentChatTransport(ChatTransport chatTransport) {
        this.currentChatTransport = chatTransport;
    }

    @Override
    public void setDefaultSmsNumber(String smsPhoneNumber) {
    }

    @Override
    public ChatSessionRenderer getChatSessionRenderer() {
        return this.sessionRenderer;
    }

    @Override
    public boolean isDescriptorPersistent() {
        return false;
    }

    public void loadChatRoom(AdHocChatRoom chatRoom) {
        for (Contact contact : chatRoom.getParticipants()) {
            this.sessionRenderer.addChatContact(new AdHocConferenceChatContact(contact));
        }
        chatRoom.addParticipantPresenceListener((AdHocChatRoomParticipantPresenceListener)this);
    }

    @Override
    public ImageIcon getChatStatusIcon() {
        GlobalStatusEnum status = GlobalStatusEnum.OFFLINE;
        if (this.chatRoomWrapper.getAdHocChatRoom() != null) {
            status = GlobalStatusEnum.ONLINE;
        }
        return new ImageIcon(status.getStatusIcon());
    }

    @Override
    public byte[] getChatAvatar() {
        return null;
    }

    private void initChatParticipants() {
        AdHocChatRoom chatRoom = this.chatRoomWrapper.getAdHocChatRoom();
        if (chatRoom != null) {
            for (Contact contact : chatRoom.getParticipants()) {
                this.chatParticipants.add(new AdHocConferenceChatContact(contact));
            }
        }
    }

    @Override
    public boolean isContactListSupported() {
        return true;
    }

    public void participantPresenceChanged(AdHocChatRoomParticipantPresenceChangeEvent evt) {
        block7: {
            String statusMessage;
            Contact participant;
            String eventType;
            AdHocChatRoom sourceChatRoom;
            block6: {
                sourceChatRoom = evt.getAdHocChatRoom();
                if (!sourceChatRoom.equals(this.chatRoomWrapper.getAdHocChatRoom())) {
                    return;
                }
                eventType = evt.getEventType();
                participant = evt.getParticipant();
                statusMessage = null;
                if (!eventType.equals("ContactJoined")) break block6;
                AdHocConferenceChatContact chatContact = new AdHocConferenceChatContact(participant);
                this.chatParticipants.add(chatContact);
                this.sessionRenderer.addChatContact(chatContact);
                if (evt.isReasonUserList()) break block7;
                statusMessage = GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_USER_JOINED", new String[]{sourceChatRoom.getName()});
                this.sessionRenderer.updateChatContactStatus(chatContact, statusMessage);
                break block7;
            }
            if (eventType.equals("ContactLeft") || eventType.equals("ContactQuit")) {
                if (eventType.equals("ContactLeft")) {
                    statusMessage = GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_USER_LEFT", new String[]{sourceChatRoom.getName()});
                } else if (eventType.equals("ContactQuit")) {
                    statusMessage = GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_USER_QUIT", new String[]{sourceChatRoom.getName()});
                }
                for (ChatContact chatContact : this.chatParticipants) {
                    if (!chatContact.getDescriptor().equals(participant)) continue;
                    this.sessionRenderer.updateChatContactStatus(chatContact, statusMessage);
                    this.sessionRenderer.removeChatContact(chatContact);
                    break;
                }
            }
        }
    }

    @Override
    public void addChatTransportChangeListener(ChatSessionChangeListener l) {
    }

    @Override
    public void removeChatTransportChangeListener(ChatSessionChangeListener l) {
    }
}

