/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.header.AcceptHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.MinExpiresHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.EventPackageSupport;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipMessageFactory;
import net.java.sip.communicator.impl.protocol.sip.TimerScheduler;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.util.Logger;

public class EventPackageSubscriber
extends EventPackageSupport {
    private static final Logger logger = Logger.getLogger(EventPackageSubscriber.class);
    private final int refreshMargin;
    private final SipMessageFactory messageFactory;

    public EventPackageSubscriber(ProtocolProviderServiceSipImpl protocolProvider, String eventPackage, int subscriptionDuration, String contentSubType, TimerScheduler timer, int refreshMargin) {
        super(protocolProvider, eventPackage, subscriptionDuration, contentSubType, timer);
        this.refreshMargin = refreshMargin;
        this.messageFactory = protocolProvider.getMessageFactory();
    }

    private ClientTransaction createSubscription(Subscription subscription, Dialog dialog, int expires) throws OperationFailedException {
        Request req = this.messageFactory.createRequest(dialog, "SUBSCRIBE");
        Address toAddress = dialog.getRemoteTarget();
        if (toAddress == null) {
            toAddress = dialog.getRemoteParty();
        }
        MaxForwardsHeader maxForwards = this.protocolProvider.getMaxForwardsHeader();
        req.setHeader((Header)maxForwards);
        ClientTransaction transac = null;
        try {
            transac = this.protocolProvider.getDefaultJainSipProvider().getNewClientTransaction(req);
        }
        catch (TransactionUnavailableException ex) {
            logger.error((Object)"Failed to create subscriptionTransaction.\nThis is most probably a network connection error.", (Throwable)ex);
            throw new OperationFailedException("Failed to create the subscription transaction", 2);
        }
        this.populateSubscribeRequest(req, subscription, expires);
        return transac;
    }

    private ClientTransaction createSubscription(Subscription subscription, int expires) throws OperationFailedException {
        ClientTransaction subscribeTransaction;
        Request req;
        ToHeader toHeader;
        FromHeader fromHeader;
        CSeqHeader cSeqHeader;
        Address toAddress = subscription.getAddress();
        HeaderFactory headerFactory = this.protocolProvider.getHeaderFactory();
        CallIdHeader callIdHeader = this.protocolProvider.getDefaultJainSipProvider().getNewCallId();
        try {
            cSeqHeader = headerFactory.createCSeqHeader(1L, "SUBSCRIBE");
        }
        catch (InvalidArgumentException ex) {
            logger.error((Object)"An unexpected error occurred whileconstructing the CSeqHeader", (Throwable)ex);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the CSeqHeader", 4, (Throwable)ex);
        }
        catch (ParseException ex) {
            logger.error((Object)"An unexpected error occurred whileconstructing the CSeqHeader", (Throwable)ex);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the CSeqHeader", 4, (Throwable)ex);
        }
        String localTag = SipMessageFactory.generateLocalTag();
        try {
            fromHeader = headerFactory.createFromHeader(this.protocolProvider.getOurSipAddress(toAddress), localTag);
            toHeader = headerFactory.createToHeader(toAddress, null);
        }
        catch (ParseException ex) {
            logger.error((Object)"An unexpected error occurred whileconstructing the FromHeader or ToHeader", (Throwable)ex);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the FromHeader or ToHeader", 4, (Throwable)ex);
        }
        ArrayList<ViaHeader> viaHeaders = this.protocolProvider.getLocalViaHeaders(toAddress);
        MaxForwardsHeader maxForwards = this.protocolProvider.getMaxForwardsHeader();
        try {
            req = this.protocolProvider.getMessageFactory().createRequest(toHeader.getAddress().getURI(), "SUBSCRIBE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        }
        catch (ParseException ex) {
            logger.error((Object)"Failed to create message Request!", (Throwable)ex);
            throw new OperationFailedException("Failed to create message Request!", 4, (Throwable)ex);
        }
        this.populateSubscribeRequest(req, subscription, expires);
        try {
            subscribeTransaction = this.protocolProvider.getDefaultJainSipProvider().getNewClientTransaction(req);
        }
        catch (TransactionUnavailableException ex) {
            logger.error((Object)"Failed to create subscribe transaction.\nThis is most probably a network connection error.", (Throwable)ex);
            throw new OperationFailedException("Failed to create the subscription transaction", 2);
        }
        return subscribeTransaction;
    }

    @Override
    protected Subscription getSubscription(Address toAddress, String eventId) {
        return (Subscription)super.getSubscription(toAddress, eventId);
    }

    @Override
    protected Subscription getSubscription(String callId) {
        return (Subscription)super.getSubscription(callId);
    }

    public void poll(Subscription subscription) throws OperationFailedException {
        if (this.getSubscription(subscription.getAddress(), subscription.getEventId()) == null) {
            this.subscribe(subscription);
        }
    }

    protected void populateSubscribeRequest(Request req, Subscription subscription, int expires) throws OperationFailedException {
        ExpiresHeader expHeader;
        AcceptHeader accept;
        EventHeader evHeader;
        HeaderFactory headerFactory = this.protocolProvider.getHeaderFactory();
        try {
            evHeader = headerFactory.createEventHeader(this.eventPackage);
            String eventId = subscription.getEventId();
            if (eventId != null) {
                evHeader.setEventId(eventId);
            }
        }
        catch (ParseException e) {
            logger.error((Object)"An unexpected error occurred whileconstructing the EventHeader", (Throwable)e);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the EventHeader", 4, (Throwable)e);
        }
        req.setHeader((Header)evHeader);
        try {
            accept = headerFactory.createAcceptHeader("application", this.contentSubType);
        }
        catch (ParseException e) {
            logger.error((Object)"wrong accept header", (Throwable)e);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the AcceptHeader", 4, (Throwable)e);
        }
        req.setHeader((Header)accept);
        try {
            expHeader = headerFactory.createExpiresHeader(expires);
        }
        catch (InvalidArgumentException e) {
            logger.error((Object)("Invalid expires value: " + expires), (Throwable)e);
            throw new OperationFailedException("An unexpected error occurred whileconstructing the ExpiresHeader", 4, (Throwable)e);
        }
        req.setHeader((Header)expHeader);
    }

    @Override
    public boolean processRequest(RequestEvent requestEvent) {
        Response response;
        SubscriptionStateHeader sstateHeader;
        Request request = requestEvent.getRequest();
        EventHeader eventHeader = (EventHeader)request.getHeader("Event");
        if (eventHeader == null || !this.eventPackage.equalsIgnoreCase(eventHeader.getEventType())) {
            return false;
        }
        if (!"NOTIFY".equals(request.getMethod())) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"notify received");
        }
        if ((sstateHeader = (SubscriptionStateHeader)request.getHeader("Subscription-State")) == null) {
            logger.error((Object)"no subscription state in this request");
            return false;
        }
        String sstate = sstateHeader.getState();
        ServerTransaction serverTransaction = EventPackageSubscriber.getOrCreateServerTransaction(requestEvent);
        CallIdHeader callIdHeader = (CallIdHeader)request.getHeader("Call-ID");
        String callId = callIdHeader.getCallId();
        Subscription subscription = this.getSubscription(callId);
        if (subscription == null && !"terminated".equalsIgnoreCase(sstate)) {
            Response response2;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("subscription not found for callId " + callId));
            }
            try {
                response2 = this.protocolProvider.getMessageFactory().createResponse(481, request);
            }
            catch (ParseException e) {
                logger.error((Object)"failed to create the 481 response", (Throwable)e);
                return false;
            }
            try {
                serverTransaction.sendResponse(response2);
            }
            catch (SipException e) {
                logger.error((Object)"failed to send the response", (Throwable)e);
            }
            catch (InvalidArgumentException e) {
                logger.error((Object)"invalid argument provided while trying to send the response", (Throwable)e);
            }
            return true;
        }
        ContentTypeHeader ctheader = (ContentTypeHeader)request.getHeader("Content-Type");
        if (ctheader != null && !ctheader.getContentSubType().equalsIgnoreCase(this.contentSubType)) {
            AcceptHeader acceptHeader;
            try {
                response = this.protocolProvider.getMessageFactory().createResponse(415, request);
            }
            catch (ParseException e) {
                logger.error((Object)"failed to create the OK response", (Throwable)e);
                return false;
            }
            try {
                acceptHeader = this.protocolProvider.getHeaderFactory().createAcceptHeader("application", this.contentSubType);
            }
            catch (ParseException e) {
                logger.error((Object)"failed to create the accept header", (Throwable)e);
                return false;
            }
            response.setHeader((Header)acceptHeader);
            try {
                serverTransaction.sendResponse(response);
            }
            catch (SipException e) {
                logger.error((Object)"failed to send the response", (Throwable)e);
            }
            catch (InvalidArgumentException e) {
                logger.error((Object)"invalid argument provided while trying to send the response", (Throwable)e);
            }
        }
        if ("terminated".equalsIgnoreCase(sstate) && subscription != null) {
            this.removeSubscription(callId, subscription);
            subscription.processTerminatedRequest(requestEvent, sstateHeader.getReasonCode());
        }
        try {
            response = this.protocolProvider.getMessageFactory().createResponse(200, request);
        }
        catch (ParseException e) {
            logger.error((Object)"failed to create the OK response", (Throwable)e);
            return false;
        }
        try {
            serverTransaction.sendResponse(response);
        }
        catch (SipException e) {
            logger.error((Object)"failed to send the response", (Throwable)e);
        }
        catch (InvalidArgumentException e) {
            logger.error((Object)"invalid argument provided while trying to send the response", (Throwable)e);
        }
        if (subscription != null) {
            subscription.processActiveRequest(requestEvent, request.getRawContent());
        }
        return true;
    }

    @Override
    public boolean processResponse(ResponseEvent responseEvent) {
        EventHeader eventHeader;
        Response response = responseEvent.getResponse();
        CSeqHeader cseqHeader = (CSeqHeader)response.getHeader("CSeq");
        if (cseqHeader == null) {
            logger.error((Object)"An incoming response did not contain a CSeq header");
            return false;
        }
        if (!"SUBSCRIBE".equals(cseqHeader.getMethod())) {
            return false;
        }
        ClientTransaction clientTransaction = responseEvent.getClientTransaction();
        Request request = clientTransaction.getRequest();
        if (!(request == null || (eventHeader = (EventHeader)request.getHeader("Event")) != null && this.eventPackage.equalsIgnoreCase(eventHeader.getEventType()))) {
            return false;
        }
        CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
        String callId = callIdHeader.getCallId();
        Subscription subscription = this.getSubscription(callId);
        ExpiresHeader expHeader = response.getExpires();
        int statusCode = response.getStatusCode();
        SipProvider sourceProvider = (SipProvider)responseEvent.getSource();
        if (expHeader != null && expHeader.getExpires() == 0 || subscription == null) {
            boolean processed = false;
            if (statusCode == 401 || statusCode == 407) {
                try {
                    this.processAuthenticationChallenge(clientTransaction, response, sourceProvider);
                    processed = true;
                }
                catch (OperationFailedException e) {
                    logger.error((Object)"can't handle the challenge", (Throwable)e);
                }
            } else if (statusCode != 200 && statusCode != 202) {
                processed = true;
            }
            return processed;
        }
        if (statusCode >= 200 && statusCode < 300) {
            if (statusCode == 200 || statusCode == 202) {
                if (expHeader == null) {
                    logger.error((Object)"no Expires header in this response");
                    return false;
                }
                SubscriptionRefreshTask refreshTask = new SubscriptionRefreshTask(subscription);
                subscription.setTimerTask(refreshTask);
                int refreshDelay = expHeader.getExpires();
                if (refreshDelay >= 2 * this.refreshMargin) {
                    refreshDelay -= this.refreshMargin;
                }
                this.timer.schedule(refreshTask, refreshDelay * 1000);
                subscription.setDialog(clientTransaction.getDialog());
                subscription.processSuccessResponse(responseEvent, statusCode);
            }
        } else if (statusCode >= 300 && statusCode < 400) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Response to subscribe to " + subscription.getAddress() + ": " + response.getReasonPhrase()));
            }
        } else if (statusCode >= 400) {
            if (statusCode == 423) {
                MinExpiresHeader min = (MinExpiresHeader)response.getHeader("Min-Expires");
                if (min == null) {
                    logger.error((Object)"no minimal expires value in this 423 response");
                    return false;
                }
                ExpiresHeader exp = request.getExpires();
                try {
                    exp.setExpires(min.getExpires());
                }
                catch (InvalidArgumentException e) {
                    logger.error((Object)"can't set the new expires value", (Throwable)e);
                    return false;
                }
                ClientTransaction transac = null;
                try {
                    transac = this.protocolProvider.getDefaultJainSipProvider().getNewClientTransaction(request);
                }
                catch (TransactionUnavailableException e) {
                    logger.error((Object)"can't create the client transaction", (Throwable)e);
                    return false;
                }
                try {
                    transac.sendRequest();
                }
                catch (SipException e) {
                    logger.error((Object)"can't send the new request", (Throwable)e);
                    return false;
                }
                return true;
            }
            if (statusCode == 401 || statusCode == 407) {
                try {
                    this.processAuthenticationChallenge(clientTransaction, response, sourceProvider);
                }
                catch (OperationFailedException e) {
                    logger.error((Object)"can't handle the challenge", (Throwable)e);
                    this.removeSubscription(callId, subscription);
                    subscription.processFailureResponse(responseEvent, statusCode);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("error received from the network:\n" + response));
                }
                this.removeSubscription(callId, subscription);
                subscription.processFailureResponse(responseEvent, statusCode);
            }
        }
        return true;
    }

    @Override
    public boolean processTimeout(TimeoutEvent timeoutEvent) {
        this.protocolProvider.notifyConnectionFailed();
        return true;
    }

    public void subscribe(Subscription subscription) throws OperationFailedException {
        Dialog dialog = subscription.getDialog();
        if (dialog != null && DialogState.TERMINATED.equals((Object)dialog.getState())) {
            dialog = null;
        }
        ClientTransaction subscribeTransaction = null;
        try {
            subscribeTransaction = dialog == null ? this.createSubscription(subscription, this.subscriptionDuration) : this.createSubscription(subscription, dialog, this.subscriptionDuration);
        }
        catch (OperationFailedException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to create the subscription", 4, ex, logger);
        }
        CallIdHeader callIdHeader = (CallIdHeader)subscribeTransaction.getRequest().getHeader("Call-ID");
        String callId = callIdHeader.getCallId();
        this.addSubscription(callId, subscription);
        try {
            if (dialog == null) {
                subscribeTransaction.sendRequest();
            } else {
                dialog.sendRequest(subscribeTransaction);
            }
        }
        catch (SipException ex) {
            this.removeSubscription(callId, subscription);
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to send the subscription", 2, ex, logger);
        }
    }

    public void unsubscribe(Address toAddress, boolean assertSubscribed) throws IllegalArgumentException, OperationFailedException {
        this.unsubscribe(toAddress, null, assertSubscribed);
    }

    public void unsubscribe(Address toAddress, String eventId, boolean assertSubscribed) throws IllegalArgumentException, OperationFailedException {
        Subscription subscription = this.getSubscription(toAddress, eventId);
        if (subscription == null) {
            if (assertSubscribed) {
                throw new IllegalArgumentException("trying to unregister a not registered contact");
            }
            return;
        }
        Dialog dialog = subscription.getDialog();
        if (dialog != null) {
            ClientTransaction subscribeTransaction;
            String callId = dialog.getCallId().getCallId();
            try {
                subscribeTransaction = this.createSubscription(subscription, dialog, 0);
            }
            catch (OperationFailedException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"failed to create the unsubscription", (Throwable)e);
                }
                throw e;
            }
            this.removeSubscription(callId, subscription);
            try {
                dialog.sendRequest(subscribeTransaction);
            }
            catch (SipException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Can't send the request", (Throwable)e);
                }
                throw new OperationFailedException("Failed to send the subscription message", 2, (Throwable)e);
            }
        }
    }

    private class SubscriptionRefreshTask
    extends TimerTask {
        private final Subscription subscription;

        public SubscriptionRefreshTask(Subscription subscription) {
            this.subscription = subscription;
        }

        @Override
        public void run() {
            Dialog dialog = this.subscription.getDialog();
            if (dialog == null) {
                logger.warn((Object)("null dialog associated with " + this.subscription + ", can't refresh the subscription"));
                return;
            }
            ClientTransaction transac = null;
            try {
                transac = EventPackageSubscriber.this.createSubscription(this.subscription, dialog, EventPackageSubscriber.this.subscriptionDuration);
            }
            catch (OperationFailedException e) {
                logger.error((Object)"Failed to create subscriptionTransaction.", (Throwable)e);
                return;
            }
            try {
                dialog.sendRequest(transac);
            }
            catch (SipException e) {
                logger.error((Object)"Can't send the request", (Throwable)e);
            }
        }
    }

    public static abstract class Subscription
    extends EventPackageSupport.Subscription {
        public Subscription(Address toAddress) {
            this(toAddress, null);
        }

        public Subscription(Address toAddress, String eventId) {
            super(toAddress, eventId);
        }

        protected abstract void processActiveRequest(RequestEvent var1, byte[] var2);

        protected abstract void processFailureResponse(ResponseEvent var1, int var2);

        protected abstract void processSuccessResponse(ResponseEvent var1, int var2);

        protected abstract void processTerminatedRequest(RequestEvent var1, String var2);
    }
}

