/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.sendbl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.StringBlock;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendBuddyListGroup
implements LiveWritable {
    private final String groupName;
    private final List<String> buddies;
    private final int totalSize;

    public static List<SendBuddyListGroup> readBuddyListGroups(ByteBlock block) {
        SendBuddyListGroup group;
        DefensiveTools.checkNull(block, "block");
        ByteBlock nextBlock = block;
        LinkedList<SendBuddyListGroup> groups = new LinkedList<SendBuddyListGroup>();
        while ((group = SendBuddyListGroup.readBuddyListGroup(nextBlock)) != null) {
            groups.add(group);
            nextBlock = nextBlock.subBlock(group.getTotalSize());
        }
        return DefensiveTools.getUnmodifiable(groups);
    }

    @Nullable
    public static SendBuddyListGroup readBuddyListGroup(ByteBlock block) {
        DefensiveTools.checkNull(block, "block");
        StringBlock groupName = SendBuddyListGroup.readString(block);
        if (groupName == null || block.getLength() < groupName.getTotalSize() + 2) {
            return null;
        }
        int buddyCount = BinaryTools.getUShort(block, groupName.getTotalSize());
        ArrayList<String> buddies = new ArrayList<String>(buddyCount);
        ByteBlock rest = block.subBlock(groupName.getTotalSize() + 2);
        int size = groupName.getTotalSize() + 2;
        for (int i = 0; i < buddyCount; ++i) {
            StringBlock buddyString = SendBuddyListGroup.readString(rest);
            if (buddyString == null) {
                return null;
            }
            buddies.add(buddyString.getString());
            rest = rest.subBlock(buddyString.getTotalSize());
            size += buddyString.getTotalSize();
        }
        return new SendBuddyListGroup(groupName.getString(), buddies, size);
    }

    private static StringBlock readString(ByteBlock block) {
        DefensiveTools.checkNull(block, "block");
        if (block.getLength() < 2) {
            return null;
        }
        int len = BinaryTools.getUShort(block, 0);
        if (block.getLength() < len + 2) {
            return null;
        }
        String str = BinaryTools.getAsciiString(block.subBlock(2, len));
        return new StringBlock(str, 2 + len);
    }

    private static void writeString(OutputStream out, String str) throws IOException {
        DefensiveTools.checkNull(out, "out");
        DefensiveTools.checkNull(str, "str");
        byte[] bytes = BinaryTools.getAsciiBytes(str);
        BinaryTools.writeUShort(out, bytes.length);
        out.write(bytes);
    }

    private SendBuddyListGroup(String groupName, Collection<String> buddies, int totalSize) {
        DefensiveTools.checkNull(groupName, "groupName");
        List<String> safeBuddies = DefensiveTools.getSafeNonnullListCopy(buddies, "buddies");
        DefensiveTools.checkRange(totalSize, "totalSize", -1);
        this.groupName = groupName;
        this.buddies = safeBuddies;
        this.totalSize = totalSize;
    }

    public SendBuddyListGroup(String groupName, Collection<String> buddies) {
        this(groupName, buddies, -1);
    }

    public final String getGroupName() {
        return this.groupName;
    }

    public final List<String> getBuddies() {
        return this.buddies;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        SendBuddyListGroup.writeString(out, this.groupName);
        BinaryTools.writeUShort(out, this.buddies.size());
        for (String buddy : this.buddies) {
            SendBuddyListGroup.writeString(out, buddy);
        }
    }

    public String toString() {
        return "SendBuddyListGroup for group '" + this.groupName + "': " + this.buddies;
    }
}

