/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ratelim.ConnectionQueueMgrImpl;
import net.kano.joscar.ratelim.QueueRunner;
import net.kano.joscar.ratelim.RateLimitingEventQueue;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.SnacQueueManager;
import net.kano.joscar.snac.SnacRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateLimitingQueueMgr
implements SnacQueueManager {
    private final Map<ClientSnacProcessor, ConnectionQueueMgrImpl> connMgrs = new IdentityHashMap<ClientSnacProcessor, ConnectionQueueMgrImpl>();
    private final QueueRunner<RateLimitingEventQueue> runner = QueueRunner.create(new RateLimitingEventQueue());

    public final QueueRunner<RateLimitingEventQueue> getRunner() {
        return this.runner;
    }

    public void stop() {
        this.runner.stopCurrentRun();
    }

    void sendSnac(ClientSnacProcessor processor, SnacRequest request) {
        processor.sendSnacImmediately(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<ConnectionQueueMgrImpl> getQueueMgrs() {
        Map<ClientSnacProcessor, ConnectionQueueMgrImpl> map = this.connMgrs;
        synchronized (map) {
            return DefensiveTools.getUnmodifiableCopy(this.connMgrs.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ConnectionQueueMgrImpl getQueueMgr(ClientSnacProcessor processor) {
        DefensiveTools.checkNull(processor, "processor");
        Map<ClientSnacProcessor, ConnectionQueueMgrImpl> map = this.connMgrs;
        synchronized (map) {
            return this.connMgrs.get(processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attached(ClientSnacProcessor processor) {
        Map<ClientSnacProcessor, ConnectionQueueMgrImpl> map = this.connMgrs;
        synchronized (map) {
            this.connMgrs.put(processor, new ConnectionQueueMgrImpl(this, processor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detached(ClientSnacProcessor processor) {
        ConnectionQueueMgrImpl mgr;
        Map<ClientSnacProcessor, ConnectionQueueMgrImpl> map = this.connMgrs;
        synchronized (map) {
            mgr = this.connMgrs.remove(processor);
        }
        mgr.detach();
    }

    @Override
    public void queueSnac(ClientSnacProcessor processor, SnacRequest request) {
        DefensiveTools.checkNull(request, "request");
        this.getQueueMgr(processor).queueSnac(request);
    }

    @Override
    public void clearQueue(ClientSnacProcessor processor) {
        this.getQueueMgr(processor).clearQueue();
    }

    @Override
    public void pause(ClientSnacProcessor processor) {
        this.getQueueMgr(processor).pause();
    }

    @Override
    public void unpause(ClientSnacProcessor processor) {
        this.getQueueMgr(processor).unpause();
    }

    public String toString() {
        return "RateLimitingQueueMgr: connMgrs=" + this.connMgrs.keySet();
    }
}

