/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.util.Stack;
import net.java.sip.communicator.impl.protocol.irc.ControlChar;

public class FormattedTextBuilder {
    private final Stack<ControlChar> formatting = new Stack();
    private final StringBuilder text = new StringBuilder();

    public void append(String text) {
        this.text.append(text);
    }

    public void append(char c) {
        this.text.append(c);
    }

    public void apply(ControlChar c) {
        this.formatting.add(c);
        this.text.append(c.getHtmlStart());
    }

    public boolean isActive(Class<? extends ControlChar> controlClass) {
        for (ControlChar c : this.formatting) {
            if (c.getClass() != controlClass) continue;
            return true;
        }
        return false;
    }

    public void cancel(Class<? extends ControlChar> controlClass, boolean stopAfterFirst) {
        ControlChar current;
        Stack<ControlChar> rewind = new Stack<ControlChar>();
        while (!this.formatting.empty()) {
            current = this.formatting.pop();
            this.text.append(current.getHtmlEnd());
            if (current.getClass() == controlClass) {
                if (!stopAfterFirst) continue;
                break;
            }
            rewind.push(current);
        }
        while (!rewind.empty()) {
            current = (ControlChar)rewind.pop();
            this.apply(current);
        }
    }

    public void cancelAll() {
        while (!this.formatting.empty()) {
            ControlChar c = this.formatting.pop();
            this.text.append(c.getHtmlEnd());
        }
    }

    public String done() {
        this.cancelAll();
        return this.text.toString();
    }

    public String toString() {
        return this.text.toString();
    }
}

