/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.jabber;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.event.TypingNotificationEvent;
import net.java.sip.communicator.service.protocol.event.TypingNotificationsListener;
import net.java.sip.communicator.slick.protocol.jabber.JabberSlickFixture;
import net.java.sip.communicator.util.Logger;

public class TestOperationSetTypingNotifications
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetTypingNotifications.class);
    private JabberSlickFixture fixture = new JabberSlickFixture();
    private OperationSetTypingNotifications opSetTypingNotifs1 = null;
    private OperationSetPresence opSetPresence1 = null;
    private OperationSetTypingNotifications opSetTypingNotifs2 = null;
    private OperationSetPresence opSetPresence2 = null;
    private OperationSetBasicInstantMessaging opSetBasicIM1 = null;
    private OperationSetBasicInstantMessaging opSetBasicIM2 = null;

    public TestOperationSetTypingNotifications(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        Map supportedOperationSets1 = this.fixture.provider1.getSupportedOperationSets();
        if (supportedOperationSets1 == null || supportedOperationSets1.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.opSetTypingNotifs1 = (OperationSetTypingNotifications)supportedOperationSets1.get(OperationSetTypingNotifications.class.getName());
        if (this.opSetTypingNotifs1 == null) {
            throw new NullPointerException("No implementation for typing notifications was found");
        }
        this.opSetBasicIM1 = (OperationSetBasicInstantMessaging)supportedOperationSets1.get(OperationSetBasicInstantMessaging.class.getName());
        if (this.opSetBasicIM1 == null) {
            throw new NullPointerException("No implementation for basic IM was found");
        }
        this.opSetPresence1 = (OperationSetPresence)supportedOperationSets1.get(OperationSetPresence.class.getName());
        if (this.opSetPresence1 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
        Map supportedOperationSets2 = this.fixture.provider2.getSupportedOperationSets();
        if (supportedOperationSets2 == null || supportedOperationSets2.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.opSetTypingNotifs2 = (OperationSetTypingNotifications)supportedOperationSets2.get(OperationSetTypingNotifications.class.getName());
        if (this.opSetTypingNotifs2 == null) {
            throw new NullPointerException("No implementation for typing notifications was found");
        }
        this.opSetBasicIM2 = (OperationSetBasicInstantMessaging)supportedOperationSets2.get(OperationSetBasicInstantMessaging.class.getName());
        if (this.opSetBasicIM2 == null) {
            throw new NullPointerException("No implementation for basic IM was found");
        }
        this.opSetPresence2 = (OperationSetPresence)supportedOperationSets2.get(OperationSetPresence.class.getName());
        if (this.opSetPresence2 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareContactList() throws Exception {
        Object o;
        try {
            this.opSetPresence1.subscribe(this.fixture.userID2);
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
        try {
            this.opSetPresence2.subscribe(this.fixture.userID1);
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
        Object object = o = new Object();
        synchronized (object) {
            o.wait(2000L);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.fixture.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestOperationSetTypingNotifications("prepareContactList"));
        suite.addTest((Test)new TestOperationSetTypingNotifications("testTypingNotificationsEventDelivery"));
        return suite;
    }

    public void testTypingNotificationsEventDelivery() {
        TypingEventCollector evtCollector = new TypingEventCollector();
        Contact notifingContact = this.opSetPresence1.findContactByID(this.fixture.userID2);
        this.opSetBasicIM1.sendInstantMessage(notifingContact, this.opSetBasicIM1.createMessage("ping"));
        this.opSetTypingNotifs1.addTypingNotificationsListener((TypingNotificationsListener)evtCollector);
        Contact contactToNotify = this.opSetPresence2.findContactByID(this.fixture.userID1);
        this.opSetTypingNotifs2.sendTypingNotification(contactToNotify, 1);
        evtCollector.waitForEvent(10000L);
        this.opSetTypingNotifs1.removeTypingNotificationsListener((TypingNotificationsListener)evtCollector);
        TestOperationSetTypingNotifications.assertTrue((String)"Number of typing events received was zero.", (evtCollector.collectedEvents.size() > 0 ? 1 : 0) != 0);
        TypingNotificationEvent evt = (TypingNotificationEvent)evtCollector.collectedEvents.get(0);
        TestOperationSetTypingNotifications.assertEquals((String)"Source of the typing notification event", (String)this.fixture.userID2, (String)evt.getSourceContact().getAddress());
        TestOperationSetTypingNotifications.assertEquals((String)"Source of the typing notification event", (int)1, (int)evt.getTypingState());
        evtCollector.collectedEvents.clear();
        this.opSetTypingNotifs1.addTypingNotificationsListener((TypingNotificationsListener)evtCollector);
        this.opSetTypingNotifs2.sendTypingNotification(contactToNotify, 4);
        evtCollector.waitForEvent(10000L);
        this.opSetTypingNotifs1.removeTypingNotificationsListener((TypingNotificationsListener)evtCollector);
        TestOperationSetTypingNotifications.assertTrue((String)"Number of typing events received was zero.", (evtCollector.collectedEvents.size() > 0 ? 1 : 0) != 0);
        logger.trace((Object)("We have collected " + evtCollector.collectedEvents.size() + " typing notifications."));
        logger.trace((Object)("Notifications: " + evtCollector.collectedEvents));
        evt = (TypingNotificationEvent)evtCollector.collectedEvents.get(0);
        TestOperationSetTypingNotifications.assertEquals((String)"Source of the typing notification event", (String)this.fixture.userID2, (String)evt.getSourceContact().getAddress());
        TestOperationSetTypingNotifications.assertEquals((String)"Source of the typing notification event", (int)4, (int)evt.getTypingState());
    }

    private class TypingEventCollector
    implements TypingNotificationsListener {
        private List<EventObject> collectedEvents = new LinkedList<EventObject>();

        private TypingEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void typingNotificationReceived(TypingNotificationEvent event) {
            logger.debug((Object)("Received a typing notification: " + event));
            TypingEventCollector typingEventCollector = this;
            synchronized (typingEventCollector) {
                this.collectedEvents.add((EventObject)event);
                this.notifyAll();
            }
        }

        public void typingNotificationDeliveryFailed(TypingNotificationEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            TypingEventCollector typingEventCollector = this;
            synchronized (typingEventCollector) {
                if (this.collectedEvents.size() > 0) {
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }
    }
}

