/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.LEBinaryTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;

public class AuthFutureCmd
extends SsiCommand {
    private String uin;
    private String reason;

    public AuthFutureCmd(String uin, String reason) {
        super(20);
        this.uin = uin;
        this.reason = reason;
    }

    public AuthFutureCmd(SnacPacket packet) {
        super(21);
        ByteBlock data = packet.getData();
        int offset = 0;
        short strLen = LEBinaryTools.getUByte(data, offset);
        ByteBlock field = data.subBlock(++offset, strLen);
        this.uin = OscarTools.getString(field, "US-ASCII");
        offset += strLen;
        strLen = LEBinaryTools.getUByte(data, offset);
        field = data.subBlock(++offset, strLen);
        this.reason = OscarTools.getString(field, "US-ASCII");
    }

    public void writeData(OutputStream out) throws IOException {
        byte[] uinBytes = BinaryTools.getAsciiBytes(this.uin);
        BinaryTools.writeUByte(out, uinBytes.length);
        out.write(uinBytes);
        if (this.reason == null) {
            this.reason = "";
        }
        byte[] reasonBytes = BinaryTools.getAsciiBytes(this.reason);
        BinaryTools.writeUShort(out, reasonBytes.length);
        out.write(reasonBytes);
    }

    public String getReason() {
        return this.reason;
    }

    public String getUin() {
        return this.uin;
    }
}

