/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.icq.ContactGroupIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ContactIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetPersistentPresenceIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.RootContactGroupIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.VolatileBuddy;
import net.java.sip.communicator.impl.protocol.icq.VolatileGroup;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupEvent;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupListener;
import net.java.sip.communicator.util.Logger;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.BuddyInfoTrackerListener;
import net.kano.joustsim.oscar.oscar.service.ssi.Buddy;
import net.kano.joustsim.oscar.oscar.service.ssi.BuddyList;
import net.kano.joustsim.oscar.oscar.service.ssi.BuddyListLayoutListener;
import net.kano.joustsim.oscar.oscar.service.ssi.BuddyListener;
import net.kano.joustsim.oscar.oscar.service.ssi.Group;
import net.kano.joustsim.oscar.oscar.service.ssi.GroupListener;
import net.kano.joustsim.oscar.oscar.service.ssi.MutableBuddyList;
import net.kano.joustsim.oscar.oscar.service.ssi.MutableGroup;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiItemChangeListener;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiService;

public class ServerStoredContactListIcqImpl
implements BuddyInfoTrackerListener {
    private static final Logger logger = Logger.getLogger(ServerStoredContactListIcqImpl.class);
    private MutableBuddyList buddyList = null;
    private BuddyListListener buddyListListener = new BuddyListListener();
    private GroupChangeListener jsimGroupChangeListener = new GroupChangeListener();
    private JoustSimItemChangeListener jsimItemChangeListener = new JoustSimItemChangeListener();
    private JoustSimBuddyListener jsimBuddyListener = new JoustSimBuddyListener();
    private final RootContactGroupIcqImpl rootGroup;
    private SsiService jSimSsiService = null;
    private OperationSetPersistentPresenceIcqImpl parentOperationSet = null;
    private ProtocolProviderServiceIcqImpl icqProvider = null;
    private final List<ServerStoredGroupListener> serverStoredGroupListeners = new Vector<ServerStoredGroupListener>();
    private NickRetriever nickRetriever = null;

    ServerStoredContactListIcqImpl(OperationSetPersistentPresenceIcqImpl parentOperationSet, ProtocolProviderServiceIcqImpl icqProvider) {
        this.parentOperationSet = parentOperationSet;
        this.icqProvider = icqProvider;
        this.rootGroup = new RootContactGroupIcqImpl(this.icqProvider);
        if (icqProvider.USING_ICQ) {
            this.nickRetriever = new NickRetriever();
            parentOperationSet.addContactPresenceStatusListener(this.nickRetriever);
            this.nickRetriever.start();
        }
    }

    public ContactGroup getRootGroup() {
        return this.rootGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addGroupListener(ServerStoredGroupListener listener) {
        List<ServerStoredGroupListener> list = this.serverStoredGroupListeners;
        synchronized (list) {
            if (!this.serverStoredGroupListeners.contains(listener)) {
                this.serverStoredGroupListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeGroupListener(ServerStoredGroupListener listener) {
        List<ServerStoredGroupListener> list = this.serverStoredGroupListeners;
        synchronized (list) {
            this.serverStoredGroupListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireGroupEvent(ContactGroup group, int eventID) {
        ArrayList<ServerStoredGroupListener> listeners;
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        ServerStoredGroupEvent evt = new ServerStoredGroupEvent(group, eventID, this.parentOperationSet.getServerStoredContactListRoot(), (ProtocolProviderService)this.icqProvider, (OperationSetPersistentPresence)this.parentOperationSet);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following grp event: " + evt));
        }
        List<ServerStoredGroupListener> list = this.serverStoredGroupListeners;
        synchronized (list) {
            listeners = new ArrayList<ServerStoredGroupListener>(this.serverStoredGroupListeners);
        }
        for (ServerStoredGroupListener listener : listeners) {
            if (eventID == 2) {
                listener.groupRemoved(evt);
                continue;
            }
            if (eventID == 3) {
                listener.groupNameChanged(evt);
                continue;
            }
            if (eventID == 1) {
                listener.groupCreated(evt);
                continue;
            }
            if (eventID != 4) continue;
            listener.groupResolved(evt);
        }
    }

    private void fireGroupsReordered() {
    }

    private void fireContactAdded(ContactGroup parentGroup, Contact contact) {
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        this.parentOperationSet.fireSubscriptionEvent(contact, parentGroup, 1);
    }

    private void fireContactResolved(ContactGroup parentGroup, Contact contact) {
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        this.parentOperationSet.fireSubscriptionEvent(contact, parentGroup, 4);
    }

    private void fireContactMoved(ContactGroup oldParentGroup, ContactGroup newParentGroup, Contact contact, int index) {
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        this.parentOperationSet.fireSubscriptionMovedEvent(contact, oldParentGroup, newParentGroup);
    }

    private void fireContactRemoved(ContactGroup parentGroup, Contact contact) {
        if (this.parentOperationSet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No presence op. set available. Bailing out.");
            }
            return;
        }
        this.parentOperationSet.fireSubscriptionEvent(contact, parentGroup, 2);
    }

    ProtocolProviderServiceIcqImpl getParentProvider() {
        return this.icqProvider;
    }

    public int findContactGroupIndex(Group joustSimGroup) {
        Iterator<ContactGroup> contactGroups = this.rootGroup.subgroups();
        int index = 0;
        while (contactGroups.hasNext()) {
            ContactGroupIcqImpl contactGroup = (ContactGroupIcqImpl)contactGroups.next();
            if (joustSimGroup == contactGroup.getJoustSimSourceGroup()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public ContactGroupIcqImpl findContactGroup(String name) {
        Iterator<ContactGroup> contactGroups = this.rootGroup.subgroups();
        while (contactGroups.hasNext()) {
            ContactGroup contactGroup = contactGroups.next();
            if (!contactGroup.getGroupName().equals(name)) continue;
            return (ContactGroupIcqImpl)contactGroup;
        }
        return null;
    }

    public ContactGroupIcqImpl findContactGroup(Group joustSimGroup) {
        Iterator<ContactGroup> contactGroups = this.rootGroup.subgroups();
        while (contactGroups.hasNext()) {
            ContactGroupIcqImpl contactGroup = (ContactGroupIcqImpl)contactGroups.next();
            if (joustSimGroup != contactGroup.getJoustSimSourceGroup()) continue;
            return contactGroup;
        }
        return null;
    }

    public ContactIcqImpl findContactByScreenName(String screenName) {
        Iterator<ContactGroup> contactGroups = this.rootGroup.subgroups();
        ContactIcqImpl result = null;
        while (contactGroups.hasNext()) {
            ContactGroupIcqImpl contactGroup = (ContactGroupIcqImpl)contactGroups.next();
            result = contactGroup.findContact(screenName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public ContactIcqImpl findContactByJoustSimBuddy(Buddy buddy) {
        Iterator<ContactGroup> contactGroups = this.rootGroup.subgroups();
        String screenName = buddy.getScreenname().getFormatted();
        ContactIcqImpl result = null;
        while (contactGroups.hasNext()) {
            ContactGroupIcqImpl contactGroup = (ContactGroupIcqImpl)contactGroups.next();
            result = contactGroup.findContact(screenName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public ContactGroupIcqImpl findContactGroup(ContactIcqImpl child) {
        Iterator<ContactGroup> contactGroups = this.rootGroup.subgroups();
        while (contactGroups.hasNext()) {
            ContactGroupIcqImpl contactGroup = (ContactGroupIcqImpl)contactGroups.next();
            if (contactGroup.findContact(child.getJoustSimBuddy()) == null) continue;
            return contactGroup;
        }
        return null;
    }

    public void addContact(String screenname) {
        ContactGroupIcqImpl parent = this.getFirstPersistentGroup();
        this.addContact(parent, screenname);
    }

    ContactIcqImpl createVolatileContact(Screenname screenname) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("createVolatileContact " + screenname));
        }
        VolatileBuddy volatileBuddy = new VolatileBuddy(screenname);
        ContactIcqImpl newVolatileContact = new ContactIcqImpl(volatileBuddy, this, false, false);
        ContactGroupIcqImpl theVolatileGroup = this.getNonPersistentGroup();
        if (theVolatileGroup == null) {
            LinkedList emptyBuddies = new LinkedList();
            theVolatileGroup = new ContactGroupIcqImpl(new VolatileGroup(), emptyBuddies, this, false, false);
            theVolatileGroup.addContact(newVolatileContact);
            this.rootGroup.addSubGroup(theVolatileGroup);
            this.fireGroupEvent(theVolatileGroup, 1);
        } else {
            theVolatileGroup.addContact(newVolatileContact);
            this.fireContactAdded(theVolatileGroup, (Contact)newVolatileContact);
        }
        return newVolatileContact;
    }

    ContactIcqImpl createUnresolvedContact(ContactGroupIcqImpl parentGroup, Screenname screenname) {
        ContactIcqImpl existingContact;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("createUnresolvedContact " + screenname));
        }
        if ((existingContact = this.findContactByScreenName(screenname.getFormatted())) != null) {
            return existingContact;
        }
        VolatileBuddy volatileBuddy = new VolatileBuddy(screenname);
        ContactIcqImpl newUnresolvedContact = new ContactIcqImpl(volatileBuddy, this, true, false);
        parentGroup.addContact(newUnresolvedContact);
        this.fireContactAdded(parentGroup, (Contact)newUnresolvedContact);
        return newUnresolvedContact;
    }

    ContactGroupIcqImpl createUnresolvedContactGroup(String groupName) {
        ContactGroupIcqImpl existingGroup = this.findContactGroup(groupName);
        if (existingGroup != null) {
            return existingGroup;
        }
        LinkedList emptyBuddies = new LinkedList();
        ContactGroupIcqImpl newUnresolvedGroup = new ContactGroupIcqImpl(new VolatileGroup(groupName), emptyBuddies, this, false, true);
        this.rootGroup.addSubGroup(newUnresolvedGroup);
        this.fireGroupEvent(newUnresolvedGroup, 1);
        return newUnresolvedGroup;
    }

    public void addContact(ContactGroupIcqImpl parent, String screenname) {
        ContactIcqImpl existingContact;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Adding contact " + screenname + " to parent=" + parent.getGroupName()));
        }
        if ((existingContact = this.findContactByScreenName(screenname)) != null && existingContact.isPersistent()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Contact " + screenname + " already exists. Gen. evt."));
            }
            new Thread(){

                @Override
                public void run() {
                    ServerStoredContactListIcqImpl.this.parentOperationSet.fireSubscriptionEvent((Contact)existingContact, ServerStoredContactListIcqImpl.this.findContactGroup(existingContact), 1);
                }
            }.start();
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Adding the contact to the specified group.");
        }
        MutableGroup group = parent.getJoustSimSourceGroup();
        group.addBuddy(screenname);
    }

    public void createGroup(String groupName) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Creating group: " + groupName));
        }
        this.buddyList.addGroup(groupName);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Group " + groupName + " created."));
        }
    }

    public void removeGroup(ContactGroupIcqImpl groupToRemove) {
        this.buddyList.deleteGroupAndBuddies(groupToRemove.getJoustSimSourceGroup());
    }

    public void renameGroup(ContactGroupIcqImpl groupToRename, String newName) {
        groupToRename.getJoustSimSourceGroup().rename(newName);
    }

    public void moveContact(ContactIcqImpl contact, ContactGroupIcqImpl newParent) {
        if (contact.isPersistent()) {
            ArrayList<Buddy> contactsToMove = new ArrayList<Buddy>();
            contactsToMove.add(contact.getJoustSimBuddy());
            this.buddyList.moveBuddies(contactsToMove, newParent.getJoustSimSourceGroup());
        } else {
            this.addContact(newParent, contact.getUIN());
        }
    }

    void init(SsiService joustSimSsiService) {
        this.jSimSsiService = joustSimSsiService;
        this.jSimSsiService.addItemChangeListener(this.jsimItemChangeListener);
        this.buddyList = this.jSimSsiService.getBuddyList();
        this.buddyList.addRetroactiveLayoutListener(this.buddyListListener);
    }

    private ContactGroupIcqImpl getFirstPersistentGroup() {
        for (int i = 0; i < this.getRootGroup().countSubgroups(); ++i) {
            ContactGroupIcqImpl gr = (ContactGroupIcqImpl)this.getRootGroup().getGroup(i);
            if (!gr.isPersistent()) continue;
            return gr;
        }
        return null;
    }

    private ContactGroupIcqImpl getNonPersistentGroup() {
        for (int i = 0; i < this.getRootGroup().countSubgroups(); ++i) {
            ContactGroupIcqImpl gr = (ContactGroupIcqImpl)this.getRootGroup().getGroup(i);
            if (gr.isPersistent()) continue;
            return gr;
        }
        return null;
    }

    protected void addContactForUpdate(ContactIcqImpl c) {
        if (this.icqProvider.USING_ICQ) {
            this.nickRetriever.addContact(c);
        }
    }

    ContactGroupIcqImpl findGroup(Buddy buddy) {
        Iterator<ContactGroup> iter = this.rootGroup.subgroups();
        while (iter.hasNext()) {
            ContactGroupIcqImpl elem = (ContactGroupIcqImpl)iter.next();
            if (!elem.isPersistent() || !elem.isResolved()) continue;
            for (Buddy buddy2 : elem.getJoustSimSourceGroup().getBuddiesCopy()) {
                if (buddy2 != buddy) continue;
                return elem;
            }
        }
        return null;
    }

    private class NickRetriever
    extends Thread
    implements ContactPresenceStatusListener {
        private final List<ContactIcqImpl> contactsForUpdate = new Vector<ContactIcqImpl>();
        private boolean isReadyForRetreive = false;

        private NickRetriever() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Vector<ContactIcqImpl> copyContactsForUpdate = null;
                block7: while (true) {
                    List<ContactIcqImpl> list = this.contactsForUpdate;
                    synchronized (list) {
                        if (this.contactsForUpdate.isEmpty()) {
                            this.contactsForUpdate.wait();
                        }
                        copyContactsForUpdate = new Vector<ContactIcqImpl>(this.contactsForUpdate);
                        this.contactsForUpdate.clear();
                    }
                    Iterator iter = copyContactsForUpdate.iterator();
                    while (true) {
                        if (!iter.hasNext()) continue block7;
                        ContactIcqImpl contact = (ContactIcqImpl)((Object)iter.next());
                        String oldNickname = contact.getUIN();
                        String nickName = null;
                        try {
                            nickName = ServerStoredContactListIcqImpl.this.getParentProvider().getInfoRetreiver().getNickName(contact.getUIN());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (nickName != null) {
                            contact.setNickname(nickName);
                            ServerStoredContactListIcqImpl.this.parentOperationSet.fireContactPropertyChangeEvent("DisplayName", (Contact)contact, oldNickname, nickName);
                            continue;
                        }
                        contact.setNickname(oldNickname);
                    }
                    break;
                }
            }
            catch (InterruptedException ex) {
                logger.error((Object)"NickRetriever error waiting will stop now!", (Throwable)ex);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void addContact(ContactIcqImpl contact) {
            List<ContactIcqImpl> list = this.contactsForUpdate;
            synchronized (list) {
                if (!this.contactsForUpdate.contains((Object)contact)) {
                    if (this.isReadyForRetreive) {
                        this.contactsForUpdate.add(contact);
                        this.contactsForUpdate.notifyAll();
                    } else {
                        this.contactsForUpdate.add(contact);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contactPresenceStatusChanged(ContactPresenceStatusChangeEvent evt) {
            if (!this.isReadyForRetreive) {
                this.isReadyForRetreive = true;
                List<ContactIcqImpl> list = this.contactsForUpdate;
                synchronized (list) {
                    this.contactsForUpdate.notifyAll();
                }
            }
        }
    }

    private static class JoustSimItemChangeListener
    implements SsiItemChangeListener {
        private JoustSimItemChangeListener() {
        }

        @Override
        public void handleItemCreated(SsiItem item) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("!!! TODO: implement handleItemCreated() !!!" + item + " DATA=" + item.getData().toString()));
            }
        }

        @Override
        public void handleItemDeleted(SsiItem item) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("!!! TODO: implement handleItemDeleted()!!!" + item));
            }
        }

        @Override
        public void handleItemModified(SsiItem item) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("!!! TODO: implement handleItemModified() !!!" + item + " DATA=" + item.getData().toString()));
            }
        }
    }

    private static class JoustSimBuddyListener
    implements BuddyListener {
        private JoustSimBuddyListener() {
        }

        @Override
        public void screennameChanged(Buddy buddy, Screenname oldScreenname, Screenname newScreenname) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"/** @todo implement screennameChanged() */=");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("buddy=" + buddy));
            }
        }

        @Override
        public void alertActionChanged(Buddy buddy, int oldAlertAction, int newAlertAction) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"/** @todo implement alertActionChanged() */=");
            }
        }

        @Override
        public void alertSoundChanged(Buddy buddy, String oldAlertSound, String newAlertSound) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"/** @todo implement alertSoundChanged() */");
            }
        }

        @Override
        public void alertTimeChanged(Buddy buddy, int oldAlertEvent, int newAlertEvent) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"/** @todo implement alertTimeChanged() */");
            }
        }

        @Override
        public void aliasChanged(Buddy buddy, String oldAlias, String newAlias) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"/** @todo implement aliasChanged() */");
            }
        }

        @Override
        public void buddyCommentChanged(Buddy buddy, String oldComment, String newComment) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"/** @todo implement buddyCommentChanged() */");
            }
        }

        @Override
        public void awaitingAuthChanged(Buddy simpleBuddy, boolean oldAwaitingAuth, boolean newAwaitingAuth) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("awaitingAuthChanged for " + simpleBuddy + " oldAwaitingAuth: " + oldAwaitingAuth + " newAwaitingAuth: " + newAwaitingAuth));
            }
        }
    }

    private class GroupChangeListener
    implements GroupListener {
        private GroupChangeListener() {
        }

        @Override
        public void groupNameChanged(Group group, String oldName, String newName) {
            ContactGroupIcqImpl contactGroup;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Group name for " + group.getName() + "changed from=" + oldName + " to=" + newName));
            }
            if ((contactGroup = ServerStoredContactListIcqImpl.this.findContactGroup(group)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("group name changed event received for unknown group" + group));
                }
                return;
            }
            if (contactGroup.getGroupName().equals(contactGroup.getNameCopy())) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Group name hasn't really changed(" + contactGroup.getGroupName() + "). Ignoring"));
                }
                return;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Dispatching group change event.");
            }
            contactGroup.initNameCopy();
            ServerStoredContactListIcqImpl.this.fireGroupEvent(contactGroup, 3);
        }
    }

    private class BuddyListListener
    implements BuddyListLayoutListener {
        private BuddyListListener() {
        }

        @Override
        public void groupAdded(BuddyList list, List<? extends Group> oldItems, List<? extends Group> newItems, Group group, List<? extends Buddy> buddies) {
            ContactGroupIcqImpl newGroup;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Group added: " + group.getName()));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Buddies: " + buddies));
            }
            if ((newGroup = ServerStoredContactListIcqImpl.this.findContactGroup(group.getName())) == null) {
                newGroup = new ContactGroupIcqImpl((MutableGroup)group, buddies, ServerStoredContactListIcqImpl.this, true, true);
                ServerStoredContactListIcqImpl.this.rootGroup.addSubGroup(newGroup);
                ServerStoredContactListIcqImpl.this.fireGroupEvent(newGroup, 1);
            } else {
                ArrayList<Contact> newContacts = new ArrayList<Contact>();
                ArrayList<ContactIcqImpl> arrayList = new ArrayList<ContactIcqImpl>();
                newGroup.updateGroup((MutableGroup)group, buddies, newContacts, arrayList);
                ServerStoredContactListIcqImpl.this.fireGroupEvent(newGroup, 4);
                for (ContactIcqImpl contact : arrayList) {
                    ServerStoredContactListIcqImpl.this.fireContactRemoved(newGroup, (Contact)contact);
                }
                Iterator<Contact> contactsIter = newGroup.contacts();
                while (contactsIter.hasNext()) {
                    ContactIcqImpl contact;
                    contact = contactsIter.next();
                    if (newContacts.contains((Object)contact)) {
                        ServerStoredContactListIcqImpl.this.fireContactAdded(newGroup, (Contact)contact);
                        continue;
                    }
                    ServerStoredContactListIcqImpl.this.fireContactResolved(newGroup, (Contact)contact);
                }
            }
            for (Buddy buddy : buddies) {
                buddy.addBuddyListener(ServerStoredContactListIcqImpl.this.jsimBuddyListener);
            }
            group.addGroupListener(ServerStoredContactListIcqImpl.this.jsimGroupChangeListener);
        }

        @Override
        public void groupRemoved(BuddyList list, List<? extends Group> oldItems, List<? extends Group> newItems, Group group) {
            int index;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Group Removed: " + group.getName()));
            }
            if ((index = ServerStoredContactListIcqImpl.this.findContactGroupIndex(group)) == -1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("non existing group: " + group.getName()));
                }
                return;
            }
            ContactGroup removedGroup = ServerStoredContactListIcqImpl.this.rootGroup.getGroup(index);
            group.removeGroupListener(ServerStoredContactListIcqImpl.this.jsimGroupChangeListener);
            ServerStoredContactListIcqImpl.this.rootGroup.removeSubGroup(index);
            ServerStoredContactListIcqImpl.this.fireGroupEvent(removedGroup, 2);
        }

        @Override
        public void buddyAdded(BuddyList list, Group joustSimGroup, List<? extends Buddy> oldItems, List<? extends Buddy> newItems, Buddy buddy) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Received buddyAdded " + buddy));
            }
            ContactGroupIcqImpl oldParentGroup = null;
            ContactIcqImpl newContact = ServerStoredContactListIcqImpl.this.findContactByJoustSimBuddy(buddy);
            ContactGroupIcqImpl parentGroup = ServerStoredContactListIcqImpl.this.findContactGroup(joustSimGroup);
            boolean fireResolvedEvent = false;
            if (parentGroup == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("no parent group " + joustSimGroup + " found for buddy: " + buddy));
                }
                return;
            }
            if (newContact == null) {
                newContact = new ContactIcqImpl(buddy, ServerStoredContactListIcqImpl.this, true, true);
            } else {
                oldParentGroup = ServerStoredContactListIcqImpl.this.findContactGroup(newContact);
                if (oldParentGroup != parentGroup) {
                    oldParentGroup.removeContact(newContact);
                }
                newContact.setJoustSimBuddy(buddy);
                newContact.setPersistent(true);
                if (!newContact.isResolved()) {
                    newContact.setResolved(true);
                    fireResolvedEvent = true;
                }
            }
            parentGroup.addContact(newContact);
            int index = parentGroup.findContactIndex((Contact)newContact);
            buddy.addBuddyListener(ServerStoredContactListIcqImpl.this.jsimBuddyListener);
            if (oldParentGroup == null) {
                ServerStoredContactListIcqImpl.this.fireContactAdded(parentGroup, (Contact)newContact);
            } else if (oldParentGroup != parentGroup) {
                ServerStoredContactListIcqImpl.this.fireContactMoved(oldParentGroup, parentGroup, (Contact)newContact, index);
            }
            if (fireResolvedEvent) {
                ServerStoredContactListIcqImpl.this.fireContactResolved(parentGroup, (Contact)newContact);
            }
        }

        @Override
        public void buddyRemoved(BuddyList list, Group group, List<? extends Buddy> oldItems, List<? extends Buddy> newItems, Buddy buddy) {
            ContactGroupIcqImpl parentGroup = ServerStoredContactListIcqImpl.this.findContactGroup(group);
            ContactIcqImpl contactToRemove = parentGroup.findContact(buddy);
            if (contactToRemove != null) {
                parentGroup.removeContact(contactToRemove);
                buddy.removeBuddyListener(ServerStoredContactListIcqImpl.this.jsimBuddyListener);
                ServerStoredContactListIcqImpl.this.fireContactRemoved(parentGroup, (Contact)contactToRemove);
            }
        }

        @Override
        public void buddiesReordered(BuddyList list, Group group, List<? extends Buddy> oldBuddies, List<? extends Buddy> newBuddies) {
        }

        @Override
        public void groupsReordered(BuddyList list, List<? extends Group> oldOrder, List<? extends Group> newOrder) {
            ArrayList<ContactGroupIcqImpl> reorderedGroups = new ArrayList<ContactGroupIcqImpl>();
            for (Group group : newOrder) {
                ContactGroupIcqImpl contactGroup = ServerStoredContactListIcqImpl.this.findContactGroup(group);
                if (contactGroup == null) continue;
                reorderedGroups.add(contactGroup);
            }
            ServerStoredContactListIcqImpl.this.rootGroup.reorderSubGroups(reorderedGroups);
            ServerStoredContactListIcqImpl.this.fireGroupsReordered();
        }
    }
}

