/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.CapabilityBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortCapabilityBlock
implements Writable {
    private static final byte[] CAP_TEMPLATE_BYTES = new byte[]{9, 70, 0, 0, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0};
    public static final ByteBlock CAP_TEMPLATE = ByteBlock.wrap(CAP_TEMPLATE_BYTES);
    private final ByteBlock data;

    public static CapabilityBlock getCapFromShortBytes(int byte1, int byte2) {
        byte[] bytes = CAP_TEMPLATE.toByteArray();
        bytes[2] = (byte)byte1;
        bytes[3] = (byte)byte2;
        return new CapabilityBlock(ByteBlock.wrap(bytes));
    }

    public static List<ShortCapabilityBlock> readShortCaps(ByteBlock block) {
        DefensiveTools.checkNull(block, "block");
        LinkedList<ShortCapabilityBlock> caps = new LinkedList<ShortCapabilityBlock>();
        for (int i = 0; i < block.getLength(); i += 2) {
            caps.add(new ShortCapabilityBlock(block.subBlock(i, 2)));
        }
        return DefensiveTools.getUnmodifiable(caps);
    }

    public static boolean couldBeShortBlock(CapabilityBlock cap) {
        DefensiveTools.checkNull(cap, "cap");
        ByteBlock block = cap.getBlock();
        return block.subBlock(0, 2).equals(CAP_TEMPLATE.subBlock(0, 2)) && block.subBlock(4).equals(CAP_TEMPLATE.subBlock(4));
    }

    public static ShortCapabilityBlock getShortBlock(CapabilityBlock cap) throws IllegalArgumentException {
        DefensiveTools.checkNull(cap, "cap");
        if (!ShortCapabilityBlock.couldBeShortBlock(cap)) {
            throw new IllegalArgumentException("Capability block '" + cap + "' cannot be converted to a short capability block");
        }
        return new ShortCapabilityBlock(cap.getBlock().subBlock(2, 2));
    }

    public ShortCapabilityBlock(ByteBlock data) throws IllegalArgumentException {
        DefensiveTools.checkNull(data, "data");
        if (data.getLength() != 2) {
            throw new IllegalArgumentException("short capability data block must contain only two bytes (it has " + data.getLength() + ": " + BinaryTools.describeData(data) + ")");
        }
        this.data = data;
    }

    public final ByteBlock getData() {
        return this.data;
    }

    public final CapabilityBlock toCapabilityBlock() {
        byte[] block = (byte[])CAP_TEMPLATE_BYTES.clone();
        System.arraycopy(this.data.toByteArray(), 0, block, 2, 2);
        return new CapabilityBlock(ByteBlock.wrap(block));
    }

    @Override
    public long getWritableLength() {
        return 2L;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.data.write(out);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShortCapabilityBlock)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ShortCapabilityBlock scb = (ShortCapabilityBlock)obj;
        return scb.data.equals(this.data);
    }

    public int hashCode() {
        return BinaryTools.getUShort(this.data, 0);
    }

    public String toString() {
        String name = MiscTools.findEqualField(CapabilityBlock.class, this.toCapabilityBlock(), "BLOCK_.*");
        return "ShortCapabilityBlock: " + BinaryTools.describeData(this.data) + " (" + (name == null ? "unknown" : name) + ")";
    }
}

