/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.securityconfig.masterpassword;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.securityconfig.SecurityConfigActivator;
import net.java.sip.communicator.plugin.securityconfig.masterpassword.SavedPasswordsDialog;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.credentialsstorage.MasterPasswordInputService;
import net.java.sip.communicator.util.Logger;

public class SavedPasswordsPanel
extends TransparentPanel {
    private static Logger logger = Logger.getLogger(SavedPasswordsPanel.class);
    private static final long serialVersionUID = 0L;
    private static final CredentialsStorageService credentialsStorageService = SecurityConfigActivator.getCredentialsStorageService();

    public SavedPasswordsPanel() {
        this.setLayout(new BorderLayout(10, 10));
        this.setAlignmentX(0.0f);
        this.initComponents();
    }

    private void initComponents() {
        JButton savedPasswordsButton = new JButton();
        savedPasswordsButton.setText(SecurityConfigActivator.getResources().getI18NString("plugin.securityconfig.masterpassword.SAVED_PASSWORDS"));
        savedPasswordsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (credentialsStorageService.isUsingMasterPassword()) {
                    SavedPasswordsPanel.this.showSavedPasswordsDialog();
                } else {
                    SavedPasswordsDialog.getInstance().setVisible(true);
                }
            }
        });
        this.add(savedPasswordsButton, "East");
    }

    private void showSavedPasswordsDialog() {
        String master;
        boolean correct = true;
        MasterPasswordInputService masterPasswordInputService = SecurityConfigActivator.getMasterPasswordInputService();
        if (masterPasswordInputService == null) {
            logger.error((Object)"Missing MasterPasswordInputService to show input dialog");
            return;
        }
        do {
            if ((master = masterPasswordInputService.showInputDialog(correct)) != null) continue;
            return;
        } while (!(correct = master.length() != 0 && credentialsStorageService.verifyMasterPassword(master)));
        SavedPasswordsDialog.getInstance().setVisible(true);
    }
}

