/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.skinmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.skinmanager.SkinSelector;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class SkinManagerPanel
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    private final JButton rmButton = new JButton("Remove selected skin");
    private final SkinSelector skinSelector = new SkinSelector();

    public SkinManagerPanel() {
        super((LayoutManager)new BorderLayout());
        TransparentPanel selectorPanel = new TransparentPanel();
        selectorPanel.setLayout(new BoxLayout((Container)selectorPanel, 1));
        this.skinSelector.setAlignmentX(0.5f);
        this.skinSelector.addItemListener(new EnableDisableListener());
        selectorPanel.add(this.skinSelector);
        this.rmButton.setAlignmentX(0.5f);
        this.rmButton.addActionListener(new RemoveListener());
        selectorPanel.add(this.rmButton);
        this.enableDisableButton();
        this.add((Component)selectorPanel, "North");
    }

    private void enableDisableButton() {
        Object tmp = this.skinSelector.getSelectedItem();
        if (tmp != null && tmp instanceof Bundle) {
            this.rmButton.setEnabled(true);
            return;
        }
        this.rmButton.setEnabled(false);
    }

    private class EnableDisableListener
    implements ItemListener {
        private EnableDisableListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SkinManagerPanel.this.enableDisableButton();
                }
            });
        }
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object tmp = SkinManagerPanel.this.skinSelector.getSelectedItem();
            if (tmp != null && tmp instanceof Bundle) {
                try {
                    ((Bundle)tmp).uninstall();
                }
                catch (BundleException bundleException) {
                    // empty catch block
                }
            }
        }
    }
}

