/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.menus;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.util.skin.Skinnable;

public class SIPCommWindowMenuBar
extends JMenuBar
implements Skinnable {
    private Image backgroundImage;
    private String foreground;

    public SIPCommWindowMenuBar(String foreground) {
        this.foreground = foreground;
        this.loadSkin();
    }

    private static boolean isTransparent(Image image) {
        int height;
        BufferedImage bufferedImage;
        int width;
        if (image instanceof BufferedImage && -1 < (width = (bufferedImage = (BufferedImage)image).getWidth()) && width < 17 && -1 < (height = bufferedImage.getHeight()) && height < 17 && bufferedImage.getTransparency() != 1) {
            boolean transparent = true;
            int min = Math.min(width, height);
            for (int i = 0; i < min; ++i) {
                int rgb = bufferedImage.getRGB(i, i);
                if ((rgb & 0xFF000000) == 0) continue;
                transparent = false;
                break;
            }
            return transparent;
        }
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.backgroundImage != null) {
            g.drawImage(this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
        }
    }

    public void loadSkin() {
        String lafClassName;
        this.backgroundImage = ImageLoader.getImage(ImageLoader.MENU_BACKGROUND);
        LookAndFeel laf = UIManager.getLookAndFeel();
        boolean setForeground = true;
        if (laf != null && (lafClassName = laf.getClass().getName()).equals(UIManager.getSystemLookAndFeelClassName()) && !lafClassName.equals(UIManager.getCrossPlatformLookAndFeelClassName()) && (this.backgroundImage == null || SIPCommWindowMenuBar.isTransparent(this.backgroundImage))) {
            this.backgroundImage = null;
            setForeground = false;
        }
        if (setForeground) {
            this.setForeground(new Color(GuiActivator.getResources().getColor(this.foreground)));
        }
    }
}

