/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.im.InputContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactNode;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTransferHandler;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.resources.ResourceManagementService;

public class CallTransferHandler
extends ExtendedTransferHandler {
    private static final long serialVersionUID = 0L;
    protected static final DataFlavor uiContactDataFlavor = new DataFlavor(UIContact.class, "UIContact");
    private static final Logger logger = Logger.getLogger(CallTransferHandler.class);
    private final CallConference callConference;

    public CallTransferHandler(Call call) {
        this(call.getConference());
    }

    public CallTransferHandler(CallConference callConference) {
        this.callConference = callConference;
    }

    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        for (DataFlavor f : flavor) {
            if (!f.equals(DataFlavor.stringFlavor) && !f.equals(uiContactDataFlavor)) continue;
            return comp instanceof JPanel;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importData(JComponent comp, Transferable t) {
        ProtocolProviderService provider;
        String callee;
        block23: {
            callee = null;
            provider = null;
            if (t.isDataFlavorSupported(uiContactDataFlavor)) {
                Object o;
                block22: {
                    o = null;
                    try {
                        o = t.getTransferData(uiContactDataFlavor);
                    }
                    catch (UnsupportedFlavorException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Failed to drop meta contact.", (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block22;
                        logger.debug((Object)"Failed to drop meta contact.", (Throwable)e);
                    }
                }
                if (o instanceof ContactNode) {
                    UIContactImpl uiContact = ((ContactNode)o).getContactDescriptor();
                    block9: for (UIContactDetail detail : uiContact.getContactDetailsForOperationSet(OperationSetBasicTelephony.class)) {
                        ProtocolProviderService detailProvider = detail.getPreferredProtocolProvider(OperationSetBasicTelephony.class);
                        if (detailProvider == null) continue;
                        if (this.callConference.isJitsiVideobridge()) {
                            for (Call call : this.callConference.getCalls()) {
                                if (detailProvider != call.getProtocolProvider()) continue;
                                callee = detail.getAddress();
                                provider = detailProvider;
                                continue block9;
                            }
                            continue;
                        }
                        callee = detail.getAddress();
                        provider = detailProvider;
                        break;
                    }
                    if (callee == null) {
                        ProtocolProviderService callProvider = ((Call)this.callConference.getCalls().get(0)).getProtocolProvider();
                        ResourceManagementService resources = GuiActivator.getResources();
                        AccountID accountID = callProvider.getAccountID();
                        new ErrorDialog(null, resources.getI18NString("service.gui.ERROR"), resources.getI18NString("service.gui.CALL_NOT_SUPPORTING_PARTICIPANT", new String[]{accountID.getService(), accountID.getUserID(), uiContact.getDisplayName()})).showDialog();
                    }
                }
            } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                InputContext inputContext = comp.getInputContext();
                if (inputContext != null) {
                    inputContext.endComposition();
                }
                try (BufferedReader reader = new BufferedReader(DataFlavor.stringFlavor.getReaderForText(t));){
                    String line;
                    StringBuilder calleeBuilder = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        calleeBuilder.append(line);
                    }
                    callee = calleeBuilder.toString();
                }
                catch (UnsupportedFlavorException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Failed to drop string.", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block23;
                    logger.debug((Object)"Failed to drop string.", (Throwable)e);
                }
            }
        }
        if (callee == null) {
            return false;
        }
        HashMap<ProtocolProviderService, List<String>> callees = new HashMap<ProtocolProviderService, List<String>>();
        callees.put(provider, Arrays.asList(callee));
        CallManager.inviteToConferenceCall(callees, this.callConference);
        return true;
    }
}

