/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.stack.ErrorHandler;
import org.ice4j.stack.RawMessage;

class Connector
implements Runnable {
    private static final Logger logger = Logger.getLogger(Connector.class.getName());
    private final BlockingQueue<RawMessage> messageQueue;
    private IceSocketWrapper sock;
    private final Object sockLock = new Object();
    private boolean running;
    private final ErrorHandler errorHandler;
    private final TransportAddress listenAddress;
    private final TransportAddress remoteAddress;

    protected Connector(IceSocketWrapper socket, TransportAddress remoteAddress, BlockingQueue<RawMessage> messageQueue, ErrorHandler errorHandler) {
        this.sock = socket;
        this.messageQueue = messageQueue;
        this.errorHandler = errorHandler;
        this.remoteAddress = remoteAddress;
        Transport transport = socket.getUDPSocket() != null ? Transport.UDP : Transport.TCP;
        this.listenAddress = new TransportAddress(socket.getLocalAddress(), socket.getLocalPort(), transport);
    }

    void start() {
        this.running = true;
        Thread thread = new Thread((Runnable)this, "IceConnector@" + this.hashCode());
        thread.setDaemon(true);
        thread.start();
    }

    protected IceSocketWrapper getSocket() {
        return this.sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DatagramPacket packet = null;
        while (this.running) {
            try {
                IceSocketWrapper localSock;
                Object object = this.sockLock;
                synchronized (object) {
                    if (!this.running) {
                        return;
                    }
                    localSock = this.sock;
                }
                int receiveBufferSize = 1500;
                if (packet == null) {
                    packet = new DatagramPacket(new byte[receiveBufferSize], receiveBufferSize);
                } else {
                    byte[] packetData = packet.getData();
                    if (packetData == null || packetData.length < receiveBufferSize) {
                        packet.setData(new byte[receiveBufferSize], 0, receiveBufferSize);
                    } else {
                        packet.setLength(receiveBufferSize);
                    }
                }
                localSock.receive(packet);
                if (!this.running) {
                    return;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("received datagram packet - addr: " + packet.getAddress() + " port: " + packet.getPort());
                }
                if (packet.getPort() < 0) {
                    logger.warning("Out of range packet port, resetting to 0");
                    packet.setPort(0);
                }
                RawMessage rawMessage = new RawMessage(packet.getData(), packet.getLength(), new TransportAddress(packet.getAddress(), packet.getPort(), this.listenAddress.getTransport()), this.listenAddress);
                this.messageQueue.add(rawMessage);
            }
            catch (SocketException ex) {
                if (!this.running) continue;
                logger.log(Level.WARNING, "Connector died: " + this.listenAddress + " -> " + this.remoteAddress, ex);
                this.stop();
                this.errorHandler.handleFatalError(this, "A socket exception was thrown while trying to receive a message.", ex);
            }
            catch (ClosedChannelException cce) {
                if (!this.running) continue;
                this.stop();
                this.errorHandler.handleFatalError(this, "The socket was closed:", null);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "A net access point has gone useless:", ex);
                this.errorHandler.handleError(ex.getMessage(), ex);
            }
            catch (Throwable ex) {
                logger.log(Level.WARNING, "A net access point has gone useless:", ex);
                this.stop();
                this.errorHandler.handleFatalError(this, "Unknown error occurred while listening for messages!", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() {
        Object object = this.sockLock;
        synchronized (object) {
            this.running = false;
            if (this.sock != null) {
                this.sock.close();
                this.sock = null;
            }
        }
    }

    void sendMessage(byte[] message, TransportAddress address) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(message, 0, message.length, address);
        this.sock.send(datagramPacket);
    }

    public String toString() {
        return "ice4j.Connector@" + this.listenAddress + " status: " + (this.running ? "not" : "") + " running";
    }

    TransportAddress getListenAddress() {
        return this.listenAddress;
    }

    TransportAddress getRemoteAddress() {
        return this.remoteAddress;
    }
}

