/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.io.IOException;
import java.util.List;
import javax.media.Manager;
import javax.media.Processor;
import javax.media.Renderer;
import javax.media.protocol.DataSource;
import org.jitsi.impl.neomedia.device.AudioMediaDeviceSession;
import org.jitsi.impl.neomedia.device.MediaDeviceSession;
import org.jitsi.impl.neomedia.device.VideoMediaDeviceSession;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.MediaFormat;

public abstract class AbstractMediaDevice
implements MediaDevice {
    public void connect(DataSource captureDevice) throws IOException {
        if (captureDevice == null) {
            throw new NullPointerException("captureDevice");
        }
        try {
            captureDevice.connect();
        }
        catch (NullPointerException npe) {
            IOException ioe = new IOException();
            ioe.initCause(npe);
            throw ioe;
        }
    }

    protected abstract DataSource createOutputDataSource();

    protected Processor createPlayer(DataSource dataSource) throws Exception {
        Processor player = null;
        dataSource.connect();
        try {
            player = Manager.createProcessor((DataSource)dataSource);
        }
        finally {
            if (player == null) {
                dataSource.disconnect();
            }
        }
        return player;
    }

    protected Renderer createRenderer() {
        return null;
    }

    public MediaDeviceSession createSession() {
        switch (this.getMediaType()) {
            case VIDEO: {
                return new VideoMediaDeviceSession(this);
            }
        }
        return new AudioMediaDeviceSession(this);
    }

    @Override
    public List<RTPExtension> getSupportedExtensions() {
        return null;
    }

    @Override
    public List<MediaFormat> getSupportedFormats() {
        return this.getSupportedFormats(null, null);
    }
}

