/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver;

import com.github.zafarkhaja.semver.MetadataVersion;
import com.github.zafarkhaja.semver.NormalVersion;
import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.Parser;
import com.github.zafarkhaja.semver.UnexpectedCharacterException;
import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.util.Stream;
import com.github.zafarkhaja.semver.util.UnexpectedElementException;
import java.util.ArrayList;
import java.util.EnumSet;

class VersionParser
implements Parser<Version> {
    private final Stream<Character> chars;

    VersionParser(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Input string is NULL or empty");
        }
        Character[] characterArray = new Character[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            characterArray[i] = Character.valueOf(string.charAt(i));
        }
        this.chars = new Stream<Character>(characterArray);
    }

    @Override
    public Version parse(String string) {
        return this.parseValidSemVer();
    }

    static Version parseValidSemVer(String string) {
        VersionParser versionParser = new VersionParser(string);
        return versionParser.parseValidSemVer();
    }

    static NormalVersion parseVersionCore(String string) {
        VersionParser versionParser = new VersionParser(string);
        return versionParser.parseVersionCore();
    }

    static MetadataVersion parsePreRelease(String string) {
        VersionParser versionParser = new VersionParser(string);
        return versionParser.parsePreRelease();
    }

    static MetadataVersion parseBuild(String string) {
        VersionParser versionParser = new VersionParser(string);
        return versionParser.parseBuild();
    }

    private Version parseValidSemVer() {
        NormalVersion normalVersion = this.parseVersionCore();
        MetadataVersion metadataVersion = MetadataVersion.NULL;
        MetadataVersion metadataVersion2 = MetadataVersion.NULL;
        Character c = this.consumeNextCharacter(CharType.HYPHEN, CharType.PLUS, CharType.EOI);
        if (CharType.HYPHEN.isMatchedBy(c)) {
            metadataVersion = this.parsePreRelease();
            c = this.consumeNextCharacter(CharType.PLUS, CharType.EOI);
            if (CharType.PLUS.isMatchedBy(c)) {
                metadataVersion2 = this.parseBuild();
            }
        } else if (CharType.PLUS.isMatchedBy(c)) {
            metadataVersion2 = this.parseBuild();
        }
        this.consumeNextCharacter(CharType.EOI);
        return new Version(normalVersion, metadataVersion, metadataVersion2);
    }

    private NormalVersion parseVersionCore() {
        int n = Integer.parseInt(this.numericIdentifier());
        this.consumeNextCharacter(CharType.DOT);
        int n2 = Integer.parseInt(this.numericIdentifier());
        this.consumeNextCharacter(CharType.DOT);
        int n3 = Integer.parseInt(this.numericIdentifier());
        return new NormalVersion(n, n2, n3);
    }

    private MetadataVersion parsePreRelease() {
        this.ensureValidLookahead(CharType.DIGIT, CharType.LETTER, CharType.HYPHEN);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            arrayList.add(this.preReleaseIdentifier());
            if (!this.chars.positiveLookahead(new CharType[]{CharType.DOT})) break;
            this.consumeNextCharacter(CharType.DOT);
        }
        return new MetadataVersion(arrayList.toArray(new String[arrayList.size()]));
    }

    private String preReleaseIdentifier() {
        this.checkForEmptyIdentifier();
        CharType charType = this.nearestCharType(CharType.DOT, CharType.PLUS, CharType.EOI);
        if (this.chars.positiveLookaheadBefore(charType, new CharType[]{CharType.LETTER, CharType.HYPHEN})) {
            return this.alphanumericIdentifier();
        }
        return this.numericIdentifier();
    }

    private MetadataVersion parseBuild() {
        this.ensureValidLookahead(CharType.DIGIT, CharType.LETTER, CharType.HYPHEN);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            arrayList.add(this.buildIdentifier());
            if (!this.chars.positiveLookahead(new CharType[]{CharType.DOT})) break;
            this.consumeNextCharacter(CharType.DOT);
        }
        return new MetadataVersion(arrayList.toArray(new String[arrayList.size()]));
    }

    private String buildIdentifier() {
        this.checkForEmptyIdentifier();
        CharType charType = this.nearestCharType(CharType.DOT, CharType.EOI);
        if (this.chars.positiveLookaheadBefore(charType, new CharType[]{CharType.LETTER, CharType.HYPHEN})) {
            return this.alphanumericIdentifier();
        }
        return this.digits();
    }

    private String numericIdentifier() {
        this.checkForLeadingZeroes();
        return this.digits();
    }

    private String alphanumericIdentifier() {
        StringBuilder stringBuilder = new StringBuilder();
        do {
            stringBuilder.append(this.consumeNextCharacter(CharType.DIGIT, CharType.LETTER, CharType.HYPHEN));
        } while (this.chars.positiveLookahead(new CharType[]{CharType.DIGIT, CharType.LETTER, CharType.HYPHEN}));
        return stringBuilder.toString();
    }

    private String digits() {
        StringBuilder stringBuilder = new StringBuilder();
        do {
            stringBuilder.append(this.consumeNextCharacter(CharType.DIGIT));
        } while (this.chars.positiveLookahead(new CharType[]{CharType.DIGIT}));
        return stringBuilder.toString();
    }

    private CharType nearestCharType(CharType ... charTypeArray) {
        for (Character c : this.chars) {
            for (CharType charType : charTypeArray) {
                if (!charType.isMatchedBy(c)) continue;
                return charType;
            }
        }
        return CharType.EOI;
    }

    private void checkForLeadingZeroes() {
        Character c = this.chars.lookahead(1);
        Character c2 = this.chars.lookahead(2);
        if (c != null && c.charValue() == '0' && CharType.DIGIT.isMatchedBy(c2)) {
            throw new ParseException("Numeric identifier MUST NOT contain leading zeroes");
        }
    }

    private void checkForEmptyIdentifier() {
        Character c = this.chars.lookahead(1);
        if (CharType.DOT.isMatchedBy(c) || CharType.PLUS.isMatchedBy(c) || CharType.EOI.isMatchedBy(c)) {
            throw new ParseException("Identifiers MUST NOT be empty", new UnexpectedCharacterException(c, this.chars.currentOffset(), CharType.DIGIT, CharType.LETTER, CharType.HYPHEN));
        }
    }

    private Character consumeNextCharacter(CharType ... charTypeArray) {
        try {
            return (Character)this.chars.consume(charTypeArray);
        }
        catch (UnexpectedElementException unexpectedElementException) {
            throw new UnexpectedCharacterException(unexpectedElementException);
        }
    }

    private void ensureValidLookahead(CharType ... charTypeArray) {
        if (!this.chars.positiveLookahead(charTypeArray)) {
            throw new UnexpectedCharacterException(this.chars.lookahead(1), this.chars.currentOffset(), charTypeArray);
        }
    }

    static enum CharType implements Stream.ElementType<Character>
    {
        DIGIT{

            @Override
            public boolean isMatchedBy(Character c) {
                if (c == null) {
                    return false;
                }
                return c.charValue() >= '0' && c.charValue() <= '9';
            }
        }
        ,
        LETTER{

            @Override
            public boolean isMatchedBy(Character c) {
                if (c == null) {
                    return false;
                }
                return c.charValue() >= 'a' && c.charValue() <= 'z' || c.charValue() >= 'A' && c.charValue() <= 'Z';
            }
        }
        ,
        DOT{

            @Override
            public boolean isMatchedBy(Character c) {
                if (c == null) {
                    return false;
                }
                return c.charValue() == '.';
            }
        }
        ,
        HYPHEN{

            @Override
            public boolean isMatchedBy(Character c) {
                if (c == null) {
                    return false;
                }
                return c.charValue() == '-';
            }
        }
        ,
        PLUS{

            @Override
            public boolean isMatchedBy(Character c) {
                if (c == null) {
                    return false;
                }
                return c.charValue() == '+';
            }
        }
        ,
        EOI{

            @Override
            public boolean isMatchedBy(Character c) {
                return c == null;
            }
        }
        ,
        ILLEGAL{

            @Override
            public boolean isMatchedBy(Character c) {
                EnumSet<CharType> enumSet = EnumSet.of(ILLEGAL);
                for (CharType charType : EnumSet.complementOf(enumSet)) {
                    if (!charType.isMatchedBy(c)) continue;
                    return false;
                }
                return true;
            }
        };


        static CharType forCharacter(Character c) {
            for (CharType charType : CharType.values()) {
                if (!charType.isMatchedBy(c)) continue;
                return charType;
            }
            return null;
        }
    }
}

