/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.fife.ui.rtextarea.RTextArea;

public abstract class RecordableTextAction
extends TextAction {
    private boolean isRecordable;

    public RecordableTextAction(String string) {
        this(string, null, null, null, null);
    }

    public RecordableTextAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
        super(string);
        this.putValue("SmallIcon", icon);
        this.putValue("ShortDescription", string2);
        this.putValue("AcceleratorKey", keyStroke);
        this.putValue("MnemonicKey", n);
        this.setRecordable(true);
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        JTextComponent jTextComponent = this.getTextComponent(actionEvent);
        if (jTextComponent instanceof RTextArea) {
            RTextArea rTextArea = (RTextArea)jTextComponent;
            if (RTextArea.isRecordingMacro() && this.isRecordable()) {
                int n = actionEvent.getModifiers();
                String string = this.getMacroID();
                if (!"default-typed".equals(string) || (n & 8) == 0 && (n & 2) == 0 && (n & 4) == 0) {
                    String string2 = actionEvent.getActionCommand();
                    RTextArea.addToCurrentMacro(string, string2);
                }
            }
            this.actionPerformedImpl(actionEvent, rTextArea);
        }
    }

    public abstract void actionPerformedImpl(ActionEvent var1, RTextArea var2);

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public String getDescription() {
        return (String)this.getValue("ShortDescription");
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public abstract String getMacroID();

    public int getMnemonic() {
        Integer n = (Integer)this.getValue("MnemonicKey");
        return n != null ? n : -1;
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public boolean isRecordable() {
        return this.isRecordable;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
    }

    public void setMnemonic(char c) {
        this.setMnemonic(Integer.valueOf(c));
    }

    public void setMnemonic(Integer n) {
        this.putValue("MnemonicKey", n);
    }

    public void setName(String string) {
        this.putValue("Name", string);
    }

    public void setProperties(ResourceBundle resourceBundle, String string) {
        this.setName(resourceBundle.getString(string + ".Name"));
        this.setMnemonic(resourceBundle.getString(string + ".Mnemonic").charAt(0));
        this.setShortDescription(resourceBundle.getString(string + ".Desc"));
    }

    public void setRecordable(boolean bl) {
        this.isRecordable = bl;
    }

    public void setShortDescription(String string) {
        this.putValue("ShortDescription", string);
    }
}

