/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.util.Arrays;
import java.util.Stack;
import javax.swing.JScrollPane;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;

public class RTextScrollPane
extends JScrollPane {
    private Gutter gutter;

    public RTextScrollPane() {
        this(null, true);
    }

    public RTextScrollPane(RTextArea rTextArea) {
        this(rTextArea, true);
    }

    public RTextScrollPane(Component component) {
        this(component, true);
    }

    public RTextScrollPane(RTextArea rTextArea, boolean bl) {
        this((Component)rTextArea, bl, Color.GRAY);
    }

    public RTextScrollPane(Component component, boolean bl) {
        this(component, bl, Color.GRAY);
    }

    public RTextScrollPane(Component component, boolean bl, Color color) {
        super(component);
        RTextArea rTextArea = RTextScrollPane.getFirstRTextAreaDescendant(component);
        Font font = new Font("Monospaced", 0, 12);
        this.gutter = new Gutter(rTextArea);
        this.gutter.setLineNumberFont(font);
        this.gutter.setLineNumberColor(color);
        this.setLineNumbersEnabled(bl);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
    }

    private void checkGutterVisibility() {
        int n = this.gutter.getComponentCount();
        if (n == 0) {
            if (this.getRowHeader() != null && this.getRowHeader().getView() == this.gutter) {
                this.setRowHeaderView(null);
            }
        } else if (this.getRowHeader() == null || this.getRowHeader().getView() == null) {
            this.setRowHeaderView(this.gutter);
        }
    }

    public Gutter getGutter() {
        return this.gutter;
    }

    public boolean getLineNumbersEnabled() {
        return this.gutter.getLineNumbersEnabled();
    }

    public RTextArea getTextArea() {
        return (RTextArea)this.getViewport().getView();
    }

    public boolean isFoldIndicatorEnabled() {
        return this.gutter.isFoldIndicatorEnabled();
    }

    public boolean isIconRowHeaderEnabled() {
        return this.gutter.isIconRowHeaderEnabled();
    }

    public void setFoldIndicatorEnabled(boolean bl) {
        this.gutter.setFoldIndicatorEnabled(bl);
        this.checkGutterVisibility();
    }

    public void setIconRowHeaderEnabled(boolean bl) {
        this.gutter.setIconRowHeaderEnabled(bl);
        this.checkGutterVisibility();
    }

    public void setLineNumbersEnabled(boolean bl) {
        this.gutter.setLineNumbersEnabled(bl);
        this.checkGutterVisibility();
    }

    @Override
    public void setViewportView(Component component) {
        RTextArea rTextArea = null;
        if (!(component instanceof RTextArea)) {
            rTextArea = RTextScrollPane.getFirstRTextAreaDescendant(component);
            if (rTextArea == null) {
                throw new IllegalArgumentException("view must be either an RTextArea or a JLayer wrapping one");
            }
        } else {
            rTextArea = (RTextArea)component;
        }
        super.setViewportView(component);
        if (this.gutter != null) {
            this.gutter.setTextArea(rTextArea);
        }
    }

    private static final RTextArea getFirstRTextAreaDescendant(Component component) {
        Stack<Component> stack = new Stack<Component>();
        stack.add(component);
        while (!stack.isEmpty()) {
            Component component2 = (Component)stack.pop();
            if (component2 instanceof RTextArea) {
                return (RTextArea)component2;
            }
            if (!(component2 instanceof Container)) continue;
            Container container = (Container)component2;
            stack.addAll(Arrays.asList(container.getComponents()));
        }
        return null;
    }
}

