/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class NsisFoldParser
implements FoldParser {
    private static final char[] KEYWORD_FUNCTION = "Function".toCharArray();
    private static final char[] KEYWORD_FUNCTION_END = "FunctionEnd".toCharArray();
    private static final char[] KEYWORD_SECTION = "Section".toCharArray();
    private static final char[] KEYWORD_SECTION_END = "SectionEnd".toCharArray();
    protected static final char[] C_MLC_END = "*/".toCharArray();

    private static final boolean foundEndKeyword(char[] cArray, Token token, Stack<char[]> stack) {
        return token.is(6, cArray) && !stack.isEmpty() && cArray == stack.peek();
    }

    @Override
    public List<Fold> getFolds(RSyntaxTextArea rSyntaxTextArea) {
        ArrayList<Fold> arrayList = new ArrayList<Fold>();
        Fold fold = null;
        int n = rSyntaxTextArea.getLineCount();
        boolean bl = false;
        int n2 = 0;
        Stack<char[]> stack = new Stack<char[]>();
        try {
            for (int i = 0; i < n; ++i) {
                for (Token token = rSyntaxTextArea.getTokenListForLine(i); token != null && token.isPaintable(); token = token.getNextToken()) {
                    if (token.isComment()) {
                        if (bl) {
                            if (!token.endsWith(C_MLC_END)) continue;
                            int n3 = token.getEndOffset() - 1;
                            if (fold == null) {
                                fold = new Fold(1, rSyntaxTextArea, n2);
                                fold.setEndOffset(n3);
                                arrayList.add(fold);
                                fold = null;
                            } else {
                                fold = fold.createChild(1, n2);
                                fold.setEndOffset(n3);
                                fold = fold.getParent();
                            }
                            bl = false;
                            n2 = 0;
                            continue;
                        }
                        if (token.getType() == 1 || token.endsWith(C_MLC_END)) continue;
                        bl = true;
                        n2 = token.getOffset();
                        continue;
                    }
                    if (token.is(6, KEYWORD_SECTION)) {
                        if (fold == null) {
                            fold = new Fold(0, rSyntaxTextArea, token.getOffset());
                            arrayList.add(fold);
                        } else {
                            fold = fold.createChild(0, token.getOffset());
                        }
                        stack.push(KEYWORD_SECTION_END);
                        continue;
                    }
                    if (token.is(6, KEYWORD_FUNCTION)) {
                        if (fold == null) {
                            fold = new Fold(0, rSyntaxTextArea, token.getOffset());
                            arrayList.add(fold);
                        } else {
                            fold = fold.createChild(0, token.getOffset());
                        }
                        stack.push(KEYWORD_FUNCTION_END);
                        continue;
                    }
                    if (!NsisFoldParser.foundEndKeyword(KEYWORD_SECTION_END, token, stack) && !NsisFoldParser.foundEndKeyword(KEYWORD_FUNCTION_END, token, stack) || fold == null) continue;
                    fold.setEndOffset(token.getOffset());
                    Fold fold2 = fold.getParent();
                    stack.pop();
                    if (fold.isOnSingleLine() && !fold.removeFromParent()) {
                        arrayList.remove(arrayList.size() - 1);
                    }
                    fold = fold2;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return arrayList;
    }
}

