/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.HtmlOccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;

public class XmlOccurrenceMarker
implements OccurrenceMarker {
    private static final char[] CLOSE_TAG_START = new char[]{'<', '/'};
    private static final char[] TAG_SELF_CLOSE = new char[]{'/', '>'};

    @Override
    public Token getTokenToMark(RSyntaxTextArea rSyntaxTextArea) {
        return HtmlOccurrenceMarker.getTagNameTokenForCaretOffset(rSyntaxTextArea, this);
    }

    @Override
    public boolean isValidType(RSyntaxTextArea rSyntaxTextArea, Token token) {
        return rSyntaxTextArea.getMarkOccurrencesOfTokenType(token.getType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void markOccurrences(RSyntaxDocument rSyntaxDocument, Token token, RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter, SmartHighlightPainter smartHighlightPainter) {
        char[] cArray = token.getLexeme().toCharArray();
        int n = token.getOffset();
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n2 = element.getElementCount();
        int n3 = element.getElementIndex(token.getOffset());
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = true;
        for (token = rSyntaxDocument.getTokenListForLine(n3); token != null && token.isPaintable(); token = token.getNextToken()) {
            if (token.getType() != 25) continue;
            if (token.isSingleChar('<') && token.getOffset() + 1 == n) {
                bl = true;
                break;
            }
            if (!token.is(CLOSE_TAG_START) || token.getOffset() + 2 != n) continue;
            bl = true;
            bl2 = false;
            break;
        }
        if (!bl) {
            return;
        }
        if (bl2) {
            token = token.getNextToken().getNextToken();
            while (true) {
                if (token != null && token.isPaintable()) {
                    if (token.getType() == 25) {
                        if (token.is(CLOSE_TAG_START)) {
                            Token token2 = token.getNextToken();
                            if (token2 != null && token2.is(cArray)) {
                                if (n4 > 0) {
                                    --n4;
                                } else {
                                    try {
                                        int n5 = token2.getOffset() + token2.length();
                                        rSyntaxTextAreaHighlighter.addMarkedOccurrenceHighlight(token2.getOffset(), n5, smartHighlightPainter);
                                        n5 = n + token2.length();
                                        rSyntaxTextAreaHighlighter.addMarkedOccurrenceHighlight(n, n5, smartHighlightPainter);
                                        return;
                                    }
                                    catch (BadLocationException badLocationException) {
                                        badLocationException.printStackTrace();
                                    }
                                    return;
                                }
                            }
                        } else if (token.isSingleChar('<') && (token = token.getNextToken()) != null && token.is(cArray)) {
                            ++n4;
                        }
                    }
                    token = token == null ? null : token.getNextToken();
                    continue;
                }
                if (++n3 < n2) {
                    token = rSyntaxDocument.getTokenListForLine(n3);
                }
                if (n3 >= n2) break;
            }
            return;
        }
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        boolean bl3 = false;
        token = rSyntaxDocument.getTokenListForLine(n3);
        int n6 = n - 2;
        while (true) {
            if (token != null && token.getOffset() < n6 && token.isPaintable()) {
                if (token.getType() == 25) {
                    Token token3;
                    if (token.isSingleChar('<')) {
                        Token token4 = token.getNextToken();
                        if (token4 != null) {
                            if (token4.is(cArray)) {
                                arrayList.add(new Entry(true, token4));
                                bl3 = true;
                            } else {
                                bl3 = false;
                            }
                            token = token4;
                        }
                    } else if (token.isSingleChar('>')) {
                        bl3 = false;
                    } else if (bl3 && token.is(TAG_SELF_CLOSE)) {
                        arrayList.remove(arrayList.size() - 1);
                        bl3 = false;
                    } else if (token.is(CLOSE_TAG_START) && (token3 = token.getNextToken()) != null) {
                        if (token3.is(cArray)) {
                            arrayList.add(new Entry(false, token3));
                        }
                        token = token3;
                    }
                }
                token = token.getNextToken();
                continue;
            }
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Entry entry = (Entry)arrayList.get(i);
                if ((n4 += entry.open ? -1 : 1) != -1) continue;
                try {
                    Token token5 = entry.t;
                    int n7 = token5.getOffset() + token5.length();
                    rSyntaxTextAreaHighlighter.addMarkedOccurrenceHighlight(token5.getOffset(), n7, smartHighlightPainter);
                    n7 = n + token5.length();
                    rSyntaxTextAreaHighlighter.addMarkedOccurrenceHighlight(n, n7, smartHighlightPainter);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                arrayList.clear();
                return;
            }
            arrayList.clear();
            if (--n3 >= 0) {
                token = rSyntaxDocument.getTokenListForLine(n3);
            }
            if (n3 < 0) break;
        }
    }

    private static class Entry {
        public boolean open;
        public Token t;

        public Entry(boolean bl, Token token) {
            this.open = bl;
            this.t = token;
        }
    }
}

