/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.deser.impl.CreatorCollector;
import com.fasterxml.jackson.databind.deser.std.ArrayBlockingQueueDeserializer;
import com.fasterxml.jackson.databind.deser.std.AtomicReferenceDeserializer;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import com.fasterxml.jackson.databind.deser.std.EnumMapDeserializer;
import com.fasterxml.jackson.databind.deser.std.EnumSetDeserializer;
import com.fasterxml.jackson.databind.deser.std.JdkDeserializers;
import com.fasterxml.jackson.databind.deser.std.JsonLocationInstantiator;
import com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.fasterxml.jackson.databind.deser.std.MapEntryDeserializer;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.fasterxml.jackson.databind.deser.std.ObjectArrayDeserializer;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializers;
import com.fasterxml.jackson.databind.deser.std.StringArrayDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringCollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.deser.std.TokenBufferDeserializer;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;

public abstract class BasicDeserializerFactory
extends DeserializerFactory
implements Serializable {
    private static final Class<?> CLASS_OBJECT = Object.class;
    private static final Class<?> CLASS_STRING = String.class;
    private static final Class<?> CLASS_CHAR_BUFFER = CharSequence.class;
    private static final Class<?> CLASS_ITERABLE = Iterable.class;
    private static final Class<?> CLASS_MAP_ENTRY = Map.Entry.class;
    protected static final PropertyName UNWRAPPED_CREATOR_PARAM_NAME = new PropertyName("@JsonUnwrapped");
    static final HashMap<String, Class<? extends Map>> _mapFallbacks = new HashMap();
    static final HashMap<String, Class<? extends Collection>> _collectionFallbacks;
    protected final DeserializerFactoryConfig _factoryConfig;

    protected BasicDeserializerFactory(DeserializerFactoryConfig deserializerFactoryConfig) {
        this._factoryConfig = deserializerFactoryConfig;
    }

    public DeserializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    protected abstract DeserializerFactory withConfig(DeserializerFactoryConfig var1);

    @Override
    public final DeserializerFactory withAdditionalDeserializers(Deserializers deserializers) {
        return this.withConfig(this._factoryConfig.withAdditionalDeserializers(deserializers));
    }

    @Override
    public final DeserializerFactory withAdditionalKeyDeserializers(KeyDeserializers keyDeserializers) {
        return this.withConfig(this._factoryConfig.withAdditionalKeyDeserializers(keyDeserializers));
    }

    @Override
    public final DeserializerFactory withDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
        return this.withConfig(this._factoryConfig.withDeserializerModifier(beanDeserializerModifier));
    }

    @Override
    public final DeserializerFactory withAbstractTypeResolver(AbstractTypeResolver abstractTypeResolver) {
        return this.withConfig(this._factoryConfig.withAbstractTypeResolver(abstractTypeResolver));
    }

    @Override
    public final DeserializerFactory withValueInstantiators(ValueInstantiators valueInstantiators) {
        return this.withConfig(this._factoryConfig.withValueInstantiators(valueInstantiators));
    }

    @Override
    public JavaType mapAbstractType(DeserializationConfig deserializationConfig, JavaType javaType) throws JsonMappingException {
        JavaType javaType2;
        while ((javaType2 = this._mapAbstractType2(deserializationConfig, javaType)) != null) {
            Class<?> clazz;
            Class<?> clazz2 = javaType.getRawClass();
            if (clazz2 == (clazz = javaType2.getRawClass()) || !clazz2.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Invalid abstract type resolution from " + javaType + " to " + javaType2 + ": latter is not a subtype of former");
            }
            javaType = javaType2;
        }
        return javaType;
    }

    private JavaType _mapAbstractType2(DeserializationConfig deserializationConfig, JavaType javaType) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (this._factoryConfig.hasAbstractTypeResolvers()) {
            for (AbstractTypeResolver abstractTypeResolver : this._factoryConfig.abstractTypeResolvers()) {
                JavaType javaType2 = abstractTypeResolver.findTypeMapping(deserializationConfig, javaType);
                if (javaType2 == null || javaType2.getRawClass() == clazz) continue;
                return javaType2;
            }
        }
        return null;
    }

    @Override
    public ValueInstantiator findValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        ValueInstantiator valueInstantiator = null;
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        Object object = deserializationContext.getAnnotationIntrospector().findValueInstantiator(annotatedClass);
        if (object != null) {
            valueInstantiator = this._valueInstantiatorInstance(deserializationConfig, annotatedClass, object);
        }
        if (valueInstantiator == null && (valueInstantiator = this._findStdValueInstantiator(deserializationConfig, beanDescription)) == null) {
            valueInstantiator = this._constructDefaultValueInstantiator(deserializationContext, beanDescription);
        }
        if (this._factoryConfig.hasValueInstantiators()) {
            for (ValueInstantiators object2 : this._factoryConfig.valueInstantiators()) {
                valueInstantiator = object2.findValueInstantiator(deserializationConfig, beanDescription, valueInstantiator);
                if (valueInstantiator != null) continue;
                deserializationContext.reportMappingException("Broken registered ValueInstantiators (of type %s): returned null ValueInstantiator", object2.getClass().getName());
            }
        }
        if (valueInstantiator.getIncompleteParameter() != null) {
            AnnotatedParameter annotatedParameter = valueInstantiator.getIncompleteParameter();
            AnnotatedWithParams annotatedWithParams = annotatedParameter.getOwner();
            throw new IllegalArgumentException("Argument #" + annotatedParameter.getIndex() + " of constructor " + annotatedWithParams + " has no property name annotation; must have name when multiple-parameter constructor annotated as Creator");
        }
        return valueInstantiator;
    }

    private ValueInstantiator _findStdValueInstantiator(DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        if (beanDescription.getBeanClass() == JsonLocation.class) {
            return new JsonLocationInstantiator();
        }
        return null;
    }

    protected ValueInstantiator _constructDefaultValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) throws JsonMappingException {
        CreatorCollector creatorCollector = new CreatorCollector(beanDescription, deserializationContext.getConfig());
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        VisibilityChecker<?> visibilityChecker = deserializationConfig.getDefaultVisibilityChecker();
        visibilityChecker = annotationIntrospector.findAutoDetectVisibility(beanDescription.getClassInfo(), visibilityChecker);
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = this._findCreatorsFromProperties(deserializationContext, beanDescription);
        this._addDeserializerFactoryMethods(deserializationContext, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector, map);
        if (beanDescription.getType().isConcrete()) {
            this._addDeserializerConstructors(deserializationContext, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector, map);
        }
        return creatorCollector.constructValueInstantiator(deserializationConfig);
    }

    protected Map<AnnotatedWithParams, BeanPropertyDefinition[]> _findCreatorsFromProperties(DeserializationContext deserializationContext, BeanDescription beanDescription) throws JsonMappingException {
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = Collections.emptyMap();
        for (BeanPropertyDefinition beanPropertyDefinition : beanDescription.findProperties()) {
            Iterator<AnnotatedParameter> iterator = beanPropertyDefinition.getConstructorParameters();
            while (iterator.hasNext()) {
                AnnotatedParameter annotatedParameter = iterator.next();
                AnnotatedWithParams annotatedWithParams = annotatedParameter.getOwner();
                BeanPropertyDefinition[] beanPropertyDefinitionArray = map.get(annotatedWithParams);
                int n = annotatedParameter.getIndex();
                if (beanPropertyDefinitionArray == null) {
                    if (map.isEmpty()) {
                        map = new LinkedHashMap<AnnotatedWithParams, BeanPropertyDefinition[]>();
                    }
                    beanPropertyDefinitionArray = new BeanPropertyDefinition[annotatedWithParams.getParameterCount()];
                    map.put(annotatedWithParams, beanPropertyDefinitionArray);
                } else if (beanPropertyDefinitionArray[n] != null) {
                    throw new IllegalStateException("Conflict: parameter #" + n + " of " + annotatedWithParams + " bound to more than one property; " + beanPropertyDefinitionArray[n] + " vs " + beanPropertyDefinition);
                }
                beanPropertyDefinitionArray[n] = beanPropertyDefinition;
            }
        }
        return map;
    }

    public ValueInstantiator _valueInstantiatorInstance(DeserializationConfig deserializationConfig, Annotated annotated, Object object) throws JsonMappingException {
        ValueInstantiator valueInstantiator;
        if (object == null) {
            return null;
        }
        if (object instanceof ValueInstantiator) {
            return (ValueInstantiator)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + object.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
        }
        Class clazz = (Class)object;
        if (ClassUtil.isBogusClass(clazz)) {
            return null;
        }
        if (!ValueInstantiator.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<ValueInstantiator>");
        }
        HandlerInstantiator handlerInstantiator = deserializationConfig.getHandlerInstantiator();
        if (handlerInstantiator != null && (valueInstantiator = handlerInstantiator.valueInstantiatorInstance(deserializationConfig, annotated, clazz)) != null) {
            return valueInstantiator;
        }
        return (ValueInstantiator)ClassUtil.createInstance(clazz, deserializationConfig.canOverrideAccessModifiers());
    }

    protected void _addDeserializerConstructors(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector, Map<AnnotatedWithParams, BeanPropertyDefinition[]> map) throws JsonMappingException {
        AnnotatedConstructor annotatedConstructor = beanDescription.findDefaultConstructor();
        if (annotatedConstructor != null && (!creatorCollector.hasDefaultCreator() || annotationIntrospector.hasCreatorAnnotation(annotatedConstructor))) {
            creatorCollector.setDefaultCreator(annotatedConstructor);
        }
        LinkedList<AnnotatedConstructor> linkedList = null;
        for (AnnotatedConstructor annotatedConstructor2 : beanDescription.getConstructors()) {
            Serializable serializable;
            int n;
            Object object;
            boolean bl = annotationIntrospector.hasCreatorAnnotation(annotatedConstructor2);
            BeanPropertyDefinition[] beanPropertyDefinitionArray = map.get(annotatedConstructor2);
            int n2 = annotatedConstructor2.getParameterCount();
            if (n2 == 1) {
                object = beanPropertyDefinitionArray == null ? null : beanPropertyDefinitionArray[0];
                boolean bl2 = this._checkIfCreatorPropertyBased(annotationIntrospector, annotatedConstructor2, (BeanPropertyDefinition)object);
                if (bl2) {
                    SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[1];
                    PropertyName propertyName = object == null ? null : ((BeanPropertyDefinition)object).getFullName();
                    AnnotatedParameter annotatedParameter = annotatedConstructor2.getParameter(0);
                    settableBeanPropertyArray[0] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, 0, annotatedParameter, annotationIntrospector.findInjectableValueId(annotatedParameter));
                    creatorCollector.addPropertyCreator(annotatedConstructor2, bl, settableBeanPropertyArray);
                    continue;
                }
                this._handleSingleArgumentConstructor(deserializationContext, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector, annotatedConstructor2, bl, visibilityChecker.isCreatorVisible(annotatedConstructor2));
                if (object == null) continue;
                ((POJOPropertyBuilder)object).removeConstructors();
                continue;
            }
            object = null;
            SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (n = 0; n < n2; ++n) {
                PropertyName propertyName;
                serializable = annotatedConstructor2.getParameter(n);
                BeanPropertyDefinition beanPropertyDefinition = beanPropertyDefinitionArray == null ? null : beanPropertyDefinitionArray[n];
                Object object2 = annotationIntrospector.findInjectableValueId((AnnotatedMember)serializable);
                PropertyName propertyName2 = propertyName = beanPropertyDefinition == null ? null : beanPropertyDefinition.getFullName();
                if (beanPropertyDefinition != null && beanPropertyDefinition.isExplicitlyNamed()) {
                    ++n3;
                    settableBeanPropertyArray[n] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n, (AnnotatedParameter)serializable, object2);
                    continue;
                }
                if (object2 != null) {
                    ++n5;
                    settableBeanPropertyArray[n] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n, (AnnotatedParameter)serializable, object2);
                    continue;
                }
                NameTransformer nameTransformer = annotationIntrospector.findUnwrappingNameTransformer((AnnotatedMember)serializable);
                if (nameTransformer != null) {
                    settableBeanPropertyArray[n] = this.constructCreatorProperty(deserializationContext, beanDescription, UNWRAPPED_CREATOR_PARAM_NAME, n, (AnnotatedParameter)serializable, null);
                    ++n3;
                    continue;
                }
                if (bl && propertyName != null && !propertyName.isEmpty()) {
                    ++n4;
                    settableBeanPropertyArray[n] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n, (AnnotatedParameter)serializable, object2);
                    continue;
                }
                if (object != null) continue;
                object = serializable;
            }
            n = n3 + n4;
            if (bl || n3 > 0 || n5 > 0) {
                if (n + n5 == n2) {
                    creatorCollector.addPropertyCreator(annotatedConstructor2, bl, settableBeanPropertyArray);
                    continue;
                }
                if (n3 == 0 && n5 + 1 == n2) {
                    creatorCollector.addDelegatingCreator(annotatedConstructor2, bl, settableBeanPropertyArray);
                    continue;
                }
                serializable = this._findImplicitParamName((AnnotatedParameter)object, annotationIntrospector);
                if (serializable == null || ((PropertyName)serializable).isEmpty()) {
                    int n6 = ((AnnotatedParameter)object).getIndex();
                    if (n6 == 0 && ClassUtil.isNonStaticInnerClass(annotatedConstructor2.getDeclaringClass())) {
                        throw new IllegalArgumentException("Non-static inner classes like " + annotatedConstructor2.getDeclaringClass().getName() + " can not use @JsonCreator for constructors");
                    }
                    throw new IllegalArgumentException("Argument #" + n6 + " of constructor " + annotatedConstructor2 + " has no property name annotation; must have name when multiple-parameter constructor annotated as Creator");
                }
            }
            if (creatorCollector.hasDefaultCreator()) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<AnnotatedConstructor>();
            }
            linkedList.add(annotatedConstructor2);
        }
        if (linkedList != null && !creatorCollector.hasDelegatingCreator() && !creatorCollector.hasPropertyBasedCreator()) {
            this._checkImplicitlyNamedConstructors(deserializationContext, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector, linkedList);
        }
    }

    protected void _checkImplicitlyNamedConstructors(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector, List<AnnotatedConstructor> list) throws JsonMappingException {
        Object object;
        Serializable serializable;
        AnnotatedConstructor annotatedConstructor = null;
        SettableBeanProperty[] settableBeanPropertyArray = null;
        block0: for (AnnotatedConstructor annotatedConstructor2 : list) {
            if (!visibilityChecker.isCreatorVisible(annotatedConstructor2)) continue;
            int n = annotatedConstructor2.getParameterCount();
            SettableBeanProperty[] settableBeanPropertyArray2 = new SettableBeanProperty[n];
            for (int i = 0; i < n; ++i) {
                serializable = annotatedConstructor2.getParameter(i);
                object = this._findParamName((AnnotatedParameter)serializable, annotationIntrospector);
                if (object == null || ((PropertyName)object).isEmpty()) continue block0;
                settableBeanPropertyArray2[i] = this.constructCreatorProperty(deserializationContext, beanDescription, (PropertyName)object, ((AnnotatedParameter)serializable).getIndex(), (AnnotatedParameter)serializable, null);
            }
            if (annotatedConstructor != null) {
                annotatedConstructor = null;
                break;
            }
            annotatedConstructor = annotatedConstructor2;
            settableBeanPropertyArray = settableBeanPropertyArray2;
        }
        if (annotatedConstructor != null) {
            creatorCollector.addPropertyCreator(annotatedConstructor, false, settableBeanPropertyArray);
            BasicBeanDescription basicBeanDescription = (BasicBeanDescription)beanDescription;
            for (AnnotatedConstructor annotatedConstructor3 : settableBeanPropertyArray) {
                serializable = ((SettableBeanProperty)((Object)annotatedConstructor3)).getFullName();
                if (basicBeanDescription.hasProperty((PropertyName)serializable)) continue;
                object = SimpleBeanPropertyDefinition.construct(deserializationContext.getConfig(), ((SettableBeanProperty)((Object)annotatedConstructor3)).getMember(), (PropertyName)serializable);
                basicBeanDescription.addProperty((BeanPropertyDefinition)object);
            }
        }
    }

    protected boolean _checkIfCreatorPropertyBased(AnnotationIntrospector annotationIntrospector, AnnotatedWithParams annotatedWithParams, BeanPropertyDefinition beanPropertyDefinition) {
        String string;
        JsonCreator.Mode mode = annotationIntrospector.findCreatorBinding(annotatedWithParams);
        if (mode == JsonCreator.Mode.PROPERTIES) {
            return true;
        }
        if (mode == JsonCreator.Mode.DELEGATING) {
            return false;
        }
        if (beanPropertyDefinition != null && beanPropertyDefinition.isExplicitlyNamed() || annotationIntrospector.findInjectableValueId(annotatedWithParams.getParameter(0)) != null) {
            return true;
        }
        return beanPropertyDefinition != null && (string = beanPropertyDefinition.getName()) != null && !string.isEmpty() && beanPropertyDefinition.couldSerialize();
    }

    protected boolean _handleSingleArgumentConstructor(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector, AnnotatedConstructor annotatedConstructor, boolean bl, boolean bl2) throws JsonMappingException {
        Class<?> clazz = annotatedConstructor.getRawParameterType(0);
        if (clazz == String.class || clazz == CharSequence.class) {
            if (bl || bl2) {
                creatorCollector.addStringCreator(annotatedConstructor, bl);
            }
            return true;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (bl || bl2) {
                creatorCollector.addIntCreator(annotatedConstructor, bl);
            }
            return true;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            if (bl || bl2) {
                creatorCollector.addLongCreator(annotatedConstructor, bl);
            }
            return true;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if (bl || bl2) {
                creatorCollector.addDoubleCreator(annotatedConstructor, bl);
            }
            return true;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (bl || bl2) {
                creatorCollector.addBooleanCreator(annotatedConstructor, bl);
            }
            return true;
        }
        if (bl) {
            creatorCollector.addDelegatingCreator(annotatedConstructor, bl, null);
            return true;
        }
        return false;
    }

    protected void _addDeserializerFactoryMethods(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector, Map<AnnotatedWithParams, BeanPropertyDefinition[]> map) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
            int n;
            Object object;
            boolean bl = annotationIntrospector.hasCreatorAnnotation(annotatedMethod);
            int n2 = annotatedMethod.getParameterCount();
            if (n2 == 0) {
                if (!bl) continue;
                creatorCollector.setDefaultCreator(annotatedMethod);
                continue;
            }
            BeanPropertyDefinition[] beanPropertyDefinitionArray = map.get(annotatedMethod);
            if (n2 == 1) {
                object = beanPropertyDefinitionArray == null ? null : beanPropertyDefinitionArray[0];
                boolean bl2 = this._checkIfCreatorPropertyBased(annotationIntrospector, annotatedMethod, (BeanPropertyDefinition)object);
                if (!bl2) {
                    this._handleSingleArgumentFactory(deserializationConfig, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector, annotatedMethod, bl);
                    if (object == null) continue;
                    ((POJOPropertyBuilder)object).removeConstructors();
                    continue;
                }
            } else if (!bl) continue;
            object = null;
            SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (n = 0; n < n2; ++n) {
                PropertyName propertyName;
                AnnotatedParameter annotatedParameter = annotatedMethod.getParameter(n);
                BeanPropertyDefinition beanPropertyDefinition = beanPropertyDefinitionArray == null ? null : beanPropertyDefinitionArray[n];
                Object object2 = annotationIntrospector.findInjectableValueId(annotatedParameter);
                PropertyName propertyName2 = propertyName = beanPropertyDefinition == null ? null : beanPropertyDefinition.getFullName();
                if (beanPropertyDefinition != null && beanPropertyDefinition.isExplicitlyNamed()) {
                    ++n4;
                    settableBeanPropertyArray[n] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n, annotatedParameter, object2);
                    continue;
                }
                if (object2 != null) {
                    ++n5;
                    settableBeanPropertyArray[n] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n, annotatedParameter, object2);
                    continue;
                }
                NameTransformer nameTransformer = annotationIntrospector.findUnwrappingNameTransformer(annotatedParameter);
                if (nameTransformer != null) {
                    settableBeanPropertyArray[n] = this.constructCreatorProperty(deserializationContext, beanDescription, UNWRAPPED_CREATOR_PARAM_NAME, n, annotatedParameter, null);
                    ++n3;
                    continue;
                }
                if (bl && propertyName != null && !propertyName.isEmpty()) {
                    ++n3;
                    settableBeanPropertyArray[n] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n, annotatedParameter, object2);
                    continue;
                }
                if (object != null) continue;
                object = annotatedParameter;
            }
            n = n4 + n3;
            if (!bl && n4 <= 0 && n5 <= 0) continue;
            if (n + n5 == n2) {
                creatorCollector.addPropertyCreator(annotatedMethod, bl, settableBeanPropertyArray);
                continue;
            }
            if (n4 == 0 && n5 + 1 == n2) {
                creatorCollector.addDelegatingCreator(annotatedMethod, bl, settableBeanPropertyArray);
                continue;
            }
            throw new IllegalArgumentException("Argument #" + ((AnnotatedParameter)object).getIndex() + " of factory method " + annotatedMethod + " has no property name annotation; must have name when multiple-parameter constructor annotated as Creator");
        }
    }

    protected boolean _handleSingleArgumentFactory(DeserializationConfig deserializationConfig, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector, AnnotatedMethod annotatedMethod, boolean bl) throws JsonMappingException {
        Class<?> clazz = annotatedMethod.getRawParameterType(0);
        if (clazz == String.class || clazz == CharSequence.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addStringCreator(annotatedMethod, bl);
            }
            return true;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addIntCreator(annotatedMethod, bl);
            }
            return true;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addLongCreator(annotatedMethod, bl);
            }
            return true;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addDoubleCreator(annotatedMethod, bl);
            }
            return true;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addBooleanCreator(annotatedMethod, bl);
            }
            return true;
        }
        if (bl) {
            creatorCollector.addDelegatingCreator(annotatedMethod, bl, null);
            return true;
        }
        return false;
    }

    protected SettableBeanProperty constructCreatorProperty(DeserializationContext deserializationContext, BeanDescription beanDescription, PropertyName propertyName, int n, AnnotatedParameter annotatedParameter, Object object) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer;
        Serializable serializable;
        Object object2;
        Serializable serializable2;
        PropertyMetadata propertyMetadata;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            propertyMetadata = PropertyMetadata.STD_REQUIRED_OR_OPTIONAL;
        } else {
            serializable2 = annotationIntrospector.hasRequiredMarker(annotatedParameter);
            boolean bl = serializable2 != null && ((Boolean)serializable2).booleanValue();
            object2 = annotationIntrospector.findPropertyDescription(annotatedParameter);
            serializable = annotationIntrospector.findPropertyIndex(annotatedParameter);
            jsonDeserializer = annotationIntrospector.findPropertyDefaultValue(annotatedParameter);
            propertyMetadata = PropertyMetadata.construct(bl, (String)object2, (Integer)serializable, (String)((Object)jsonDeserializer));
        }
        serializable2 = this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedParameter, annotatedParameter.getType());
        BeanProperty.Std std = new BeanProperty.Std(propertyName, (JavaType)serializable2, annotationIntrospector.findWrapperName(annotatedParameter), beanDescription.getClassAnnotations(), annotatedParameter, propertyMetadata);
        object2 = (TypeDeserializer)((JavaType)serializable2).getTypeHandler();
        if (object2 == null) {
            object2 = this.findTypeDeserializer(deserializationConfig, (JavaType)serializable2);
        }
        serializable = new CreatorProperty(propertyName, (JavaType)serializable2, std.getWrapperName(), (TypeDeserializer)object2, beanDescription.getClassAnnotations(), annotatedParameter, n, object, propertyMetadata);
        jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, annotatedParameter);
        if (jsonDeserializer == null) {
            jsonDeserializer = (JsonDeserializer)((JavaType)serializable2).getValueHandler();
        }
        if (jsonDeserializer != null) {
            jsonDeserializer = deserializationContext.handlePrimaryContextualization(jsonDeserializer, (BeanProperty)((Object)serializable), (JavaType)serializable2);
            serializable = ((SettableBeanProperty)serializable).withValueDeserializer(jsonDeserializer);
        }
        return serializable;
    }

    protected PropertyName _findParamName(AnnotatedParameter annotatedParameter, AnnotationIntrospector annotationIntrospector) {
        if (annotatedParameter != null && annotationIntrospector != null) {
            PropertyName propertyName = annotationIntrospector.findNameForDeserialization(annotatedParameter);
            if (propertyName != null) {
                return propertyName;
            }
            String string = annotationIntrospector.findImplicitPropertyName(annotatedParameter);
            if (string != null && !string.isEmpty()) {
                return PropertyName.construct(string);
            }
        }
        return null;
    }

    protected PropertyName _findImplicitParamName(AnnotatedParameter annotatedParameter, AnnotationIntrospector annotationIntrospector) {
        String string = annotationIntrospector.findImplicitPropertyName(annotatedParameter);
        if (string != null && !string.isEmpty()) {
            return PropertyName.construct(string);
        }
        return null;
    }

    @Deprecated
    protected PropertyName _findExplicitParamName(AnnotatedParameter annotatedParameter, AnnotationIntrospector annotationIntrospector) {
        if (annotatedParameter != null && annotationIntrospector != null) {
            return annotationIntrospector.findNameForDeserialization(annotatedParameter);
        }
        return null;
    }

    @Deprecated
    protected boolean _hasExplicitParamName(AnnotatedParameter annotatedParameter, AnnotationIntrospector annotationIntrospector) {
        if (annotatedParameter != null && annotationIntrospector != null) {
            PropertyName propertyName = annotationIntrospector.findNameForDeserialization(annotatedParameter);
            return propertyName != null && propertyName.hasSimpleName();
        }
        return false;
    }

    @Override
    public JsonDeserializer<?> createArrayDeserializer(DeserializationContext deserializationContext, ArrayType arrayType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer jsonDeserializer;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JavaType javaType = arrayType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomArrayDeserializer(arrayType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) == null) {
            if (jsonDeserializer2 == null) {
                Class<?> clazz = javaType.getRawClass();
                if (javaType.isPrimitive()) {
                    return PrimitiveArrayDeserializers.forType(clazz);
                }
                if (clazz == String.class) {
                    return StringArrayDeserializer.instance;
                }
            }
            jsonDeserializer = new ObjectArrayDeserializer(arrayType, jsonDeserializer2, typeDeserializer);
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyArrayDeserializer(deserializationConfig, arrayType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createCollectionDeserializer(DeserializationContext deserializationContext, CollectionType object, BeanDescription beanDescription) throws JsonMappingException {
        Object object2;
        JsonDeserializer jsonDeserializer;
        JavaType javaType = ((CollectionLikeType)object).getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomCollectionDeserializer((CollectionType)object, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) == null) {
            object2 = ((JavaType)object).getRawClass();
            if (jsonDeserializer2 == null && EnumSet.class.isAssignableFrom((Class<?>)object2)) {
                jsonDeserializer = new EnumSetDeserializer(javaType, null);
            }
        }
        if (jsonDeserializer == null) {
            if (((JavaType)object).isInterface() || ((JavaType)object).isAbstract()) {
                object2 = this._mapAbstractCollectionType((JavaType)object, deserializationConfig);
                if (object2 == null) {
                    if (((JavaType)object).getTypeHandler() == null) {
                        throw new IllegalArgumentException("Can not find a deserializer for non-concrete Collection type " + object);
                    }
                    jsonDeserializer = AbstractDeserializer.constructForNonPOJO(beanDescription);
                } else {
                    object = object2;
                    beanDescription = deserializationConfig.introspectForCreation((JavaType)object);
                }
            }
            if (jsonDeserializer == null) {
                object2 = this.findValueInstantiator(deserializationContext, beanDescription);
                if (!((ValueInstantiator)object2).canCreateUsingDefault() && ((JavaType)object).getRawClass() == ArrayBlockingQueue.class) {
                    return new ArrayBlockingQueueDeserializer((JavaType)object, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object2);
                }
                jsonDeserializer = javaType.getRawClass() == String.class ? new StringCollectionDeserializer((JavaType)object, jsonDeserializer2, (ValueInstantiator)object2) : new CollectionDeserializer((JavaType)object, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object2);
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyCollectionDeserializer(deserializationConfig, (CollectionType)object, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected CollectionType _mapAbstractCollectionType(JavaType javaType, DeserializationConfig deserializationConfig) {
        Class<Object> clazz = javaType.getRawClass();
        if ((clazz = _collectionFallbacks.get(clazz.getName())) == null) {
            return null;
        }
        return (CollectionType)deserializationConfig.constructSpecializedType(javaType, clazz);
    }

    @Override
    public JsonDeserializer<?> createCollectionLikeDeserializer(DeserializationContext deserializationContext, CollectionLikeType collectionLikeType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        JavaType javaType = collectionLikeType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomCollectionLikeDeserializer(collectionLikeType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyCollectionLikeDeserializer(deserializationConfig, collectionLikeType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createMapDeserializer(DeserializationContext deserializationContext, MapType mapType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer jsonDeserializer;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JavaType javaType = mapType.getKeyType();
        JavaType javaType2 = mapType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType2.getValueHandler();
        KeyDeserializer keyDeserializer = (KeyDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType2.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType2);
        }
        if ((jsonDeserializer = this._findCustomMapDeserializer(mapType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer2)) == null) {
            Class clazz2 = mapType.getRawClass();
            if (EnumMap.class.isAssignableFrom(clazz2)) {
                Class<?> clazz = javaType.getRawClass();
                if (clazz == null || !clazz.isEnum()) {
                    throw new IllegalArgumentException("Can not construct EnumMap; generic (key) type not available");
                }
                jsonDeserializer = new EnumMapDeserializer(mapType, null, jsonDeserializer2, typeDeserializer);
            }
            if (jsonDeserializer == null) {
                if (mapType.isInterface() || mapType.isAbstract()) {
                    Class<? extends Map> clazz = _mapFallbacks.get(clazz2.getName());
                    if (clazz != null) {
                        clazz2 = clazz;
                        mapType = (MapType)deserializationConfig.constructSpecializedType(mapType, clazz2);
                        beanDescription = deserializationConfig.introspectForCreation(mapType);
                    } else {
                        if (mapType.getTypeHandler() == null) {
                            throw new IllegalArgumentException("Can not find a deserializer for non-concrete Map type " + mapType);
                        }
                        jsonDeserializer = AbstractDeserializer.constructForNonPOJO(beanDescription);
                    }
                }
                if (jsonDeserializer == null) {
                    ValueInstantiator valueInstantiator = this.findValueInstantiator(deserializationContext, beanDescription);
                    MapDeserializer mapDeserializer = new MapDeserializer(mapType, valueInstantiator, keyDeserializer, jsonDeserializer2, typeDeserializer);
                    JsonIgnoreProperties.Value value = deserializationConfig.getDefaultPropertyIgnorals(Map.class, beanDescription.getClassInfo());
                    Set set = value == null ? null : value.findIgnoredForDeserialization();
                    mapDeserializer.setIgnorableProperties(set);
                    jsonDeserializer = mapDeserializer;
                }
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyMapDeserializer(deserializationConfig, mapType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createMapLikeDeserializer(DeserializationContext deserializationContext, MapLikeType mapLikeType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        JavaType javaType = mapLikeType.getKeyType();
        JavaType javaType2 = mapLikeType.getContentType();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType2.getValueHandler();
        KeyDeserializer keyDeserializer = (KeyDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType2.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType2);
        }
        if ((jsonDeserializer = this._findCustomMapLikeDeserializer(mapLikeType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer2)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyMapLikeDeserializer(deserializationConfig, mapLikeType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createEnumDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Class<?> clazz = javaType.getRawClass();
        JsonDeserializer jsonDeserializer = this._findCustomEnumDeserializer(clazz, deserializationConfig, beanDescription);
        if (jsonDeserializer == null) {
            ValueInstantiator valueInstantiator = this._constructDefaultValueInstantiator(deserializationContext, beanDescription);
            SettableBeanProperty[] object = valueInstantiator == null ? null : valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
            for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
                if (!deserializationContext.getAnnotationIntrospector().hasCreatorAnnotation(annotatedMethod)) continue;
                if (annotatedMethod.getParameterCount() == 0) {
                    jsonDeserializer = EnumDeserializer.deserializerForNoArgsCreator(deserializationConfig, clazz, annotatedMethod);
                    break;
                }
                Class<?> clazz2 = annotatedMethod.getRawReturnType();
                if (!clazz2.isAssignableFrom(clazz)) continue;
                jsonDeserializer = EnumDeserializer.deserializerForCreator(deserializationConfig, clazz, annotatedMethod, valueInstantiator, object);
                break;
            }
            if (jsonDeserializer == null) {
                jsonDeserializer = new EnumDeserializer(this.constructEnumResolver(clazz, deserializationConfig, beanDescription.findJsonValueMethod()));
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyEnumDeserializer(deserializationConfig, javaType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createTreeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        JsonDeserializer<?> jsonDeserializer = this._findCustomTreeNodeDeserializer(clazz, deserializationConfig, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return JsonNodeDeserializer.getDeserializer(clazz);
    }

    @Override
    public JsonDeserializer<?> createReferenceDeserializer(DeserializationContext deserializationContext, ReferenceType referenceType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        JavaType javaType = referenceType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomReferenceDeserializer(referenceType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) == null && AtomicReference.class.isAssignableFrom(referenceType.getRawClass())) {
            return new AtomicReferenceDeserializer(referenceType, typeDeserializer, jsonDeserializer2);
        }
        if (jsonDeserializer != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyReferenceDeserializer(deserializationConfig, referenceType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public TypeDeserializer findTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType) throws JsonMappingException {
        JavaType javaType2;
        BeanDescription beanDescription = deserializationConfig.introspectClassAnnotations(javaType.getRawClass());
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findTypeResolver(deserializationConfig, annotatedClass, javaType);
        Collection<NamedType> collection = null;
        if (typeResolverBuilder == null) {
            typeResolverBuilder = deserializationConfig.getDefaultTyper(javaType);
            if (typeResolverBuilder == null) {
                return null;
            }
        } else {
            collection = deserializationConfig.getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, annotatedClass);
        }
        if (typeResolverBuilder.getDefaultImpl() == null && javaType.isAbstract() && (javaType2 = this.mapAbstractType(deserializationConfig, javaType)) != null && javaType2.getRawClass() != javaType.getRawClass()) {
            typeResolverBuilder = typeResolverBuilder.defaultImpl(javaType2.getRawClass());
        }
        return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType, collection);
    }

    protected JsonDeserializer<?> findOptionalStdDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        return OptionalHandlerFactory.instance.findDeserializer(javaType, deserializationContext.getConfig(), beanDescription);
    }

    @Override
    public KeyDeserializer createKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        KeyDeserializer keyDeserializer = null;
        if (this._factoryConfig.hasKeyDeserializers()) {
            KeyDeserializers keyDeserializers;
            BeanDescription beanDescription = deserializationConfig.introspectClassAnnotations(javaType.getRawClass());
            Iterator<KeyDeserializers> object = this._factoryConfig.keyDeserializers().iterator();
            while (object.hasNext() && (keyDeserializer = (keyDeserializers = object.next()).findKeyDeserializer(javaType, deserializationConfig, beanDescription)) == null) {
            }
        }
        if (keyDeserializer == null) {
            keyDeserializer = javaType.isEnumType() ? this._createEnumKeyDeserializer(deserializationContext, javaType) : StdKeyDeserializers.findStringBasedKeyDeserializer(deserializationConfig, javaType);
        }
        if (keyDeserializer != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                keyDeserializer = beanDeserializerModifier.modifyKeyDeserializer(deserializationConfig, javaType, keyDeserializer);
            }
        }
        return keyDeserializer;
    }

    private KeyDeserializer _createEnumKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Class<?> clazz = javaType.getRawClass();
        Object t = deserializationConfig.introspect(javaType);
        KeyDeserializer keyDeserializer = this.findKeyDeserializerFromAnnotation(deserializationContext, ((BeanDescription)t).getClassInfo());
        if (keyDeserializer != null) {
            return keyDeserializer;
        }
        JsonDeserializer<?> jsonDeserializer = this._findCustomEnumDeserializer(clazz, deserializationConfig, (BeanDescription)t);
        if (jsonDeserializer != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, javaType, jsonDeserializer);
        }
        JsonDeserializer<Object> jsonDeserializer2 = this.findDeserializerFromAnnotation(deserializationContext, ((BeanDescription)t).getClassInfo());
        if (jsonDeserializer2 != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, javaType, jsonDeserializer2);
        }
        jsonDeserializer = this.constructEnumResolver(clazz, deserializationConfig, ((BeanDescription)t).findJsonValueMethod());
        jsonDeserializer2 = deserializationConfig.getAnnotationIntrospector();
        for (AnnotatedMethod annotatedMethod : ((BeanDescription)t).getFactoryMethods()) {
            Class<?> clazz2;
            if (!((AnnotationIntrospector)((Object)jsonDeserializer2)).hasCreatorAnnotation(annotatedMethod)) continue;
            int n = annotatedMethod.getParameterCount();
            if (n == 1 && (clazz2 = annotatedMethod.getRawReturnType()).isAssignableFrom(clazz)) {
                if (annotatedMethod.getRawParameterType(0) != String.class) {
                    throw new IllegalArgumentException("Parameter #0 type for factory method (" + annotatedMethod + ") not suitable, must be java.lang.String");
                }
                if (deserializationConfig.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationContext.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                }
                return StdKeyDeserializers.constructEnumKeyDeserializer((EnumResolver)((Object)jsonDeserializer), annotatedMethod);
            }
            throw new IllegalArgumentException("Unsuitable method (" + annotatedMethod + ") decorated with @JsonCreator (for Enum type " + clazz.getName() + ")");
        }
        return StdKeyDeserializers.constructEnumKeyDeserializer((EnumResolver)((Object)jsonDeserializer));
    }

    public TypeDeserializer findPropertyTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember annotatedMember) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findPropertyTypeResolver(deserializationConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            return this.findTypeDeserializer(deserializationConfig, javaType);
        }
        Collection<NamedType> collection = deserializationConfig.getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, annotatedMember, javaType);
        return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType, collection);
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember annotatedMember) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findPropertyContentTypeResolver(deserializationConfig, annotatedMember, javaType);
        JavaType javaType2 = javaType.getContentType();
        if (typeResolverBuilder == null) {
            return this.findTypeDeserializer(deserializationConfig, javaType2);
        }
        Collection<NamedType> collection = deserializationConfig.getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, annotatedMember, javaType2);
        return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType2, collection);
    }

    public JsonDeserializer<?> findDefaultDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        Class<?> clazz = javaType.getRawClass();
        if (clazz == CLASS_OBJECT) {
            JavaType javaType2;
            JavaType javaType3;
            DeserializationConfig deserializationConfig = deserializationContext.getConfig();
            if (this._factoryConfig.hasAbstractTypeResolvers()) {
                javaType3 = this._findRemappedType(deserializationConfig, List.class);
                javaType2 = this._findRemappedType(deserializationConfig, Map.class);
            } else {
                javaType2 = null;
                javaType3 = null;
            }
            return new UntypedObjectDeserializer(javaType3, javaType2);
        }
        if (clazz == CLASS_STRING || clazz == CLASS_CHAR_BUFFER) {
            return StringDeserializer.instance;
        }
        if (clazz == CLASS_ITERABLE) {
            TypeFactory typeFactory = deserializationContext.getTypeFactory();
            JavaType[] javaTypeArray = typeFactory.findTypeParameters(javaType, CLASS_ITERABLE);
            JavaType javaType4 = javaTypeArray == null || javaTypeArray.length != 1 ? TypeFactory.unknownType() : javaTypeArray[0];
            CollectionType collectionType = typeFactory.constructCollectionType(Collection.class, javaType4);
            return this.createCollectionDeserializer(deserializationContext, collectionType, beanDescription);
        }
        if (clazz == CLASS_MAP_ENTRY) {
            TypeDeserializer typeDeserializer;
            JavaType javaType5;
            JavaType javaType6 = javaType.containedType(0);
            if (javaType6 == null) {
                javaType6 = TypeFactory.unknownType();
            }
            if ((javaType5 = javaType.containedType(1)) == null) {
                javaType5 = TypeFactory.unknownType();
            }
            if ((typeDeserializer = (TypeDeserializer)javaType5.getTypeHandler()) == null) {
                typeDeserializer = this.findTypeDeserializer(deserializationContext.getConfig(), javaType5);
            }
            JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType5.getValueHandler();
            KeyDeserializer keyDeserializer = (KeyDeserializer)javaType6.getValueHandler();
            return new MapEntryDeserializer(javaType, keyDeserializer, (JsonDeserializer<Object>)jsonDeserializer2, typeDeserializer);
        }
        String string = clazz.getName();
        if (clazz.isPrimitive() || string.startsWith("java.")) {
            jsonDeserializer = NumberDeserializers.find(clazz, string);
            if (jsonDeserializer == null) {
                jsonDeserializer = DateDeserializers.find(clazz, string);
            }
            if (jsonDeserializer != null) {
                return jsonDeserializer;
            }
        }
        if (clazz == TokenBuffer.class) {
            return new TokenBufferDeserializer();
        }
        jsonDeserializer = this.findOptionalStdDeserializer(deserializationContext, javaType, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return JdkDeserializers.find(clazz, string);
    }

    protected JavaType _findRemappedType(DeserializationConfig deserializationConfig, Class<?> clazz) throws JsonMappingException {
        JavaType javaType = this.mapAbstractType(deserializationConfig, deserializationConfig.constructType(clazz));
        return javaType == null || javaType.hasRawClass(clazz) ? null : javaType;
    }

    protected JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer = deserializers.findTreeNodeDeserializer(clazz, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomReferenceDeserializer(ReferenceType referenceType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findReferenceDeserializer(referenceType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<Object> _findCustomBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<Object> jsonDeserializer = deserializers.findBeanDeserializer(javaType, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType arrayType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findArrayDeserializer(arrayType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findCollectionDeserializer(collectionType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType collectionLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findCollectionLikeDeserializer(collectionLikeType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer = deserializers.findEnumDeserializer(clazz, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findMapDeserializer(mapType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findMapLikeDeserializer(mapLikeType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector != null && (object = annotationIntrospector.findDeserializer(annotated)) != null) {
            return deserializationContext.deserializerInstance(annotated, object);
        }
        return null;
    }

    protected KeyDeserializer findKeyDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector != null && (object = annotationIntrospector.findKeyDeserializer(annotated)) != null) {
            return deserializationContext.keyDeserializerInstance(annotated, object);
        }
        return null;
    }

    protected JavaType resolveMemberAndTypeAnnotations(DeserializationContext deserializationContext, AnnotatedMember annotatedMember, JavaType javaType) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer;
        Object object;
        Object object2;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType;
        }
        if (javaType.isMapLikeType() && (object2 = javaType.getKeyType()) != null && (object = deserializationContext.keyDeserializerInstance(annotatedMember, jsonDeserializer = annotationIntrospector.findKeyDeserializer(annotatedMember))) != null) {
            javaType = ((MapLikeType)javaType).withKeyValueHandler(object);
            object2 = javaType.getKeyType();
        }
        if (javaType.hasContentType()) {
            object2 = annotationIntrospector.findContentDeserializer(annotatedMember);
            jsonDeserializer = deserializationContext.deserializerInstance(annotatedMember, object2);
            if (jsonDeserializer != null) {
                javaType = javaType.withContentValueHandler(jsonDeserializer);
            }
            if ((object = this.findPropertyContentTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
                javaType = javaType.withContentTypeHandler(object);
            }
        }
        if ((object2 = this.findPropertyTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
            javaType = javaType.withTypeHandler(object2);
        }
        javaType = annotationIntrospector.refineDeserializationType(deserializationContext.getConfig(), annotatedMember, javaType);
        return javaType;
    }

    protected EnumResolver constructEnumResolver(Class<?> clazz, DeserializationConfig deserializationConfig, AnnotatedMethod annotatedMethod) {
        if (annotatedMethod != null) {
            Method method = annotatedMethod.getAnnotated();
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(method, deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return EnumResolver.constructUnsafeUsingMethod(clazz, method, deserializationConfig.getAnnotationIntrospector());
        }
        return EnumResolver.constructUnsafe(clazz, deserializationConfig.getAnnotationIntrospector());
    }

    @Deprecated
    protected JavaType modifyTypeByAnnotation(DeserializationContext deserializationContext, Annotated annotated, JavaType javaType) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType;
        }
        return annotationIntrospector.refineDeserializationType(deserializationContext.getConfig(), annotated, javaType);
    }

    @Deprecated
    protected JavaType resolveType(DeserializationContext deserializationContext, BeanDescription beanDescription, JavaType javaType, AnnotatedMember annotatedMember) throws JsonMappingException {
        return this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedMember, javaType);
    }

    @Deprecated
    protected AnnotatedMethod _findJsonValueFor(DeserializationConfig deserializationConfig, JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        Object t = deserializationConfig.introspect(javaType);
        return ((BeanDescription)t).findJsonValueMethod();
    }

    static {
        _mapFallbacks.put(Map.class.getName(), LinkedHashMap.class);
        _mapFallbacks.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
        _mapFallbacks.put(SortedMap.class.getName(), TreeMap.class);
        _mapFallbacks.put(NavigableMap.class.getName(), TreeMap.class);
        _mapFallbacks.put(ConcurrentNavigableMap.class.getName(), ConcurrentSkipListMap.class);
        _collectionFallbacks = new HashMap();
        _collectionFallbacks.put(Collection.class.getName(), ArrayList.class);
        _collectionFallbacks.put(List.class.getName(), ArrayList.class);
        _collectionFallbacks.put(Set.class.getName(), HashSet.class);
        _collectionFallbacks.put(SortedSet.class.getName(), TreeSet.class);
        _collectionFallbacks.put(Queue.class.getName(), LinkedList.class);
        _collectionFallbacks.put("java.util.Deque", LinkedList.class);
        _collectionFallbacks.put("java.util.NavigableSet", TreeSet.class);
    }
}

