/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Instantiatable;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.RootNameLookup;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;

public final class SerializationConfig
extends MapperConfigBase<SerializationFeature, SerializationConfig>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final PrettyPrinter DEFAULT_PRETTY_PRINTER = new DefaultPrettyPrinter();
    protected static final JsonInclude.Value DEFAULT_INCLUSION = JsonInclude.Value.empty();
    protected final FilterProvider _filterProvider;
    protected final PrettyPrinter _defaultPrettyPrinter;
    protected final int _serFeatures;
    protected final int _generatorFeatures;
    protected final int _generatorFeaturesToChange;
    protected final int _formatWriteFeatures;
    protected final int _formatWriteFeaturesToChange;
    protected final JsonInclude.Value _serializationInclusion;

    public SerializationConfig(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        super(baseSettings, subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides);
        this._serFeatures = SerializationConfig.collectFeatureDefaults(SerializationFeature.class);
        this._filterProvider = null;
        this._defaultPrettyPrinter = DEFAULT_PRETTY_PRINTER;
        this._generatorFeatures = 0;
        this._generatorFeaturesToChange = 0;
        this._formatWriteFeatures = 0;
        this._formatWriteFeaturesToChange = 0;
        this._serializationInclusion = DEFAULT_INCLUSION;
    }

    @Deprecated
    public SerializationConfig(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup) {
        this(baseSettings, subtypeResolver, simpleMixInResolver, rootNameLookup, null);
    }

    private SerializationConfig(SerializationConfig serializationConfig, SubtypeResolver subtypeResolver) {
        super(serializationConfig, subtypeResolver);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, int n, int n2, int n3, int n4, int n5, int n6) {
        super(serializationConfig, n);
        this._serFeatures = n2;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = n3;
        this._generatorFeaturesToChange = n4;
        this._formatWriteFeatures = n5;
        this._formatWriteFeaturesToChange = n6;
    }

    private SerializationConfig(SerializationConfig serializationConfig, BaseSettings baseSettings) {
        super(serializationConfig, baseSettings);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, FilterProvider filterProvider) {
        super(serializationConfig);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, Class<?> clazz) {
        super(serializationConfig, clazz);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, JsonInclude.Value value) {
        super(serializationConfig);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = value;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, PropertyName propertyName) {
        super(serializationConfig, propertyName);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    protected SerializationConfig(SerializationConfig serializationConfig, ContextAttributes contextAttributes) {
        super(serializationConfig, contextAttributes);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    protected SerializationConfig(SerializationConfig serializationConfig, SimpleMixInResolver simpleMixInResolver) {
        super(serializationConfig, simpleMixInResolver);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    protected SerializationConfig(SerializationConfig serializationConfig, PrettyPrinter prettyPrinter) {
        super(serializationConfig);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = prettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    protected SerializationConfig(SerializationConfig serializationConfig, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        super(serializationConfig, simpleMixInResolver, rootNameLookup, configOverrides);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    @Override
    public SerializationConfig with(MapperFeature ... mapperFeatureArray) {
        int n = this._mapperFeatures;
        for (MapperFeature mapperFeature : mapperFeatureArray) {
            n |= mapperFeature.getMask();
        }
        return n == this._mapperFeatures ? this : new SerializationConfig(this, n, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    @Override
    public SerializationConfig without(MapperFeature ... mapperFeatureArray) {
        int n = this._mapperFeatures;
        for (MapperFeature mapperFeature : mapperFeatureArray) {
            n &= ~mapperFeature.getMask();
        }
        return n == this._mapperFeatures ? this : new SerializationConfig(this, n, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    @Override
    public SerializationConfig with(MapperFeature mapperFeature, boolean bl) {
        int n = bl ? this._mapperFeatures | mapperFeature.getMask() : this._mapperFeatures & ~mapperFeature.getMask();
        return n == this._mapperFeatures ? this : new SerializationConfig(this, n, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    @Override
    public SerializationConfig with(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withAnnotationIntrospector(annotationIntrospector));
    }

    @Override
    public SerializationConfig withAppendedAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withAppendedAnnotationIntrospector(annotationIntrospector));
    }

    @Override
    public SerializationConfig withInsertedAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withInsertedAnnotationIntrospector(annotationIntrospector));
    }

    @Override
    public SerializationConfig with(ClassIntrospector classIntrospector) {
        return this._withBase(this._base.withClassIntrospector(classIntrospector));
    }

    @Override
    public SerializationConfig with(DateFormat dateFormat) {
        SerializationConfig serializationConfig = new SerializationConfig(this, this._base.withDateFormat(dateFormat));
        serializationConfig = dateFormat == null ? serializationConfig.with(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS) : serializationConfig.without(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return serializationConfig;
    }

    @Override
    public SerializationConfig with(HandlerInstantiator handlerInstantiator) {
        return this._withBase(this._base.withHandlerInstantiator(handlerInstantiator));
    }

    @Override
    public SerializationConfig with(PropertyNamingStrategy propertyNamingStrategy) {
        return this._withBase(this._base.withPropertyNamingStrategy(propertyNamingStrategy));
    }

    @Override
    public SerializationConfig withRootName(PropertyName propertyName) {
        if (propertyName == null ? this._rootName == null : propertyName.equals(this._rootName)) {
            return this;
        }
        return new SerializationConfig(this, propertyName);
    }

    @Override
    public SerializationConfig with(SubtypeResolver subtypeResolver) {
        return subtypeResolver == this._subtypeResolver ? this : new SerializationConfig(this, subtypeResolver);
    }

    @Override
    public SerializationConfig with(TypeFactory typeFactory) {
        return this._withBase(this._base.withTypeFactory(typeFactory));
    }

    @Override
    public SerializationConfig with(TypeResolverBuilder<?> typeResolverBuilder) {
        return this._withBase(this._base.withTypeResolverBuilder(typeResolverBuilder));
    }

    @Override
    public SerializationConfig withView(Class<?> clazz) {
        return this._view == clazz ? this : new SerializationConfig(this, clazz);
    }

    @Override
    public SerializationConfig with(VisibilityChecker<?> visibilityChecker) {
        return this._withBase(this._base.withVisibilityChecker(visibilityChecker));
    }

    @Override
    public SerializationConfig withVisibility(PropertyAccessor propertyAccessor, JsonAutoDetect.Visibility visibility) {
        return this._withBase(this._base.withVisibility(propertyAccessor, visibility));
    }

    @Override
    public SerializationConfig with(Locale locale) {
        return this._withBase(this._base.with(locale));
    }

    @Override
    public SerializationConfig with(TimeZone timeZone) {
        return this._withBase(this._base.with(timeZone));
    }

    @Override
    public SerializationConfig with(Base64Variant base64Variant) {
        return this._withBase(this._base.with(base64Variant));
    }

    @Override
    public SerializationConfig with(ContextAttributes contextAttributes) {
        return contextAttributes == this._attributes ? this : new SerializationConfig(this, contextAttributes);
    }

    private final SerializationConfig _withBase(BaseSettings baseSettings) {
        return this._base == baseSettings ? this : new SerializationConfig(this, baseSettings);
    }

    public SerializationConfig with(SerializationFeature serializationFeature) {
        int n = this._serFeatures | serializationFeature.getMask();
        return n == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig with(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        int n = this._serFeatures | serializationFeature.getMask();
        for (SerializationFeature serializationFeature2 : serializationFeatureArray) {
            n |= serializationFeature2.getMask();
        }
        return n == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig withFeatures(SerializationFeature ... serializationFeatureArray) {
        int n = this._serFeatures;
        for (SerializationFeature serializationFeature : serializationFeatureArray) {
            n |= serializationFeature.getMask();
        }
        return n == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig without(SerializationFeature serializationFeature) {
        int n = this._serFeatures & ~serializationFeature.getMask();
        return n == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig without(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        int n = this._serFeatures & ~serializationFeature.getMask();
        for (SerializationFeature serializationFeature2 : serializationFeatureArray) {
            n &= ~serializationFeature2.getMask();
        }
        return n == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig withoutFeatures(SerializationFeature ... serializationFeatureArray) {
        int n = this._serFeatures;
        for (SerializationFeature serializationFeature : serializationFeatureArray) {
            n &= ~serializationFeature.getMask();
        }
        return n == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig with(JsonGenerator.Feature feature) {
        int n = this._generatorFeatures | feature.getMask();
        int n2 = this._generatorFeaturesToChange | feature.getMask();
        return this._generatorFeatures == n && this._generatorFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, n, n2, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig withFeatures(JsonGenerator.Feature ... featureArray) {
        int n = this._generatorFeatures;
        int n2 = this._generatorFeaturesToChange;
        for (JsonGenerator.Feature feature : featureArray) {
            int n3 = feature.getMask();
            n |= n3;
            n2 |= n3;
        }
        return this._generatorFeatures == n && this._generatorFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, n, n2, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig without(JsonGenerator.Feature feature) {
        int n = this._generatorFeatures & ~feature.getMask();
        int n2 = this._generatorFeaturesToChange | feature.getMask();
        return this._generatorFeatures == n && this._generatorFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, n, n2, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig withoutFeatures(JsonGenerator.Feature ... featureArray) {
        int n = this._generatorFeatures;
        int n2 = this._generatorFeaturesToChange;
        for (JsonGenerator.Feature feature : featureArray) {
            int n3 = feature.getMask();
            n &= ~n3;
            n2 |= n3;
        }
        return this._generatorFeatures == n && this._generatorFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, n, n2, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig with(FormatFeature formatFeature) {
        int n = this._formatWriteFeatures | formatFeature.getMask();
        int n2 = this._formatWriteFeaturesToChange | formatFeature.getMask();
        return this._formatWriteFeatures == n && this._formatWriteFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, n, n2);
    }

    public SerializationConfig withFeatures(FormatFeature ... formatFeatureArray) {
        int n = this._formatWriteFeatures;
        int n2 = this._formatWriteFeaturesToChange;
        for (FormatFeature formatFeature : formatFeatureArray) {
            int n3 = formatFeature.getMask();
            n |= n3;
            n2 |= n3;
        }
        return this._formatWriteFeatures == n && this._formatWriteFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, n, n2);
    }

    public SerializationConfig without(FormatFeature formatFeature) {
        int n = this._formatWriteFeatures & ~formatFeature.getMask();
        int n2 = this._formatWriteFeaturesToChange | formatFeature.getMask();
        return this._formatWriteFeatures == n && this._formatWriteFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, n, n2);
    }

    public SerializationConfig withoutFeatures(FormatFeature ... formatFeatureArray) {
        int n = this._formatWriteFeatures;
        int n2 = this._formatWriteFeaturesToChange;
        for (FormatFeature formatFeature : formatFeatureArray) {
            int n3 = formatFeature.getMask();
            n &= ~n3;
            n2 |= n3;
        }
        return this._formatWriteFeatures == n && this._formatWriteFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, n, n2);
    }

    public SerializationConfig withFilters(FilterProvider filterProvider) {
        return filterProvider == this._filterProvider ? this : new SerializationConfig(this, filterProvider);
    }

    @Deprecated
    public SerializationConfig withSerializationInclusion(JsonInclude.Include include) {
        return this.withPropertyInclusion(DEFAULT_INCLUSION.withValueInclusion(include));
    }

    public SerializationConfig withPropertyInclusion(JsonInclude.Value value) {
        if (this._serializationInclusion.equals((Object)value)) {
            return this;
        }
        return new SerializationConfig(this, value);
    }

    public SerializationConfig withDefaultPrettyPrinter(PrettyPrinter prettyPrinter) {
        return this._defaultPrettyPrinter == prettyPrinter ? this : new SerializationConfig(this, prettyPrinter);
    }

    public PrettyPrinter constructDefaultPrettyPrinter() {
        PrettyPrinter prettyPrinter = this._defaultPrettyPrinter;
        if (prettyPrinter instanceof Instantiatable) {
            prettyPrinter = (PrettyPrinter)((Instantiatable)prettyPrinter).createInstance();
        }
        return prettyPrinter;
    }

    public void initialize(JsonGenerator jsonGenerator) {
        PrettyPrinter prettyPrinter;
        if (SerializationFeature.INDENT_OUTPUT.enabledIn(this._serFeatures) && jsonGenerator.getPrettyPrinter() == null && (prettyPrinter = this.constructDefaultPrettyPrinter()) != null) {
            jsonGenerator.setPrettyPrinter(prettyPrinter);
        }
        boolean bl = SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN.enabledIn(this._serFeatures);
        int n = this._generatorFeaturesToChange;
        if (n != 0 || bl) {
            int n2 = this._generatorFeatures;
            if (bl) {
                int n3 = JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN.getMask();
                n2 |= n3;
                n |= n3;
            }
            jsonGenerator.overrideStdFeatures(n2, n);
        }
        if (this._formatWriteFeaturesToChange != 0) {
            jsonGenerator.overrideFormatFeatures(this._formatWriteFeatures, this._formatWriteFeaturesToChange);
        }
    }

    @Override
    public AnnotationIntrospector getAnnotationIntrospector() {
        if (this.isEnabled(MapperFeature.USE_ANNOTATIONS)) {
            return super.getAnnotationIntrospector();
        }
        return AnnotationIntrospector.nopInstance();
    }

    @Override
    public BeanDescription introspectClassAnnotations(JavaType javaType) {
        return this.getClassIntrospector().forClassAnnotations(this, javaType, this);
    }

    @Override
    public BeanDescription introspectDirectClassAnnotations(JavaType javaType) {
        return this.getClassIntrospector().forDirectClassAnnotations(this, javaType, this);
    }

    @Deprecated
    public JsonInclude.Include getSerializationInclusion() {
        JsonInclude.Include include = this._serializationInclusion.getValueInclusion();
        return include == JsonInclude.Include.USE_DEFAULTS ? JsonInclude.Include.ALWAYS : include;
    }

    @Override
    public JsonInclude.Value getDefaultPropertyInclusion() {
        return this._serializationInclusion;
    }

    @Override
    public JsonInclude.Value getDefaultPropertyInclusion(Class<?> clazz) {
        JsonInclude.Value value;
        ConfigOverride configOverride = this.findConfigOverride(clazz);
        if (configOverride != null && (value = configOverride.getInclude()) != null) {
            return value;
        }
        return this._serializationInclusion;
    }

    @Override
    public JsonInclude.Value getDefaultPropertyInclusion(Class<?> clazz, JsonInclude.Value value) {
        JsonInclude.Value value2;
        ConfigOverride configOverride = this.findConfigOverride(clazz);
        if (configOverride != null && (value2 = configOverride.getInclude()) != null) {
            return value2;
        }
        return value;
    }

    @Override
    public boolean useRootWrapping() {
        if (this._rootName != null) {
            return !this._rootName.isEmpty();
        }
        return this.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
    }

    public final boolean isEnabled(SerializationFeature serializationFeature) {
        return (this._serFeatures & serializationFeature.getMask()) != 0;
    }

    public final boolean isEnabled(JsonGenerator.Feature feature, JsonFactory jsonFactory) {
        int n = feature.getMask();
        if ((this._generatorFeaturesToChange & n) != 0) {
            return (this._generatorFeatures & feature.getMask()) != 0;
        }
        return jsonFactory.isEnabled(feature);
    }

    public final boolean hasSerializationFeatures(int n) {
        return (this._serFeatures & n) == n;
    }

    public final int getSerializationFeatures() {
        return this._serFeatures;
    }

    public FilterProvider getFilterProvider() {
        return this._filterProvider;
    }

    public PrettyPrinter getDefaultPrettyPrinter() {
        return this._defaultPrettyPrinter;
    }

    public <T extends BeanDescription> T introspect(JavaType javaType) {
        return (T)this.getClassIntrospector().forSerialization(this, javaType, this);
    }

    public String toString() {
        return "[SerializationConfig: flags=0x" + Integer.toHexString(this._serFeatures) + "]";
    }
}

