/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.osgi.registry;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.osgi.registry.Activator;
import org.apache.geronimo.osgi.registry.api.ProviderRegistry;
import org.osgi.framework.Bundle;

public class ProviderRegistryImpl
implements ProviderRegistry {
    public static final String OPT_IN_HEADER = "SPI-Provider";
    public static final String EXPORT_PROVIDER_HEADER = "Export-SPI-Provider";
    private SPIRegistry providers = new SPIRegistry();
    private SPIRegistry serviceProviders = new SPIRegistry();
    private Activator activator;

    public ProviderRegistryImpl(Activator activator) {
        this.activator = activator;
    }

    public Object addBundle(Bundle bundle) {
        this.log(4, "adding bundle " + bundle);
        BundleResources bundleResources = new BundleResources(bundle);
        return bundleResources.needsTracking() ? bundleResources : null;
    }

    public void removeBundle(Bundle bundle, Object object) {
        this.log(4, "removing bundle " + bundle);
        BundleResources bundleResources = (BundleResources)object;
        if (bundleResources != null) {
            bundleResources.remove();
        }
    }

    protected void registerProvider(BundleProviderLoader bundleProviderLoader) {
        this.log(4, "registering provider " + bundleProviderLoader);
        this.providers.register(bundleProviderLoader);
    }

    protected void unregisterProvider(BundleProviderLoader bundleProviderLoader) {
        this.log(4, "unregistering provider " + bundleProviderLoader);
        this.providers.unregister(bundleProviderLoader);
    }

    protected void registerService(BundleProviderLoader bundleProviderLoader) {
        this.log(4, "registering service " + bundleProviderLoader);
        this.serviceProviders.register(bundleProviderLoader);
    }

    protected void unregisterService(BundleProviderLoader bundleProviderLoader) {
        this.log(4, "unregistering service " + bundleProviderLoader);
        this.serviceProviders.unregister(bundleProviderLoader);
    }

    @Override
    public Class<?> locate(String string) {
        BundleProviderLoader bundleProviderLoader = this.providers.getLoader(string);
        if (bundleProviderLoader != null) {
            try {
                return bundleProviderLoader.loadClass();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public List<Class<?>> locateAll(String string) {
        ArrayList arrayList = new ArrayList();
        List list = this.providers.getLoaders(string);
        if (list != null) {
            for (BundleProviderLoader bundleProviderLoader : list) {
                try {
                    arrayList.add(bundleProviderLoader.loadClass());
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }

    @Override
    public Object getService(String string) throws Exception {
        List list = this.serviceProviders.getLoaders(string);
        if (list == null || list.size() == 0) {
            return null;
        }
        String string2 = System.getProperty(string);
        if (string2 != null) {
            for (BundleProviderLoader bundleProviderLoader : list) {
                if (!bundleProviderLoader.providerClass.equals(string2)) continue;
                return bundleProviderLoader.createInstance();
            }
        }
        return ((BundleProviderLoader)list.get(0)).createInstance();
    }

    @Override
    public List<Object> getServices(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = this.serviceProviders.getLoaders(string);
        if (list != null) {
            for (BundleProviderLoader bundleProviderLoader : list) {
                try {
                    arrayList.add(bundleProviderLoader.createInstance());
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }

    @Override
    public List<Class<?>> getServiceClasses(String string) {
        ArrayList arrayList = new ArrayList();
        List list = this.serviceProviders.getLoaders(string);
        if (list != null) {
            for (BundleProviderLoader bundleProviderLoader : list) {
                try {
                    arrayList.add(bundleProviderLoader.loadClass());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    @Override
    public Class<?> getServiceClass(String string) throws ClassNotFoundException {
        List list = this.serviceProviders.getLoaders(string);
        if (list == null || list.size() == 0) {
            return null;
        }
        String string2 = System.getProperty(string);
        if (string2 != null) {
            for (BundleProviderLoader bundleProviderLoader : list) {
                if (!bundleProviderLoader.providerClass.equals(string2)) continue;
                return bundleProviderLoader.loadClass();
            }
        }
        return ((BundleProviderLoader)list.get(0)).loadClass();
    }

    private void log(int n, String string) {
        this.activator.log(n, string);
    }

    private void log(int n, String string, Throwable throwable) {
        this.activator.log(n, string, throwable);
    }

    private class BundleProviderLoader {
        private final String providerId;
        private final String providerClass;
        private final Bundle bundle;

        public BundleProviderLoader(String string, String string2, Bundle bundle) {
            this.providerId = string;
            this.providerClass = string2;
            this.bundle = bundle;
        }

        public Class<?> loadClass() throws ClassNotFoundException {
            try {
                ProviderRegistryImpl.this.log(4, "loading class for: " + this);
                return this.bundle.loadClass(this.providerClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ProviderRegistryImpl.this.log(4, "exception caught while loading " + this, classNotFoundException);
                throw classNotFoundException;
            }
        }

        public Object createInstance() throws Exception {
            Class<?> clazz = this.loadClass();
            try {
                return clazz.newInstance();
            }
            catch (Exception exception) {
                ProviderRegistryImpl.this.log(4, "exception caught while creating " + this, exception);
                throw exception;
            }
            catch (Error error) {
                ProviderRegistryImpl.this.log(4, "error caught while creating " + this, error);
                throw error;
            }
        }

        public String id() {
            return this.providerId;
        }

        public String toString() {
            return "Provider interface=" + this.providerId + " , provider class=" + this.providerClass + ", bundle=" + this.bundle;
        }

        public int hashCode() {
            return this.providerId.hashCode() + this.providerClass.hashCode() + (int)this.bundle.getBundleId();
        }

        public boolean equals(Object object) {
            if (object instanceof BundleProviderLoader) {
                return this.providerId.equals(((BundleProviderLoader)object).providerId) && this.providerClass.equals(((BundleProviderLoader)object).providerClass) && this.bundle.getBundleId() == ((BundleProviderLoader)object).bundle.getBundleId();
            }
            return false;
        }
    }

    private class SPIRegistry {
        private Map<String, List<BundleProviderLoader>> registry;

        private SPIRegistry() {
        }

        public synchronized void register(BundleProviderLoader bundleProviderLoader) {
            String string;
            List<BundleProviderLoader> list;
            if (this.registry == null) {
                this.registry = new HashMap<String, List<BundleProviderLoader>>();
            }
            if ((list = this.registry.get(string = bundleProviderLoader.id())) == null) {
                list = new ArrayList<BundleProviderLoader>();
                this.registry.put(string, list);
            }
            list.add(bundleProviderLoader);
        }

        public synchronized void unregister(BundleProviderLoader bundleProviderLoader) {
            List<BundleProviderLoader> list;
            if (this.registry != null && (list = this.registry.get(bundleProviderLoader.id())) != null) {
                list.remove(bundleProviderLoader);
            }
        }

        private synchronized BundleProviderLoader getLoader(String string) {
            List<BundleProviderLoader> list;
            if (this.registry != null && (list = this.registry.get(string)) != null && !list.isEmpty()) {
                return list.get(0);
            }
            return null;
        }

        private synchronized List<BundleProviderLoader> getLoaders(String string) {
            List<BundleProviderLoader> list;
            if (this.registry != null && (list = this.registry.get(string)) != null && !list.isEmpty()) {
                return new ArrayList<BundleProviderLoader>(list);
            }
            return null;
        }
    }

    private class BundleResources {
        private Bundle bundle;
        private List<BundleProviderLoader> serviceProviders;
        private List<BundleProviderLoader> providers;

        public BundleResources(Bundle bundle) {
            this.bundle = bundle;
            this.locateProviders();
            this.locateServices();
        }

        public boolean needsTracking() {
            return this.serviceProviders != null || this.providers != null;
        }

        private void locateProviders() {
            List<BundleProviderLoader> list;
            LinkedHashSet<BundleProviderLoader> linkedHashSet = new LinkedHashSet<BundleProviderLoader>();
            List<BundleProviderLoader> list2 = this.locateHeaderProviderDefinitions();
            if (list2 != null) {
                linkedHashSet.addAll(list2);
            }
            if ((list = this.processDefinitions("OSGI-INF/providers/")) != null) {
                linkedHashSet.addAll(list);
            }
            if (!linkedHashSet.isEmpty()) {
                for (BundleProviderLoader bundleProviderLoader : linkedHashSet) {
                    ProviderRegistryImpl.this.registerProvider(bundleProviderLoader);
                }
                this.providers = new ArrayList<BundleProviderLoader>(linkedHashSet);
            }
        }

        private List<BundleProviderLoader> locateHeaderProviderDefinitions() {
            String[] stringArray;
            String string = (String)this.bundle.getHeaders().get(ProviderRegistryImpl.EXPORT_PROVIDER_HEADER);
            if (string == null) {
                return null;
            }
            ArrayList<BundleProviderLoader> arrayList = new ArrayList<BundleProviderLoader>();
            for (String string2 : stringArray = string.split(",")) {
                string2 = string2.trim();
                arrayList.add(new BundleProviderLoader(string2, string2, this.bundle));
            }
            return arrayList;
        }

        private void locateServices() {
            if (this.bundle.getHeaders().get(ProviderRegistryImpl.OPT_IN_HEADER) == null) {
                return;
            }
            ProviderRegistryImpl.this.log(3, "SPI-Provider Manifest header found in bundle: " + this.bundle.getSymbolicName());
            this.serviceProviders = this.processDefinitions("META-INF/services/");
            if (this.serviceProviders != null) {
                for (BundleProviderLoader bundleProviderLoader : this.serviceProviders) {
                    ProviderRegistryImpl.this.registerService(bundleProviderLoader);
                }
            }
        }

        public void remove() {
            ProviderRegistryImpl.this.log(4, "removing bundle " + this.bundle);
            if (this.providers != null) {
                for (BundleProviderLoader bundleProviderLoader : this.providers) {
                    ProviderRegistryImpl.this.unregisterProvider(bundleProviderLoader);
                }
            }
            if (this.serviceProviders != null) {
                for (BundleProviderLoader bundleProviderLoader : this.serviceProviders) {
                    ProviderRegistryImpl.this.unregisterService(bundleProviderLoader);
                }
            }
        }

        private List<BundleProviderLoader> processDefinitions(String string) {
            ArrayList<BundleProviderLoader> arrayList = new ArrayList<BundleProviderLoader>();
            Enumeration enumeration = this.bundle.findEntries(string, "*", false);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    URL uRL = (URL)enumeration.nextElement();
                    this.parseServiceFile(uRL, arrayList);
                }
            }
            return arrayList.isEmpty() ? null : arrayList;
        }

        private void parseServiceFile(URL uRL, List<BundleProviderLoader> list) {
            String string = uRL.toString();
            if (string.endsWith("/")) {
                return;
            }
            String string2 = string.substring(string.lastIndexOf("/") + 1);
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), "UTF-8"));
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    int n = string3.indexOf(35);
                    if (n != -1) {
                        string3 = string3.substring(0, n);
                    }
                    if ((string3 = string3.trim()).length() > 0) {
                        list.add(new BundleProviderLoader(string2, string3, this.bundle));
                    }
                    string3 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

