/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.exec.util.DebugUtils;

public class StreamPumper
implements Runnable {
    private static final int DEFAULT_SIZE = 1024;
    private final InputStream is;
    private final OutputStream os;
    private final int size;
    private boolean finished;
    private final boolean closeWhenExhausted;

    public StreamPumper(InputStream inputStream, OutputStream outputStream, boolean bl) {
        this.is = inputStream;
        this.os = outputStream;
        this.size = 1024;
        this.closeWhenExhausted = bl;
    }

    public StreamPumper(InputStream inputStream, OutputStream outputStream, boolean bl, int n) {
        this.is = inputStream;
        this.os = outputStream;
        this.size = n > 0 ? n : 1024;
        this.closeWhenExhausted = bl;
    }

    public StreamPumper(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this;
        synchronized (object) {
            this.finished = false;
        }
        object = new byte[this.size];
        try {
            int n;
            while ((n = this.is.read((byte[])object)) > 0) {
                this.os.write((byte[])object, 0, n);
            }
        }
        catch (Exception exception) {
            if (this.closeWhenExhausted) {
                try {
                    this.os.close();
                }
                catch (IOException iOException) {
                    DebugUtils.handleException("Got exception while closing exhausted output stream", iOException);
                }
            }
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.finished = true;
                this.notifyAll();
            }
        }
        finally {
            if (this.closeWhenExhausted) {
                try {
                    this.os.close();
                }
                catch (IOException iOException) {
                    DebugUtils.handleException("Got exception while closing exhausted output stream", iOException);
                }
            }
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.finished = true;
                this.notifyAll();
            }
        }
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
    }
}

