/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.utilities;

public class Interval {
    private double inf;
    private double sup;

    public Interval() {
        this.inf = 0.0;
        this.sup = 0.0;
    }

    public Interval(double a, double b) {
        if (a <= b) {
            this.inf = a;
            this.sup = b;
        } else {
            this.inf = b;
            this.sup = a;
        }
    }

    public Interval(Interval i) {
        this.inf = i.inf;
        this.sup = i.sup;
    }

    public double getInf() {
        return this.inf;
    }

    public double getSup() {
        return this.sup;
    }

    public double getLength() {
        return this.sup - this.inf;
    }

    public boolean contains(double x) {
        return this.inf <= x && x <= this.sup;
    }

    public boolean contains(Interval i) {
        return this.inf <= i.inf && i.sup <= this.sup;
    }

    public boolean intersects(Interval i) {
        return this.inf <= i.sup && i.inf <= this.sup;
    }

    public void addToSelf(Interval i) {
        this.inf = Math.min(this.inf, i.inf);
        this.sup = Math.max(this.sup, i.sup);
    }

    public static Interval add(Interval i1, Interval i2) {
        Interval copy = new Interval(i1);
        copy.addToSelf(i2);
        return copy;
    }

    public void intersectSelf(Interval i) {
        this.inf = Math.max(this.inf, i.inf);
        this.sup = Math.max(Math.min(this.sup, i.sup), this.inf);
    }

    public static Interval intersection(Interval i1, Interval i2) {
        Interval copy = new Interval(i1);
        copy.intersectSelf(i2);
        return copy;
    }
}

