/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.random;

public class ScalarSampleStatistics {
    private int n = 0;
    private double min;
    private double max = this.min = Double.NaN;
    private double sum = 0.0;
    private double sum2 = 0.0;

    public void add(double x) {
        if (this.n++ == 0) {
            this.min = x;
            this.max = x;
            this.sum = x;
            this.sum2 = x * x;
        } else {
            if (x < this.min) {
                this.min = x;
            } else if (x > this.max) {
                this.max = x;
            }
            this.sum += x;
            this.sum2 += x * x;
        }
    }

    public void add(double[] points) {
        for (int i = 0; i < points.length; ++i) {
            this.add(points[i]);
        }
    }

    public void add(ScalarSampleStatistics s) {
        if (s.n == 0) {
            return;
        }
        if (this.n == 0) {
            this.n = s.n;
            this.min = s.min;
            this.max = s.max;
            this.sum = s.sum;
            this.sum2 = s.sum2;
        } else {
            this.n += s.n;
            if (s.min < this.min) {
                this.min = s.min;
            } else if (s.max > this.max) {
                this.max = s.max;
            }
            this.sum += s.sum;
            this.sum2 += s.sum2;
        }
    }

    public int size() {
        return this.n;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.n == 0 ? 0.0 : this.sum / (double)this.n;
    }

    public double getStandardDeviation() {
        if (this.n < 2) {
            return 0.0;
        }
        return Math.sqrt(((double)this.n * this.sum2 - this.sum * this.sum) / (double)(this.n * (this.n - 1)));
    }
}

