/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.random;

import java.io.Serializable;
import org.spaceroots.mantissa.MantissaException;
import org.spaceroots.mantissa.linalg.GeneralMatrix;
import org.spaceroots.mantissa.linalg.Matrix;
import org.spaceroots.mantissa.linalg.SymetricalMatrix;
import org.spaceroots.mantissa.random.NormalizedRandomGenerator;
import org.spaceroots.mantissa.random.NotPositiveDefiniteMatrixException;
import org.spaceroots.mantissa.random.RandomVectorGenerator;

public class CorrelatedRandomVectorGenerator
implements Serializable,
RandomVectorGenerator {
    private double[] mean;
    private Matrix root;
    private int rank;
    NormalizedRandomGenerator generator;
    private double[] normalized;
    private static final long serialVersionUID = -88563624902398453L;

    public CorrelatedRandomVectorGenerator(double[] mean, SymetricalMatrix covariance, NormalizedRandomGenerator generator) throws NotPositiveDefiniteMatrixException {
        int order = covariance.getRows();
        if (mean.length != order) {
            String message = MantissaException.translate("dimension mismatch {0} != {1}", new String[]{Integer.toString(mean.length), Integer.toString(order)});
            throw new IllegalArgumentException(message);
        }
        this.mean = (double[])mean.clone();
        this.factorize(covariance);
        this.generator = generator;
        this.normalized = new double[this.rank];
    }

    public CorrelatedRandomVectorGenerator(SymetricalMatrix covariance, NormalizedRandomGenerator generator) throws NotPositiveDefiniteMatrixException {
        int order = covariance.getRows();
        this.mean = new double[order];
        for (int i = 0; i < order; ++i) {
            this.mean[i] = 0.0;
        }
        this.factorize(covariance);
        this.generator = generator;
        this.normalized = new double[this.rank];
    }

    public Matrix getRootMatrix() {
        return this.root;
    }

    public NormalizedRandomGenerator getGenerator() {
        return this.generator;
    }

    public int getRank() {
        return this.rank;
    }

    private void factorize(SymetricalMatrix covariance) throws NotPositiveDefiniteMatrixException {
        int i;
        int order = covariance.getRows();
        SymetricalMatrix c = (SymetricalMatrix)covariance.duplicate();
        GeneralMatrix b = new GeneralMatrix(order, order);
        int[] swap = new int[order];
        int[] index = new int[order];
        for (i = 0; i < order; ++i) {
            index[i] = i;
        }
        this.rank = 0;
        boolean loop = true;
        while (loop) {
            int i2;
            swap[this.rank] = this.rank;
            for (i2 = this.rank + 1; i2 < order; ++i2) {
                if (!(c.getElement(index[i2], index[i2]) > c.getElement(index[swap[i2]], index[swap[i2]]))) continue;
                swap[this.rank] = i2;
            }
            if (swap[this.rank] != this.rank) {
                int tmp = index[this.rank];
                index[this.rank] = index[swap[this.rank]];
                index[swap[this.rank]] = tmp;
            }
            if (c.getElement(index[this.rank], index[this.rank]) < 1.0E-12) {
                if (this.rank == 0) {
                    throw new NotPositiveDefiniteMatrixException();
                }
                for (i2 = this.rank; i2 < order; ++i2) {
                    if (!(c.getElement(index[this.rank], index[this.rank]) < -1.0E-12)) continue;
                    throw new NotPositiveDefiniteMatrixException();
                }
                ++this.rank;
                loop = false;
                continue;
            }
            double sqrt = Math.sqrt(c.getElement(index[this.rank], index[this.rank]));
            b.setElement(this.rank, this.rank, sqrt);
            double inverse = 1.0 / sqrt;
            for (int i3 = this.rank + 1; i3 < order; ++i3) {
                double e = inverse * c.getElement(index[i3], index[this.rank]);
                b.setElement(i3, this.rank, e);
                c.setElement(index[i3], index[i3], c.getElement(index[i3], index[i3]) - e * e);
                for (int j = this.rank + 1; j < i3; ++j) {
                    double f = b.getElement(j, this.rank);
                    c.setElementAndSymetricalElement(index[i3], index[j], c.getElement(index[i3], index[j]) - e * f);
                }
            }
            loop = ++this.rank < order;
        }
        this.root = new GeneralMatrix(order, this.rank);
        for (i = 0; i < order; ++i) {
            for (int j = 0; j < this.rank; ++j) {
                this.root.setElement(swap[i], j, b.getElement(i, j));
            }
        }
    }

    @Override
    public double[] nextVector() {
        for (int i = 0; i < this.rank; ++i) {
            this.normalized[i] = this.generator.nextDouble();
        }
        double[] correlated = new double[this.mean.length];
        for (int i = 0; i < correlated.length; ++i) {
            correlated[i] = this.mean[i];
            for (int j = 0; j < this.rank; ++j) {
                int n = i;
                correlated[n] = correlated[n] + this.root.getElement(i, j) * this.normalized[j];
            }
        }
        return correlated;
    }
}

