/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.ode;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.spaceroots.mantissa.ode.DerivativeException;
import org.spaceroots.mantissa.ode.FirstOrderDifferentialEquations;
import org.spaceroots.mantissa.ode.RungeKuttaStepInterpolator;

class DormandPrince853StepInterpolator
extends RungeKuttaStepInterpolator {
    private double[][] yDotKLast;
    private double[] yTmp;
    private double[][] v;
    private boolean vectorsInitialized;
    private static double b_01 = 0.054293734116568765;
    private static double b_06 = 4.450312892752409;
    private static double b_07 = 1.8915178993145003;
    private static double b_08 = -5.801203960010585;
    private static double b_09 = 0.3111643669578199;
    private static double b_10 = -0.1521609496625161;
    private static double b_11 = 0.20136540080403034;
    private static double b_12 = 0.04471061572777259;
    private static double c14 = 0.1;
    private static double k14_01 = 0.056167502283047954 - b_01;
    private static double k14_06 = 0.0 - b_06;
    private static double k14_07 = 0.25350021021662483 - b_07;
    private static double k14_08 = -0.2462390374708025 - b_08;
    private static double k14_09 = -0.12419142326381637 - b_09;
    private static double k14_10 = 0.15329179827876568 - b_10;
    private static double k14_11 = 0.00820105229563469 - b_11;
    private static double k14_12 = 0.007567897660545699 - b_12;
    private static double k14_13 = -0.008298;
    private static double c15 = 0.2;
    private static double k15_01 = 0.03183464816350214 - b_01;
    private static double k15_06 = 0.028300909672366776 - b_06;
    private static double k15_07 = 0.053541988307438566 - b_07;
    private static double k15_08 = -0.05492374857139099 - b_08;
    private static double k15_09 = 0.0 - b_09;
    private static double k15_10 = 0.0 - b_10;
    private static double k15_11 = -1.0834732869724932E-4 - b_11;
    private static double k15_12 = 3.825710908356584E-4 - b_12;
    private static double k15_13 = -3.4046500868740456E-4;
    private static double k15_14 = 0.1413124436746325;
    private static double c16 = 0.7777777777777778;
    private static double k16_01 = -0.42889630158379194 - b_01;
    private static double k16_06 = -4.697621415361164 - b_06;
    private static double k16_07 = 7.683421196062599 - b_07;
    private static double k16_08 = 4.06898981839711 - b_08;
    private static double k16_09 = 0.3567271874552811 - b_09;
    private static double k16_10 = 0.0 - b_10;
    private static double k16_11 = 0.0 - b_11;
    private static double k16_12 = 0.0 - b_12;
    private static double k16_13 = -0.0013990241651590145;
    private static double k16_14 = 2.9475147891527724;
    private static double k16_15 = -9.15095847217987;
    private static double[][] d = new double[][]{{-8.428938276109013, 0.5667149535193777, -3.0689499459498917, 2.38466765651207, 2.1170345824450285, -0.871391583777973, 2.2404374302607883, 0.6315787787694688, -0.08899033645133331, 18.148505520854727, -9.194632392478356, -4.436036387594894}, {10.427508642579134, 242.28349177525817, 165.20045171727028, -374.5467547226902, -22.113666853125302, 7.733432668472264, -30.674084731089398, -9.332130526430229, 15.697238121770845, -31.139403219565178, -9.35292435884448, 35.81684148639408}, {19.985053242002433, -387.0373087493518, -189.17813819516758, 527.8081592054236, -11.573902539959631, 6.8812326946963, -1.0006050966910838, 0.7777137798053443, -2.778205752353508, -60.19669523126412, 84.32040550667716, 11.99229113618279}, {-25.69393346270375, -154.18974869023643, -231.5293791760455, 357.6391179106141, 93.4053241836243, -37.45832313645163, 104.0996495089623, 29.8402934266605, -43.53345659001114, 96.32455395918828, -39.17726167561544, -149.72683625798564}};
    private static final long serialVersionUID = 4165537490327432186L;

    public DormandPrince853StepInterpolator() {
        this.yDotKLast = null;
        this.yTmp = null;
        this.v = null;
        this.vectorsInitialized = false;
    }

    public DormandPrince853StepInterpolator(DormandPrince853StepInterpolator interpolator) {
        super(interpolator);
        if (interpolator.currentState == null) {
            this.yDotKLast = null;
            this.v = null;
            this.vectorsInitialized = false;
        } else {
            int k;
            int dimension = interpolator.currentState.length;
            this.yDotKLast = new double[3][];
            for (k = 0; k < this.yDotKLast.length; ++k) {
                this.yDotKLast[k] = new double[dimension];
                System.arraycopy(interpolator.yDotKLast[k], 0, this.yDotKLast[k], 0, dimension);
            }
            this.v = new double[7][];
            for (k = 0; k < this.v.length; ++k) {
                this.v[k] = new double[dimension];
                System.arraycopy(interpolator.v[k], 0, this.v[k], 0, dimension);
            }
            this.vectorsInitialized = interpolator.vectorsInitialized;
        }
        this.yTmp = null;
    }

    @Override
    public Object clone() {
        return new DormandPrince853StepInterpolator(this);
    }

    @Override
    public void reinitialize(FirstOrderDifferentialEquations equations, double[] y, double[][] yDotK, boolean forward) {
        int k;
        super.reinitialize(equations, y, yDotK, forward);
        int dimension = this.currentState.length;
        this.yDotKLast = new double[3][];
        for (k = 0; k < this.yDotKLast.length; ++k) {
            this.yDotKLast[k] = new double[dimension];
        }
        this.yTmp = new double[dimension];
        this.v = new double[7][];
        for (k = 0; k < this.v.length; ++k) {
            this.v[k] = new double[dimension];
        }
        this.vectorsInitialized = false;
    }

    @Override
    public void storeTime(double t) {
        super.storeTime(t);
        this.vectorsInitialized = false;
    }

    @Override
    protected void computeInterpolatedState(double theta, double oneMinusThetaH) throws DerivativeException {
        if (!this.vectorsInitialized) {
            if (this.v == null) {
                this.v = new double[7][];
                for (int k = 0; k < 7; ++k) {
                    this.v[k] = new double[this.interpolatedState.length];
                }
            }
            this.finalizeStep();
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                this.v[0][i] = this.h * (b_01 * this.yDotK[0][i] + b_06 * this.yDotK[5][i] + b_07 * this.yDotK[6][i] + b_08 * this.yDotK[7][i] + b_09 * this.yDotK[8][i] + b_10 * this.yDotK[9][i] + b_11 * this.yDotK[10][i] + b_12 * this.yDotK[11][i]);
                this.v[1][i] = this.h * this.yDotK[0][i] - this.v[0][i];
                this.v[2][i] = this.v[0][i] - this.v[1][i] - this.h * this.yDotK[12][i];
                for (int k = 0; k < d.length; ++k) {
                    this.v[k + 3][i] = this.h * (d[k][0] * this.yDotK[0][i] + d[k][1] * this.yDotK[5][i] + d[k][2] * this.yDotK[6][i] + d[k][3] * this.yDotK[7][i] + d[k][4] * this.yDotK[8][i] + d[k][5] * this.yDotK[9][i] + d[k][6] * this.yDotK[10][i] + d[k][7] * this.yDotK[11][i] + d[k][8] * this.yDotK[12][i] + d[k][9] * this.yDotKLast[0][i] + d[k][10] * this.yDotKLast[1][i] + d[k][11] * this.yDotKLast[2][i]);
                }
            }
            this.vectorsInitialized = true;
        }
        double eta = oneMinusThetaH / this.h;
        for (int i = 0; i < this.interpolatedState.length; ++i) {
            this.interpolatedState[i] = this.currentState[i] - eta * (this.v[0][i] - theta * (this.v[1][i] + theta * (this.v[2][i] + eta * (this.v[3][i] + theta * (this.v[4][i] + eta * (this.v[5][i] + theta * this.v[6][i]))))));
        }
    }

    @Override
    protected void doFinalize() throws DerivativeException {
        double s;
        int j;
        for (j = 0; j < this.currentState.length; ++j) {
            s = k14_01 * this.yDotK[0][j] + k14_06 * this.yDotK[5][j] + k14_07 * this.yDotK[6][j] + k14_08 * this.yDotK[7][j] + k14_09 * this.yDotK[8][j] + k14_10 * this.yDotK[9][j] + k14_11 * this.yDotK[10][j] + k14_12 * this.yDotK[11][j] + k14_13 * this.yDotK[12][j];
            this.yTmp[j] = this.currentState[j] + this.h * s;
        }
        this.equations.computeDerivatives(this.previousTime + c14 * this.h, this.yTmp, this.yDotKLast[0]);
        for (j = 0; j < this.currentState.length; ++j) {
            s = k15_01 * this.yDotK[0][j] + k15_06 * this.yDotK[5][j] + k15_07 * this.yDotK[6][j] + k15_08 * this.yDotK[7][j] + k15_09 * this.yDotK[8][j] + k15_10 * this.yDotK[9][j] + k15_11 * this.yDotK[10][j] + k15_12 * this.yDotK[11][j] + k15_13 * this.yDotK[12][j] + k15_14 * this.yDotKLast[0][j];
            this.yTmp[j] = this.currentState[j] + this.h * s;
        }
        this.equations.computeDerivatives(this.previousTime + c15 * this.h, this.yTmp, this.yDotKLast[1]);
        for (j = 0; j < this.currentState.length; ++j) {
            s = k16_01 * this.yDotK[0][j] + k16_06 * this.yDotK[5][j] + k16_07 * this.yDotK[6][j] + k16_08 * this.yDotK[7][j] + k16_09 * this.yDotK[8][j] + k16_10 * this.yDotK[9][j] + k16_11 * this.yDotK[10][j] + k16_12 * this.yDotK[11][j] + k16_13 * this.yDotK[12][j] + k16_14 * this.yDotKLast[0][j] + k16_15 * this.yDotKLast[1][j];
            this.yTmp[j] = this.currentState[j] + this.h * s;
        }
        this.equations.computeDerivatives(this.previousTime + c16 * this.h, this.yTmp, this.yDotKLast[2]);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            this.finalizeStep();
        }
        catch (DerivativeException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        out.writeInt(this.currentState.length);
        for (int i = 0; i < this.currentState.length; ++i) {
            out.writeDouble(this.yDotKLast[0][i]);
            out.writeDouble(this.yDotKLast[1][i]);
            out.writeDouble(this.yDotKLast[2][i]);
        }
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.yDotKLast = new double[3][];
        int dimension = in.readInt();
        this.yDotKLast[0] = new double[dimension];
        this.yDotKLast[1] = new double[dimension];
        this.yDotKLast[2] = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            this.yDotKLast[0][i] = in.readDouble();
            this.yDotKLast[1][i] = in.readDouble();
            this.yDotKLast[2][i] = in.readDouble();
        }
        super.readExternal(in);
    }
}

