/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.algebra;

import java.io.Serializable;
import java.math.BigInteger;

public class RationalNumber
implements Serializable {
    public static final RationalNumber ZERO = new RationalNumber(0L);
    public static final RationalNumber ONE = new RationalNumber(1L);
    private BigInteger p;
    private BigInteger q;
    private static final long serialVersionUID = -324954393137577531L;

    public RationalNumber() {
        this.p = BigInteger.ZERO;
        this.q = BigInteger.ONE;
    }

    public RationalNumber(long numerator, long denominator) {
        if (denominator == 0L) {
            throw new ArithmeticException("divide by zero");
        }
        this.p = BigInteger.valueOf(numerator);
        this.q = BigInteger.valueOf(denominator);
        if (this.q.signum() < 0) {
            this.p = this.p.negate();
            this.q = this.q.negate();
        }
        this.simplify();
    }

    public RationalNumber(BigInteger numerator, BigInteger denominator) {
        if (denominator.signum() == 0) {
            throw new ArithmeticException("divide by zero");
        }
        this.p = numerator;
        this.q = denominator;
        if (this.q.signum() < 0) {
            this.p = this.p.negate();
            this.q = this.q.negate();
        }
        this.simplify();
    }

    public RationalNumber(long l) {
        this.p = BigInteger.valueOf(l);
        this.q = BigInteger.ONE;
    }

    public RationalNumber(BigInteger i) {
        this.p = i;
        this.q = BigInteger.ONE;
    }

    public RationalNumber negate() {
        return new RationalNumber(this.p.negate(), this.q);
    }

    public RationalNumber add(long l) {
        return this.add(BigInteger.valueOf(l));
    }

    public RationalNumber add(BigInteger l) {
        return new RationalNumber(this.p.add(this.q.multiply(l)), this.q);
    }

    public RationalNumber add(RationalNumber r) {
        return new RationalNumber(this.p.multiply(r.q).add(r.p.multiply(this.q)), this.q.multiply(r.q));
    }

    public RationalNumber subtract(long l) {
        return this.subtract(BigInteger.valueOf(l));
    }

    public RationalNumber subtract(BigInteger l) {
        return new RationalNumber(this.p.subtract(this.q.multiply(l)), this.q);
    }

    public RationalNumber subtract(RationalNumber r) {
        return new RationalNumber(this.p.multiply(r.q).subtract(r.p.multiply(this.q)), this.q.multiply(r.q));
    }

    public RationalNumber multiply(long l) {
        return this.multiply(BigInteger.valueOf(l));
    }

    public RationalNumber multiply(BigInteger l) {
        return new RationalNumber(this.p.multiply(l), this.q);
    }

    public RationalNumber multiply(RationalNumber r) {
        return new RationalNumber(this.p.multiply(r.p), this.q.multiply(r.q));
    }

    public RationalNumber divide(long l) {
        return this.divide(BigInteger.valueOf(l));
    }

    public RationalNumber divide(BigInteger l) {
        if (l.signum() == 0) {
            throw new ArithmeticException("divide by zero");
        }
        if (l.signum() > 0) {
            return new RationalNumber(this.p, this.q.multiply(l));
        }
        return new RationalNumber(this.p.negate(), this.q.multiply(l.negate()));
    }

    public RationalNumber divide(RationalNumber r) {
        if (r.p.signum() == 0) {
            throw new ArithmeticException("divide by zero");
        }
        BigInteger newP = this.p.multiply(r.q);
        BigInteger newQ = this.q.multiply(r.p);
        return newQ.signum() < 0 ? new RationalNumber(newP.negate(), newQ.negate()) : new RationalNumber(newP, newQ);
    }

    public RationalNumber invert() {
        if (this.p.signum() == 0) {
            throw new ArithmeticException("divide by zero");
        }
        return this.q.signum() < 0 ? new RationalNumber(this.q.negate(), this.p.negate()) : new RationalNumber(this.q, this.p);
    }

    private void simplify() {
        if (this.p.signum() == 0) {
            this.q = BigInteger.ONE;
        } else {
            BigInteger gcd = this.p.gcd(this.q);
            this.p = this.p.divide(gcd);
            this.q = this.q.divide(gcd);
        }
    }

    public BigInteger getNumerator() {
        return this.p;
    }

    public BigInteger getDenominator() {
        return this.q;
    }

    public boolean isZero() {
        return this.p.signum() == 0;
    }

    public boolean isOne() {
        return this.p.compareTo(BigInteger.ONE) == 0 && this.q.compareTo(BigInteger.ONE) == 0;
    }

    public boolean isInteger() {
        return this.q.compareTo(BigInteger.ONE) == 0;
    }

    public boolean isNegative() {
        return this.p.signum() < 0;
    }

    public static RationalNumber abs(RationalNumber r) {
        return new RationalNumber(r.p.abs(), r.q);
    }

    public double doubleValue() {
        BigInteger[] result = this.p.divideAndRemainder(this.q);
        return result[0].doubleValue() + result[1].doubleValue() / this.q.doubleValue();
    }

    public boolean equals(Object o) {
        if (o instanceof RationalNumber) {
            RationalNumber r = (RationalNumber)o;
            return this.p.compareTo(r.p) == 0 && this.q.compareTo(r.q) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.p.hashCode() ^ this.q.hashCode();
    }

    public String toString() {
        return this.p + (this.q.compareTo(BigInteger.ONE) == 0 ? "" : "/" + this.q);
    }
}

