/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import SevenZip.Compression.LZMA.Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ArrayBlockingQueue;
import net.contrapunctus.lzma.ConcurrentBufferOutputStream;
import net.contrapunctus.lzma.LzmaOutputStream;

class DecoderThread
extends Thread {
    protected ArrayBlockingQueue<byte[]> q = ConcurrentBufferOutputStream.newQueue();
    protected InputStream in;
    protected OutputStream out;
    protected Decoder dec;
    protected IOException exn;
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;
    static final int propSize = 5;
    static final byte[] props;

    DecoderThread(InputStream inputStream) {
        this.in = inputStream;
        this.out = ConcurrentBufferOutputStream.create(this.q);
        this.dec = new Decoder();
        this.exn = null;
        if (DEBUG) {
            dbg.printf("%s >> %s (%s)%n", this, this.out, this.q);
        }
    }

    @Override
    public void run() {
        block9: {
            try {
                long l = 0L;
                if (LzmaOutputStream.LZMA_HEADER) {
                    int n = this.in.read(props, 0, 5);
                    if (n != 5) {
                        throw new IOException("input .lzma file is too short");
                    }
                    this.dec.SetDecoderProperties(props);
                    for (int i = 0; i < 8; ++i) {
                        int n2 = this.in.read();
                        if (n2 < 0) {
                            throw new IOException("Can't read stream size");
                        }
                        l |= (long)n2 << 8 * i;
                    }
                } else {
                    l = -1L;
                    this.dec.SetDecoderProperties(props);
                }
                if (DEBUG) {
                    dbg.printf("%s begins%n", this);
                }
                this.dec.Code(this.in, this.out, l);
                if (DEBUG) {
                    dbg.printf("%s ends%n", this);
                }
                this.in.close();
                this.out.close();
            }
            catch (IOException iOException) {
                this.exn = iOException;
                if (!DEBUG) break block9;
                dbg.printf("%s exception: %s%n", this.exn.getMessage());
            }
        }
    }

    @Override
    public String toString() {
        return String.format("Dec@%x", this.hashCode());
    }

    static {
        String string = null;
        try {
            string = System.getProperty("DEBUG_LzmaCoders");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = string != null;
        props = new byte[5];
        DecoderThread.props[0] = 93;
        DecoderThread.props[1] = 0;
        DecoderThread.props[2] = 0;
        DecoderThread.props[3] = 16;
        DecoderThread.props[4] = 0;
    }
}

