/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.fec;

import com.onionnetworks.util.Util;

public class FECMath {
    public int gfBits;
    public int gfSize;
    public static final String[] prim_polys = new String[]{null, null, "111", "1101", "11001", "101001", "1100001", "10010001", "101110001", "1000100001", "10010000001", "101000000001", "1100101000001", "11011000000001", "110000100010001", "1100000000000001", "11010000000010001"};
    public char[] gf_exp;
    public int[] gf_log;
    public char[] inverse;
    public char[][] gf_mul_table;

    public FECMath() {
        this(8);
    }

    public FECMath(int n) {
        this.gfBits = n;
        this.gfSize = (1 << n) - 1;
        this.gf_exp = new char[2 * this.gfSize];
        this.gf_log = new int[this.gfSize + 1];
        this.inverse = new char[this.gfSize + 1];
        if (n < 2 || n > 16) {
            throw new IllegalArgumentException("gfBits must be 2 .. 16");
        }
        this.generateGF();
        if (n <= 8) {
            this.initMulTable();
        }
    }

    public final void generateGF() {
        String string = prim_polys[this.gfBits];
        char c = '\u0001';
        this.gf_exp[this.gfBits] = '\u0000';
        int n = 0;
        while (n < this.gfBits) {
            this.gf_exp[n] = c;
            this.gf_log[this.gf_exp[n]] = n;
            if (string.charAt(n) == '1') {
                int n2 = this.gfBits;
                this.gf_exp[n2] = (char)(this.gf_exp[n2] ^ c);
            }
            ++n;
            c = (char)(c << 1);
        }
        this.gf_log[this.gf_exp[this.gfBits]] = this.gfBits;
        c = (char)(1 << this.gfBits - 1);
        for (n = this.gfBits + 1; n < this.gfSize; ++n) {
            this.gf_exp[n] = this.gf_exp[n - 1] >= c ? (char)(this.gf_exp[this.gfBits] ^ (this.gf_exp[n - 1] ^ c) << 1) : (char)(this.gf_exp[n - 1] << 1);
            this.gf_log[this.gf_exp[n]] = n;
        }
        this.gf_log[0] = this.gfSize;
        for (n = 0; n < this.gfSize; ++n) {
            this.gf_exp[n + this.gfSize] = this.gf_exp[n];
        }
        this.inverse[0] = '\u0000';
        this.inverse[1] = '\u0001';
        for (n = 2; n <= this.gfSize; ++n) {
            this.inverse[n] = this.gf_exp[this.gfSize - this.gf_log[n]];
        }
    }

    public final void initMulTable() {
        if (this.gfBits <= 8) {
            int n;
            this.gf_mul_table = new char[this.gfSize + 1][this.gfSize + 1];
            for (int i = 0; i < this.gfSize + 1; ++i) {
                for (n = 0; n < this.gfSize + 1; ++n) {
                    this.gf_mul_table[i][n] = this.gf_exp[this.modnn(this.gf_log[i] + this.gf_log[n])];
                }
            }
            for (n = 0; n < this.gfSize + 1; ++n) {
                this.gf_mul_table[n][0] = '\u0000';
                this.gf_mul_table[0][n] = '\u0000';
            }
        }
    }

    public final char modnn(int n) {
        while (n >= this.gfSize) {
            n -= this.gfSize;
            n = (n >> this.gfBits) + (n & this.gfSize);
        }
        return (char)n;
    }

    public final char mul(char c, char c2) {
        if (this.gfBits <= 8) {
            return this.gf_mul_table[c][c2];
        }
        if (c == '\u0000' || c2 == '\u0000') {
            return '\u0000';
        }
        return this.gf_exp[this.gf_log[c] + this.gf_log[c2]];
    }

    public static final char[] createGFMatrix(int n, int n2) {
        return new char[n * n2];
    }

    public final void addMul(char[] cArray, int n, char[] cArray2, int n2, char c, int n3) {
        if (c == '\u0000') {
            return;
        }
        int n4 = 16;
        int n5 = n;
        int n6 = n2;
        int n7 = n + n3;
        if (this.gfBits <= 8) {
            char[] cArray3 = this.gf_mul_table[c];
            while (n5 < n7 && n7 - n5 > n4) {
                int n8 = n5;
                cArray[n8] = (char)(cArray[n8] ^ cArray3[cArray2[n6]]);
                int n9 = n5 + 1;
                cArray[n9] = (char)(cArray[n9] ^ cArray3[cArray2[n6 + 1]]);
                int n10 = n5 + 2;
                cArray[n10] = (char)(cArray[n10] ^ cArray3[cArray2[n6 + 2]]);
                int n11 = n5 + 3;
                cArray[n11] = (char)(cArray[n11] ^ cArray3[cArray2[n6 + 3]]);
                int n12 = n5 + 4;
                cArray[n12] = (char)(cArray[n12] ^ cArray3[cArray2[n6 + 4]]);
                int n13 = n5 + 5;
                cArray[n13] = (char)(cArray[n13] ^ cArray3[cArray2[n6 + 5]]);
                int n14 = n5 + 6;
                cArray[n14] = (char)(cArray[n14] ^ cArray3[cArray2[n6 + 6]]);
                int n15 = n5 + 7;
                cArray[n15] = (char)(cArray[n15] ^ cArray3[cArray2[n6 + 7]]);
                int n16 = n5 + 8;
                cArray[n16] = (char)(cArray[n16] ^ cArray3[cArray2[n6 + 8]]);
                int n17 = n5 + 9;
                cArray[n17] = (char)(cArray[n17] ^ cArray3[cArray2[n6 + 9]]);
                int n18 = n5 + 10;
                cArray[n18] = (char)(cArray[n18] ^ cArray3[cArray2[n6 + 10]]);
                int n19 = n5 + 11;
                cArray[n19] = (char)(cArray[n19] ^ cArray3[cArray2[n6 + 11]]);
                int n20 = n5 + 12;
                cArray[n20] = (char)(cArray[n20] ^ cArray3[cArray2[n6 + 12]]);
                int n21 = n5 + 13;
                cArray[n21] = (char)(cArray[n21] ^ cArray3[cArray2[n6 + 13]]);
                int n22 = n5 + 14;
                cArray[n22] = (char)(cArray[n22] ^ cArray3[cArray2[n6 + 14]]);
                int n23 = n5 + 15;
                cArray[n23] = (char)(cArray[n23] ^ cArray3[cArray2[n6 + 15]]);
                n5 += n4;
                n6 += n4;
            }
            while (n5 < n7) {
                int n24 = n5++;
                cArray[n24] = (char)(cArray[n24] ^ cArray3[cArray2[n6]]);
                ++n6;
            }
        } else {
            int n25 = this.gf_log[c];
            while (n5 < n7) {
                char c2 = cArray2[n6];
                if (c2 != '\u0000') {
                    int n26 = n5;
                    cArray[n26] = (char)(cArray[n26] ^ this.gf_exp[n25 + this.gf_log[c2]]);
                }
                ++n5;
                ++n6;
            }
        }
    }

    public final void addMul(byte[] byArray, int n, byte[] byArray2, int n2, byte by, int n3) {
        if (by == 0) {
            return;
        }
        int n4 = 16;
        int n5 = n;
        int n6 = n2;
        int n7 = n + n3;
        char[] cArray = this.gf_mul_table[by & 0xFF];
        while (n5 < n7 && n7 - n5 > n4) {
            int n8 = n5;
            byArray[n8] = (byte)(byArray[n8] ^ cArray[byArray2[n6] & 0xFF]);
            int n9 = n5 + 1;
            byArray[n9] = (byte)(byArray[n9] ^ cArray[byArray2[n6 + 1] & 0xFF]);
            int n10 = n5 + 2;
            byArray[n10] = (byte)(byArray[n10] ^ cArray[byArray2[n6 + 2] & 0xFF]);
            int n11 = n5 + 3;
            byArray[n11] = (byte)(byArray[n11] ^ cArray[byArray2[n6 + 3] & 0xFF]);
            int n12 = n5 + 4;
            byArray[n12] = (byte)(byArray[n12] ^ cArray[byArray2[n6 + 4] & 0xFF]);
            int n13 = n5 + 5;
            byArray[n13] = (byte)(byArray[n13] ^ cArray[byArray2[n6 + 5] & 0xFF]);
            int n14 = n5 + 6;
            byArray[n14] = (byte)(byArray[n14] ^ cArray[byArray2[n6 + 6] & 0xFF]);
            int n15 = n5 + 7;
            byArray[n15] = (byte)(byArray[n15] ^ cArray[byArray2[n6 + 7] & 0xFF]);
            int n16 = n5 + 8;
            byArray[n16] = (byte)(byArray[n16] ^ cArray[byArray2[n6 + 8] & 0xFF]);
            int n17 = n5 + 9;
            byArray[n17] = (byte)(byArray[n17] ^ cArray[byArray2[n6 + 9] & 0xFF]);
            int n18 = n5 + 10;
            byArray[n18] = (byte)(byArray[n18] ^ cArray[byArray2[n6 + 10] & 0xFF]);
            int n19 = n5 + 11;
            byArray[n19] = (byte)(byArray[n19] ^ cArray[byArray2[n6 + 11] & 0xFF]);
            int n20 = n5 + 12;
            byArray[n20] = (byte)(byArray[n20] ^ cArray[byArray2[n6 + 12] & 0xFF]);
            int n21 = n5 + 13;
            byArray[n21] = (byte)(byArray[n21] ^ cArray[byArray2[n6 + 13] & 0xFF]);
            int n22 = n5 + 14;
            byArray[n22] = (byte)(byArray[n22] ^ cArray[byArray2[n6 + 14] & 0xFF]);
            int n23 = n5 + 15;
            byArray[n23] = (byte)(byArray[n23] ^ cArray[byArray2[n6 + 15] & 0xFF]);
            n5 += n4;
            n6 += n4;
        }
        while (n5 < n7) {
            int n24 = n5++;
            byArray[n24] = (byte)(byArray[n24] ^ cArray[byArray2[n6] & 0xFF]);
            ++n6;
        }
    }

    public final void matMul(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, int n3) {
        this.matMul(cArray, 0, cArray2, 0, cArray3, 0, n, n2, n3);
    }

    public final void matMul(char[] cArray, int n, char[] cArray2, int n2, char[] cArray3, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n6; ++j) {
                int n7 = i * n5;
                int n8 = j;
                char c = '\u0000';
                int n9 = 0;
                while (n9 < n5) {
                    c = (char)(c ^ this.mul(cArray[n + n7], cArray2[n2 + n8]));
                    ++n9;
                    ++n7;
                    n8 += n6;
                }
                cArray3[n3 + (i * n6 + j)] = c;
            }
        }
    }

    public static final boolean isIdentity(char[] cArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i == j && cArray[n2] != '\u0001' || i != j && cArray[n2] != '\u0000') {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public final void invertMatrix(char[] cArray, int n) throws IllegalArgumentException {
        int n2;
        int n3;
        int n4;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        char[] cArray2 = FECMath.createGFMatrix(1, n);
        char[] cArray3 = FECMath.createGFMatrix(1, n);
        for (n4 = 0; n4 < n; ++n4) {
            int n5;
            char c;
            int n6;
            n3 = -1;
            n2 = -1;
            boolean bl = false;
            if (nArray3[n4] != 1 && cArray[n4 * n + n4] != '\u0000') {
                n3 = n4;
                n2 = n4;
                bl = true;
            }
            if (!bl) {
                block1: for (n6 = 0; n6 < n; ++n6) {
                    if (nArray3[n6] == 1) continue;
                    for (c = '\u0000'; c < n; ++c) {
                        if (nArray3[c] == 0) {
                            if (cArray[n6 * n + c] == '\u0000') continue;
                            n3 = n6;
                            n2 = c;
                            bl = true;
                            break block1;
                        }
                        if (nArray3[c] <= 1) continue;
                        throw new IllegalArgumentException("singular matrix");
                    }
                }
            }
            if (!bl && n2 == -1) {
                throw new IllegalArgumentException("XXX pivot not found!");
            }
            bl = false;
            nArray3[n2] = nArray3[n2] + 1;
            if (n3 != n2) {
                for (n6 = 0; n6 < n; ++n6) {
                    c = cArray[n3 * n + n6];
                    cArray[n3 * n + n6] = cArray[n2 * n + n6];
                    cArray[n2 * n + n6] = c;
                }
            }
            nArray2[n4] = n3;
            nArray[n4] = n2;
            n6 = n2 * n;
            c = cArray[n6 + n2];
            if (c == '\u0000') {
                throw new IllegalArgumentException("singular matrix 2");
            }
            if (c != '\u0001') {
                c = this.inverse[c];
                cArray[n6 + n2] = '\u0001';
                for (n5 = 0; n5 < n; ++n5) {
                    cArray[n6 + n5] = this.mul(c, cArray[n6 + n5]);
                }
            }
            cArray2[n2] = '\u0001';
            if (!Util.arraysEqual(cArray, n6, cArray2, 0, n)) {
                n5 = 0;
                int n7 = 0;
                while (n7 < n) {
                    if (n7 != n2) {
                        c = cArray[n5 + n2];
                        cArray[n5 + n2] = '\u0000';
                        this.addMul(cArray, n5, cArray, n6, c, n);
                    }
                    ++n7;
                    n5 += n;
                }
            }
            cArray2[n2] = '\u0000';
        }
        for (n4 = n - 1; n4 >= 0; --n4) {
            if (nArray2[n4] < 0 || nArray2[n4] >= n) {
                System.err.println("AARGH, indxr[col] " + nArray2[n4]);
                continue;
            }
            if (nArray[n4] < 0 || nArray[n4] >= n) {
                System.err.println("AARGH, indxc[col] " + nArray[n4]);
                continue;
            }
            if (nArray2[n4] == nArray[n4]) continue;
            for (n3 = 0; n3 < n; ++n3) {
                n2 = cArray[n3 * n + nArray[n4]];
                cArray[n3 * n + nArray[n4]] = cArray[n3 * n + nArray2[n4]];
                cArray[n3 * n + nArray2[n4]] = n2;
            }
        }
    }

    public final void invertVandermonde(char[] cArray, int n) {
        char c;
        if (n == 1) {
            return;
        }
        char[] cArray2 = FECMath.createGFMatrix(1, n);
        char[] cArray3 = FECMath.createGFMatrix(1, n);
        char[] cArray4 = FECMath.createGFMatrix(1, n);
        int n2 = 1;
        char c2 = '\u0000';
        while (c2 < n) {
            cArray2[c2] = '\u0000';
            cArray4[c2] = cArray[n2];
            ++c2;
            n2 += n;
        }
        cArray2[n - 1] = cArray4[0];
        for (n2 = 1; n2 < n; ++n2) {
            c2 = cArray4[n2];
            for (c = n - 1 - (n2 - 1); c < n - 1; ++c) {
                char c3 = c;
                cArray2[c3] = (char)(cArray2[c3] ^ this.mul(c2, cArray2[c + 1]));
            }
            int n3 = n - 1;
            cArray2[n3] = (char)(cArray2[n3] ^ c2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            int n4;
            c2 = cArray4[n2];
            c = '\u0001';
            cArray3[n - 1] = '\u0001';
            for (n4 = n - 2; n4 >= 0; --n4) {
                cArray3[n4] = (char)(cArray2[n4 + 1] ^ this.mul(c2, cArray3[n4 + 1]));
                c = (char)(this.mul(c2, c) ^ cArray3[n4]);
            }
            for (n4 = 0; n4 < n; ++n4) {
                cArray[n4 * n + n2] = this.mul(this.inverse[c], cArray3[n4]);
            }
        }
    }

    public final char[] createEncodeMatrix(int n, int n2) {
        if (n > this.gfSize + 1 || n2 > this.gfSize + 1 || n > n2) {
            throw new IllegalArgumentException("Invalid parameters n=" + n2 + ",k=" + n + ",gfSize=" + this.gfSize);
        }
        char[] cArray = FECMath.createGFMatrix(n2, n);
        char[] cArray2 = FECMath.createGFMatrix(n2, n);
        cArray2[0] = '\u0001';
        int n3 = n;
        int n4 = 0;
        while (n4 < n2 - 1) {
            for (int i = 0; i < n; ++i) {
                cArray2[n3 + i] = this.gf_exp[this.modnn(n4 * i)];
            }
            ++n4;
            n3 += n;
        }
        this.invertVandermonde(cArray2, n);
        this.matMul(cArray2, n * n, cArray2, 0, cArray, n * n, n2 - n, n, n);
        Util.bzero(cArray, 0, n * n);
        n3 = 0;
        n4 = 0;
        while (n4 < n) {
            cArray[n3] = '\u0001';
            ++n4;
            n3 += n + 1;
        }
        return cArray;
    }

    protected final char[] createDecodeMatrix(char[] cArray, int[] nArray, int n, int n2) {
        char[] cArray2 = FECMath.createGFMatrix(n, n);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            System.arraycopy(cArray, nArray[n3] * n, cArray2, n4, n);
            ++n3;
            n4 += n;
        }
        this.invertMatrix(cArray2, n);
        return cArray2;
    }
}

