/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.util.io.win32;

import com.db4o.ext.Db4oIOException;
import com.db4o.io.IoAdapter;
import java.io.File;
import java.io.IOException;

public class Win32IoAdapter
extends IoAdapter {
    private long _handle;

    public Win32IoAdapter(String path, boolean lockFile, long initialLength, boolean readOnly) {
        try {
            this._handle = Win32IoAdapter.openFile(path, lockFile, initialLength);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public Win32IoAdapter() {
    }

    @Override
    public void close() throws Db4oIOException {
        try {
            Win32IoAdapter.closeFile(this.getHandle());
            this._handle = 0L;
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    @Override
    public void delete(String path) {
        new File(path).delete();
    }

    @Override
    public boolean exists(String path) {
        File existingFile = new File(path);
        return existingFile.exists() && existingFile.length() > 0L;
    }

    @Override
    public long getLength() throws Db4oIOException {
        try {
            return Win32IoAdapter.getLength(this.getHandle());
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    @Override
    public IoAdapter open(String path, boolean lockFile, long initialLength, boolean readOnly) throws Db4oIOException {
        return new Win32IoAdapter(path, lockFile, initialLength, readOnly);
    }

    @Override
    public int read(byte[] bytes, int length) throws Db4oIOException {
        try {
            return Win32IoAdapter.read(this.getHandle(), bytes, length);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    @Override
    public void seek(long pos) throws Db4oIOException {
        try {
            Win32IoAdapter.seek(this.getHandle(), pos);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    @Override
    public void sync() throws Db4oIOException {
        try {
            Win32IoAdapter.sync(this.getHandle());
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    @Override
    public void write(byte[] bytes, int length) throws Db4oIOException {
        try {
            Win32IoAdapter.write(this.getHandle(), bytes, length);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    @Override
    public void copy(long oldAddress, long newAddress, int length) throws Db4oIOException {
        try {
            Win32IoAdapter.copy(this.getHandle(), oldAddress, newAddress, length);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    private long getHandle() {
        if (0L == this._handle) {
            throw new IllegalStateException("File is not open.");
        }
        return this._handle;
    }

    private static native long openFile(String var0, boolean var1, long var2) throws IOException;

    private static native void closeFile(long var0) throws IOException;

    private static native long getLength(long var0) throws IOException;

    private static native int read(long var0, byte[] var2, int var3) throws IOException;

    private static native void seek(long var0, long var2) throws IOException;

    private static native void sync(long var0) throws IOException;

    private static native void write(long var0, byte[] var2, int var3) throws IOException;

    private static native void copy(long var0, long var2, long var4, int var6) throws IOException;

    static {
        System.loadLibrary("Win32IoAdapter");
    }
}

