/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.query;

import com.db4o.internal.Platform4;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class Predicate<ExtentType>
implements Serializable {
    public static final String PREDICATEMETHOD_NAME = "match";
    private Class<? extends ExtentType> _extentType;
    private transient Method cachedFilterMethod = null;

    public Predicate() {
        this(null);
    }

    public Predicate(Class<ExtentType> extentType) {
        this._extentType = extentType;
    }

    private Method getFilterMethod() {
        if (this.cachedFilterMethod != null) {
            return this.cachedFilterMethod;
        }
        Method[] methods = this.getClass().getMethods();
        for (int methodIdx = 0; methodIdx < methods.length; ++methodIdx) {
            String targetName;
            Method method = methods[methodIdx];
            if (!method.getName().equals(PREDICATEMETHOD_NAME) || method.getParameterTypes().length != 1 || "java.lang.Object".equals(targetName = method.getParameterTypes()[0].getName())) continue;
            this.cachedFilterMethod = method;
            return method;
        }
        throw new IllegalArgumentException("Invalid predicate.");
    }

    public Class<? extends ExtentType> extentType() {
        if (this._extentType == null) {
            this._extentType = this.figureOutExtentType();
        }
        return this._extentType;
    }

    public abstract boolean match(ExtentType var1);

    private Class<? extends ExtentType> figureOutExtentType() {
        return this.extentTypeFromGenericParameter();
    }

    private Class<? extends ExtentType> extentTypeFromGenericParameter() {
        Class extentType = this.filterParameterType();
        try {
            Type genericType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            if (genericType instanceof Class && extentType.isAssignableFrom((Class)genericType)) {
                extentType = (Class)genericType;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return extentType;
    }

    private Class<? extends ExtentType> filterParameterType() {
        return this.getFilterMethod().getParameterTypes()[0];
    }

    public boolean appliesTo(ExtentType candidate) {
        try {
            Method filterMethod = this.getFilterMethod();
            Platform4.setAccessible(filterMethod);
            Object ret = filterMethod.invoke((Object)this, candidate);
            return (Boolean)ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

